/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.parser.UnitProcessor;
import org.apache.fop.apps.Driver;
import org.apache.fop.image.SVGImage;
import org.apache.fop.image.analyser.AbstractImageReader;
import org.apache.fop.messaging.MessageHandler;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGReader
extends AbstractImageReader {
    public boolean verifySignature(String uri, BufferedInputStream fis) throws IOException {
        this.imageStream = fis;
        return this.loadImage(uri);
    }

    public String getMimeType() {
        return "image/svg+xml";
    }

    protected boolean loadImage(String uri) {
        try {
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(SVGImage.getParserName());
            SVGDocument doc = (SVGDocument)factory.createDocument(uri, (InputStream)this.imageStream);
            MUserAgent userAgent = new MUserAgent(new AffineTransform());
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent);
            SVGSVGElement e = doc.getRootElement();
            UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)ctx, (Element)e);
            String s = e.getAttributeNS(null, "width");
            if (s.length() == 0) {
                s = "100%";
            }
            this.width = (int)UnitProcessor.svgHorizontalLengthToUserSpace((String)s, (String)"width", (UnitProcessor.Context)uctx);
            s = e.getAttributeNS(null, "height");
            if (s.length() == 0) {
                s = "100%";
            }
            this.height = (int)UnitProcessor.svgVerticalLengthToUserSpace((String)s, (String)"height", (UnitProcessor.Context)uctx);
            return true;
        }
        catch (NoClassDefFoundError ncdfe) {
            MessageHandler.errorln("Batik not in class path");
            return false;
        }
        catch (Exception e) {
            MessageHandler.errorln("Could not load external SVG: " + e.getMessage());
            return false;
        }
    }

    protected class MUserAgent
    extends UserAgentAdapter {
        AffineTransform currentTransform = null;

        protected MUserAgent(AffineTransform at) {
            this.currentTransform = at;
        }

        public void displayError(String message) {
            MessageHandler.error(message);
        }

        public void displayError(Exception ex) {
            MessageHandler.error(ExceptionUtil.printStackTrace((Throwable)ex));
        }

        public void displayMessage(String message) {
            MessageHandler.log(message);
        }

        public float getPixelToMM() {
            return 0.35277778f;
        }

        public float getPixelUnitToMillimeter() {
            return 0.35277778f;
        }

        public String getLanguages() {
            return "en";
        }

        public String getMedia() {
            return "print";
        }

        public boolean isXMLParserValidating() {
            return true;
        }

        public String getUserStyleSheetURI() {
            return null;
        }

        public String getXMLParserClassName() {
            return Driver.getParserClassName();
        }

        public AffineTransform getTransform() {
            return this.currentTransform;
        }

        public Dimension2D getViewportSize() {
            return new Dimension(100, 100);
        }
    }
}

