/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.HuffmanEncoded;
import com.coyotegulch.jisp.HuffmanException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Huffman {
    public static HuffmanEncoded encode(Object object) throws IOException {
        if (object instanceof Serializable || object instanceof Externalizable) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            return Huffman.compress(byteArrayOutputStream.toByteArray());
        }
        throw new HuffmanException("can't encode non-serializable object");
    }

    public static Object decode(HuffmanEncoded huffmanEncoded) throws IOException, ClassNotFoundException {
        byte[] byArray = Huffman.decompress(huffmanEncoded);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    private static void heapAdjust(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray2[n2 - 1];
        while (n2 <= n / 2) {
            int n4 = n2 + n2;
            if (n4 < n && nArray[nArray2[n4 - 1]] > nArray[nArray2[n4]]) {
                ++n4;
            }
            if (nArray[n3] < nArray[nArray2[n4 - 1]]) break;
            nArray2[n2 - 1] = nArray2[n4 - 1];
            n2 = n4;
        }
        nArray2[n2 - 1] = n3;
    }

    private static HuffmanEncoded compress(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        int[] nArray = new int[512];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[512];
        HuffmanEncoded huffmanEncoded = new HuffmanEncoded();
        int[] nArray4 = huffmanEncoded.m_header.m_code;
        short[] sArray = huffmanEncoded.m_header.m_codeLength;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = byArray[n4] < 0 ? 256 + byArray[n4] : byArray[n4];
            nArray[n5] = nArray[n5] + 1;
            ++n4;
        }
        int n6 = 0;
        n4 = 0;
        while (n4 < 256) {
            if (nArray[n4] != 0) {
                nArray2[n6] = n4;
                ++n6;
            }
            ++n4;
        }
        n4 = n6;
        while (n4 > 0) {
            Huffman.heapAdjust(nArray, nArray2, n6, n4);
            --n4;
        }
        while (n6 > 1) {
            int n7 = nArray2[0];
            nArray2[0] = nArray2[--n6];
            Huffman.heapAdjust(nArray, nArray2, n6, 1);
            nArray[256 + n6] = nArray[nArray2[0]] + nArray[n7];
            nArray3[n7] = 256 + n6;
            nArray3[nArray2[0]] = -256 - n6;
            nArray2[0] = 256 + n6;
            Huffman.heapAdjust(nArray, nArray2, n6, 1);
        }
        nArray3[256 + n6] = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < 256) {
            if (nArray[n10] == 0) {
                nArray4[n10] = 0;
                sArray[n10] = 0;
            } else {
                n4 = 0;
                n = 1;
                int n11 = 0;
                int n12 = nArray3[n10];
                while (n12 != 0) {
                    if (n12 < 0) {
                        n11 += n;
                        n12 = -n12;
                    }
                    n12 = nArray3[n12];
                    n <<= 1;
                    ++n4;
                }
                nArray4[n10] = n11;
                sArray[n10] = (short)n4;
                if (n11 > n8) {
                    n8 = n11;
                }
                if (n4 > n9) {
                    n9 = n4;
                }
            }
            ++n10;
        }
        if (n9 > 32) {
            throw new HuffmanException("code size overflow");
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = -1;
        if (n8 == 0) {
            byArray2[0] = byArray[0];
            n13 = 1;
            huffmanEncoded.m_header.m_oneValue = true;
        } else {
            n = 0;
            while (n < n2) {
                int n16 = byArray[n] < 0 ? 256 + byArray[n] : byArray[n];
                int n17 = 1 << sArray[n16] - 1;
                n4 = 0;
                while (n4 < sArray[n16]) {
                    if (n15 == 7) {
                        byArray2[n13] = n14;
                        if (++n13 == n2) {
                            throw new HuffmanException("compression overflow");
                        }
                        n15 = 0;
                        n14 = 0;
                    } else {
                        ++n15;
                        n14 = (byte)(n14 << 1);
                    }
                    if ((nArray4[n16] & n17) != 0) {
                        n14 = (byte)(n14 | 1);
                    }
                    n17 >>>= 1;
                    ++n4;
                }
                ++n;
            }
            byArray2[n13] = n14 = (int)((byte)(n14 << 7 - n15));
            ++n13;
        }
        huffmanEncoded.m_header.m_originalLength = n2;
        huffmanEncoded.m_header.m_dataLength = n13;
        byte[] byArray3 = new byte[n13];
        n4 = 0;
        while (n4 < n13) {
            byArray3[n4] = byArray2[n4];
            ++n4;
        }
        huffmanEncoded.m_compressedData = byArray3;
        return huffmanEncoded;
    }

    private static byte[] decompress(HuffmanEncoded huffmanEncoded) {
        int n;
        int n2;
        int n3;
        byte[] byArray = new byte[huffmanEncoded.m_header.m_originalLength];
        if (huffmanEncoded.m_header.m_oneValue) {
            int n4 = 0;
            while (n4 < byArray.length) {
                byArray[n4] = huffmanEncoded.m_compressedData[0];
                ++n4;
            }
            return byArray;
        }
        int[] nArray = new int[256];
        byte[] byArray2 = new byte[256];
        int[] nArray2 = huffmanEncoded.m_header.m_code;
        short[] sArray = huffmanEncoded.m_header.m_codeLength;
        int n5 = 0;
        while (n5 < 256) {
            byArray2[n5] = (byte)n5;
            if ((nArray2[n5] | sArray[n5]) != 0) {
                n3 = 0;
                n2 = 1 << sArray[n5] - 1;
                n = 0;
                while (n < sArray[n5]) {
                    n3 = n3 * 2 + 1;
                    if ((nArray2[n5] & n2) != 0) {
                        ++n3;
                    }
                    n2 >>>= 1;
                    ++n;
                }
                nArray[n5] = n3;
            }
            ++n5;
        }
        n = 1;
        while (n < 256) {
            int n6 = nArray[n];
            byte by = byArray2[n];
            n5 = n;
            while (n5 != 0 && nArray[n5 - 1] > n6) {
                nArray[n5] = nArray[n5 - 1];
                byArray2[n5] = byArray2[n5 - 1];
                --n5;
            }
            nArray[n5] = n6;
            byArray2[n5] = by;
            ++n;
        }
        n5 = 0;
        while (nArray[n5] == 0) {
            ++n5;
        }
        n3 = 0;
        n = n5;
        n2 = 128;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n7 < huffmanEncoded.m_header.m_originalLength) {
            n3 = n3 * 2 + 1;
            if ((huffmanEncoded.m_compressedData[n8] & n2) != 0) {
                ++n3;
            }
            while (nArray[n] < n3) {
                ++n;
            }
            if (n3 == nArray[n]) {
                byArray[n9] = byArray2[n];
                ++n9;
                ++n7;
                n3 = 0;
                n = n5;
            }
            if (n2 > 1) {
                n2 >>>= 1;
                continue;
            }
            n2 = 128;
            ++n8;
        }
        return byArray;
    }
}

