<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page/setupfolders">
<content>

<xsl:variable name="deletelink_prefix"
  select="'setupfolders.xsl?act=setupfolders&amp;delete=true&amp;folderNr='"/>
<xsl:variable name="add_action"
  select="'setupfolders.xsl?act=setupfolders&amp;add=true'"/>

   <!-- Header stuff -->
   <table cellpadding="4" cellspacing="2" border="0" width="100%">
    <tbody>
      <!-- Header row 1 -->
      <tr>
	<td class="simpletext" height="22">
		<img align="middle" hspace="5" src="images/gnome/foldersetup.png"/>
		<xsl:value-of select="normalize-space(setupfolders/headertext1)" />&#160;<xsl:value-of select="normalize-space(setupfolders/username)" />
	</td>
      </tr>
    </tbody>
   </table>

   <!-- Error handling -->
   <xsl:if test="setupfolders/error">
      <hr/>
      <table>
       <tbody>
	 <tr>
	    <td rowspan="2">
	       <img align="middle" border="0" src="images/gnome/dialog-error.png" />
            </td>
            <td class="bold_red">
               <xsl:value-of select="setupfolders/error/prefixtext"/>
	       "<xsl:value-of select="setupfolders/error/folderName"/>"
	       <xsl:value-of select="setupfolders/error/suffixtext"/>
	    </td>
	 </tr>
	 <tr>
	    <td class="simpletext">
	       <span class="bold_red"><xsl:value-of select="setupfolders/error/content_label"/>:&#160;</span>
	       <xsl:value-of select="setupfolders/error/content"/>
	    </td>
	 </tr>
	</tbody>
      </table>
      <hr/>
      <xsl:comment>Error content: <xsl:value-of select="setupfolders/error/content"/></xsl:comment>
      <xsl:comment>Error stack: <xsl:value-of select="setupfolders/error/stack"/></xsl:comment>
   </xsl:if>

		
   <!-- Folder table -->
   <table cellpadding="3" cellspacing="0" border="0" width="100%">
   <tbody>
      <!-- Header row with user name -->
      <tr class="bg_for_invert">
	 <td class="white_text" height="22" colspan="3">
	    <xsl:value-of select="normalize-space(setupfolders/login/header)" />:&#160;<xsl:value-of select="normalize-space(setupfolders/login/content)" />
	 </td>
      </tr>
      <!-- header row with host information -->
      <tr class="field_dark_bg">
         <td class="infotext" colspan="3">
		<span class="bold">
			<xsl:value-of select="normalize-space(setupfolders/host/header)" />&#160;<xsl:value-of select="normalize-space(setupfolders/host/content)" />	
		</span>
	 </td>
      </tr>

      <!-- List of folders -->
      <xsl:for-each select="setupfolders/folder">
	  <tr>
	    <xsl:attribute name="class">
	      <xsl:choose>
	        <xsl:when test="position() mod 2">field_light_bg</xsl:when>
	        <xsl:otherwise>field_middle_bg</xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
	    <td align="left">&#160;</td>
	    <td>
	      <!-- seem to need a table to format correctly icon + text -->
	      <table>
	        <tr>
  	           <td>
                      <xsl:for-each select="level">&#160;&#160;&#160;</xsl:for-each>
	           </td>
                   <td>
		      <xsl:choose>
		        <xsl:when test="isselectable">
		         <img src="images/gnome/folder-open.png"/>
		        </xsl:when>
		        <xsl:otherwise>
		         <img src="images/gnome/directory.png"/>
		        </xsl:otherwise>
		      </xsl:choose>
	           </td>
	           <td class="simpletext">
		      <xsl:value-of select="normalize-space(name)"/>
	           </td>
		</tr>
	      </table>
	    </td>
	    <td class="simpletext">
		<xsl:choose>
		   <xsl:when test="isdeleteable">
			<a>
			   <xsl:attribute name="href"><xsl:value-of
			   select="concat($deletelink_prefix,normalize-space(nr))"/>
                           </xsl:attribute>
			   <img src="images/gnome/flag-deleted.png"
			   border="0"/>&#160;
                           <xsl:value-of
			   select="normalize-space(../actiontext1)" />
                        </a>
		   </xsl:when>
		   <xsl:otherwise>
			<xsl:value-of select="normalize-space(../actionnote1)" />
		   </xsl:otherwise>
		</xsl:choose>
	    </td>
	 </tr>
	</xsl:for-each>

	<!-- Warning about deleting folders -->
	<tr class="simpletext">
           <td colspan="3">
	      <span class="bold_red"><xsl:value-of select="normalize-space(setupfolders/warning/header)" /></span>&#160;<xsl:value-of select="normalize-space(setupfolders/warning/content)" />
	   </td>
	</tr>

      </tbody>
     </table>
     <hr />

     <!-- "add folder" -->
     <form method="post">
        <xsl:attribute name="action">
	   <xsl:value-of select="$add_action"/>
	</xsl:attribute>
	<table class="field_dark_bg" width="100%">
	<tbody>
	   <tr>
		<td class="link_text" align="right" width="15%">
		   <xsl:value-of select="normalize-space(setupfolders/add/header)" /></td>
		<td class="simpletext" align="center" width="40%">
		   <input class="simpletext" size="40" name="name" type="text">
			<xsl:attribute name="value"></xsl:attribute>
		   </input>
		</td>
		<td class="simpletext" align="center" width="10%">
		   <input name="add" class="simpletext" type="submit">
			<xsl:attribute name="value">
			    <xsl:value-of select="normalize-space(setupfolders/add/action)" />
			</xsl:attribute>
		   </input>
		</td>
	        <td class="simpletext" width="35%">
		   <input class="simpletext" name="messagefolder" value="true" type="checkbox">
		      <xsl:attribute name="checked">checked</xsl:attribute>
		   </input>
	           <xsl:value-of select="normalize-space(setupfolders/add/option)"/>
	        </td>

	    </tr>
	 </tbody>
      </table>
    </form>	
		
    <!-- for testing -->
    <!-- <xsl:copy-of select="setupfolders" /> -->

 </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
