/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.ARGBChannel;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;

public class DisplacementMapRed
extends AbstractRed {
    private static final boolean TIME = false;
    private static final boolean USE_NN = false;
    private float scaleX;
    private float scaleY;
    private ARGBChannel xChannel;
    private ARGBChannel yChannel;
    CachableRed image;
    CachableRed offsets;
    int maxOffX;
    int maxOffY;
    RenderingHints hints;
    TileOffsets[] xOffsets;
    TileOffsets[] yOffsets;

    public DisplacementMapRed(CachableRed cachableRed, CachableRed cachableRed2, ARGBChannel aRGBChannel, ARGBChannel aRGBChannel2, float f, float f2, RenderingHints renderingHints) {
        if (aRGBChannel == null) {
            throw new IllegalArgumentException("Must provide xChannel");
        }
        if (aRGBChannel2 == null) {
            throw new IllegalArgumentException("Must provide yChannel");
        }
        this.offsets = cachableRed2;
        this.scaleX = f;
        this.scaleY = f2;
        this.xChannel = aRGBChannel;
        this.yChannel = aRGBChannel2;
        this.hints = renderingHints;
        this.maxOffX = (int)Math.ceil(f / 2.0f);
        this.maxOffY = (int)Math.ceil(f2 / 2.0f);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = cachableRed.getBounds();
        rectangle2.x -= this.maxOffX;
        rectangle2.width += 2 * this.maxOffX;
        rectangle2.y -= this.maxOffY;
        rectangle2.height += 2 * this.maxOffY;
        cachableRed = new PadRed(cachableRed, rectangle2, PadMode.ZERO_PAD, null);
        this.image = cachableRed = new TileCacheRed(cachableRed);
        ColorModel colorModel = cachableRed.getColorModel();
        colorModel = GraphicsUtil.coerceColorModel(colorModel, true);
        this.init(cachableRed, rectangle, colorModel, cachableRed.getSampleModel(), rectangle.x, rectangle.y, null);
        this.xOffsets = new TileOffsets[this.getNumXTiles()];
        this.yOffsets = new TileOffsets[this.getNumYTiles()];
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        WritableRaster writableRaster = this.makeTile(n, n2);
        Rectangle rectangle = writableRaster.getBounds();
        Raster raster = this.offsets.getData(rectangle);
        ColorModel colorModel = this.offsets.getColorModel();
        GraphicsUtil.coerceData((WritableRaster)raster, colorModel, false);
        TileOffsets tileOffsets = this.getXOffsets(n);
        TileOffsets tileOffsets2 = this.getYOffsets(n2);
        if (this.image.getColorModel().isAlphaPremultiplied()) {
            this.filterBL(raster, writableRaster, tileOffsets.tile, tileOffsets.off, tileOffsets2.tile, tileOffsets2.off);
        } else {
            this.filterBLPre(raster, writableRaster, tileOffsets.tile, tileOffsets.off, tileOffsets2.tile, tileOffsets2.off);
        }
        return writableRaster;
    }

    public TileOffsets getXOffsets(int n) {
        TileOffsets tileOffsets = this.xOffsets[n - this.getMinTileX()];
        if (tileOffsets != null) {
            return tileOffsets;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.getSampleModel();
        int n2 = singlePixelPackedSampleModel.getOffset(0, 0);
        int n3 = singlePixelPackedSampleModel.getWidth();
        int n4 = n3 + 2 * this.maxOffX;
        int n5 = this.getTileGridXOffset() + n * n3 - this.maxOffX - this.image.getTileGridXOffset();
        int n6 = n5 + n4 - 1;
        int n7 = (int)Math.floor((double)n5 / (double)n3);
        int n8 = (int)Math.floor((double)n6 / (double)n3);
        int n9 = n5 - n7 * n3;
        int n10 = n3;
        int n11 = (n8 + 1) * n3 - 1 - n6;
        this.xOffsets[n - this.getMinTileX()] = tileOffsets = new TileOffsets(n4, n2, 1, n9, n10, n11, n7, n8);
        return tileOffsets;
    }

    public TileOffsets getYOffsets(int n) {
        TileOffsets tileOffsets = this.yOffsets[n - this.getMinTileY()];
        if (tileOffsets != null) {
            return tileOffsets;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.getSampleModel();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        int n3 = singlePixelPackedSampleModel.getHeight();
        int n4 = n3 + 2 * this.maxOffY;
        int n5 = this.getTileGridYOffset() + n * n3 - this.maxOffY - this.image.getTileGridYOffset();
        int n6 = n5 + n4 - 1;
        int n7 = (int)Math.floor((double)n5 / (double)n3);
        int n8 = (int)Math.floor((double)n6 / (double)n3);
        int n9 = n5 - n7 * n3;
        int n10 = n3;
        int n11 = (n8 + 1) * n3 - 1 - n6;
        this.yOffsets[n - this.getMinTileY()] = tileOffsets = new TileOffsets(n4, 0, n2, n9, n10, n11, n7, n8);
        return tileOffsets;
    }

    public void filterBL(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = this.maxOffX;
        int n4 = this.maxOffY;
        int n5 = n3 + n;
        int n6 = n4 + n2;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - raster.getSampleModelTranslateX(), writableRaster.getMinY() - raster.getSampleModelTranslateY());
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        int n11 = n9 - n;
        int n12 = n10 - n;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n13 = this.xChannel.toInt() * 8;
        int n14 = this.yChannel.toInt() * 8;
        int n15 = n7;
        int n16 = n8;
        int n17 = (int)((double)this.scaleX / 255.0 * 32768.0 + 0.5);
        int n18 = (int)(-127.5 * (double)n17 - 0.5);
        int n19 = (int)((double)this.scaleY / 255.0 * 32768.0 + 0.5);
        int n20 = (int)(-127.5 * (double)n19 - 0.5);
        long l = System.currentTimeMillis();
        int n21 = nArray[0] - 1;
        int n22 = nArray3[0] - 1;
        int[] nArray7 = null;
        for (int i = n4; i < n6; ++i) {
            int n23 = n3;
            while (n23 < n5) {
                int n24;
                int n25;
                int n26;
                int n27 = nArray6[n16];
                int n28 = n17 * (n27 >> n13 & 0xFF) + n18;
                int n29 = n19 * (n27 >> n14 & 0xFF) + n20;
                int n30 = n23 + (n28 >> 15);
                int n31 = i + (n29 >> 15);
                if (n21 != nArray[n30] || n22 != nArray3[n31]) {
                    n21 = nArray[n30];
                    n22 = nArray3[n31];
                    nArray7 = ((DataBufferInt)this.image.getTile(n21, n22).getDataBuffer()).getBankData()[0];
                }
                void var36_38 = nArray7[nArray2[n30] + nArray4[n31]];
                int n32 = nArray[n30 + 1];
                int n33 = nArray3[n31 + 1];
                if (n22 == n33) {
                    if (n21 == n32) {
                        n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                        n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                        n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                    } else {
                        n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                        nArray7 = ((DataBufferInt)this.image.getTile(n32, n22).getDataBuffer()).getBankData()[0];
                        n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                        n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                        n21 = n32;
                    }
                } else if (n21 == n32) {
                    n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n21, n33).getDataBuffer()).getBankData()[0];
                    n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                    n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                    n22 = n33;
                } else {
                    nArray7 = ((DataBufferInt)this.image.getTile(n21, n33).getDataBuffer()).getBankData()[0];
                    n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n32, n33).getDataBuffer()).getBankData()[0];
                    n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n32, n22).getDataBuffer()).getBankData()[0];
                    n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                    n21 = n32;
                }
                int n34 = n28 & Short.MAX_VALUE;
                int n35 = n29 & Short.MAX_VALUE;
                int n36 = var36_38 >>> 16 & 0xFF00;
                int n37 = n26 >>> 16 & 0xFF00;
                int n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n36 = n25 >>> 16 & 0xFF00;
                n37 = n24 >>> 16 & 0xFF00;
                int n39 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                int n40 = ((n38 << 15) + (n39 - n38) * n35 + 0x400000 & 0x7F800000) << 1;
                n36 = var36_38 >> 8 & 0xFF00;
                n37 = n26 >> 8 & 0xFF00;
                n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n36 = n25 >> 8 & 0xFF00;
                n37 = n24 >> 8 & 0xFF00;
                n39 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n40 |= ((n38 << 15) + (n39 - n38) * n35 + 0x400000 & 0x7F800000) >>> 7;
                n36 = var36_38 & 0xFF00;
                n37 = n26 & 0xFF00;
                n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n36 = n25 & 0xFF00;
                n37 = n24 & 0xFF00;
                n39 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n40 |= ((n38 << 15) + (n39 - n38) * n35 + 0x400000 & 0x7F800000) >>> 15;
                n36 = var36_38 << 8 & 0xFF00;
                n37 = n26 << 8 & 0xFF00;
                n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n36 = n25 << 8 & 0xFF00;
                n37 = n24 << 8 & 0xFF00;
                n39 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                nArray5[n15] = n40 |= ((n38 << 15) + (n39 - n38) * n35 + 0x400000 & 0x7F800000) >>> 23;
                ++n23;
                ++n15;
                ++n16;
            }
            n15 += n11;
            n16 += n12;
        }
    }

    public void filterBLPre(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = this.maxOffX;
        int n4 = this.maxOffY;
        int n5 = n3 + n;
        int n6 = n4 + n2;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - raster.getSampleModelTranslateX(), writableRaster.getMinY() - raster.getSampleModelTranslateY());
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        int n11 = n9 - n;
        int n12 = n10 - n;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n13 = this.xChannel.toInt() * 8;
        int n14 = this.yChannel.toInt() * 8;
        int n15 = n7;
        int n16 = n8;
        int n17 = (int)((double)this.scaleX / 255.0 * 32768.0 + 0.5);
        int n18 = (int)(-127.5 * (double)n17 - 0.5);
        int n19 = (int)((double)this.scaleY / 255.0 * 32768.0 + 0.5);
        int n20 = (int)(-127.5 * (double)n19 - 0.5);
        long l = System.currentTimeMillis();
        int n21 = nArray[0] - 1;
        int n22 = nArray3[0] - 1;
        int[] nArray7 = null;
        for (int i = n4; i < n6; ++i) {
            int n23 = n3;
            while (n23 < n5) {
                int n24;
                int n25;
                int n26;
                int n27 = nArray6[n16];
                int n28 = n17 * (n27 >> n13 & 0xFF) + n18;
                int n29 = n19 * (n27 >> n14 & 0xFF) + n20;
                int n30 = n23 + (n28 >> 15);
                int n31 = i + (n29 >> 15);
                if (n21 != nArray[n30] || n22 != nArray3[n31]) {
                    n21 = nArray[n30];
                    n22 = nArray3[n31];
                    nArray7 = ((DataBufferInt)this.image.getTile(n21, n22).getDataBuffer()).getBankData()[0];
                }
                void var36_38 = nArray7[nArray2[n30] + nArray4[n31]];
                int n32 = nArray[n30 + 1];
                int n33 = nArray3[n31 + 1];
                if (n22 == n33) {
                    if (n21 == n32) {
                        n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                        n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                        n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                    } else {
                        n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                        nArray7 = ((DataBufferInt)this.image.getTile(n32, n22).getDataBuffer()).getBankData()[0];
                        n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                        n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                        n21 = n32;
                    }
                } else if (n21 == n32) {
                    n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n21, n33).getDataBuffer()).getBankData()[0];
                    n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                    n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                    n22 = n33;
                } else {
                    nArray7 = ((DataBufferInt)this.image.getTile(n21, n33).getDataBuffer()).getBankData()[0];
                    n25 = nArray7[nArray2[n30] + nArray4[n31 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n32, n33).getDataBuffer()).getBankData()[0];
                    n24 = nArray7[nArray2[n30 + 1] + nArray4[n31 + 1]];
                    nArray7 = ((DataBufferInt)this.image.getTile(n32, n22).getDataBuffer()).getBankData()[0];
                    n26 = nArray7[nArray2[n30 + 1] + nArray4[n31]];
                    n21 = n32;
                }
                int n34 = n28 & Short.MAX_VALUE;
                int n35 = n29 & Short.MAX_VALUE;
                int n36 = var36_38 >>> 16 & 0xFF00;
                int n37 = n26 >>> 16 & 0xFF00;
                int n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                int n39 = (n36 >> 8) * 65793 + 128 >> 8;
                int n40 = (n37 >> 8) * 65793 + 128 >> 8;
                n36 = n25 >>> 16 & 0xFF00;
                n37 = n24 >>> 16 & 0xFF00;
                int n41 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                int n42 = (n36 >> 8) * 65793 + 128 >> 8;
                int n43 = (n37 >> 8) * 65793 + 128 >> 8;
                int n44 = ((n38 << 15) + (n41 - n38) * n35 + 0x400000 & 0x7F800000) << 1;
                n36 = (var36_38 >> 16 & 0xFF) * n39 + 128 >> 8;
                n37 = (n26 >> 16 & 0xFF) * n40 + 128 >> 8;
                n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n36 = (n25 >> 16 & 0xFF) * n42 + 128 >> 8;
                n37 = (n24 >> 16 & 0xFF) * n43 + 128 >> 8;
                n41 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n44 |= ((n38 << 15) + (n41 - n38) * n35 + 0x400000 & 0x7F800000) >>> 7;
                n36 = (var36_38 >> 8 & 0xFF) * n39 + 128 >> 8;
                n37 = (n26 >> 8 & 0xFF) * n40 + 128 >> 8;
                n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n36 = (n25 >> 8 & 0xFF) * n42 + 128 >> 8;
                n37 = (n24 >> 8 & 0xFF) * n43 + 128 >> 8;
                n41 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n44 |= ((n38 << 15) + (n41 - n38) * n35 + 0x400000 & 0x7F800000) >>> 15;
                n36 = (var36_38 & 0xFF) * n39 + 128 >> 8;
                n37 = (n26 & 0xFF) * n40 + 128 >> 8;
                n38 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                n36 = (n25 & 0xFF) * n42 + 128 >> 8;
                n37 = (n24 & 0xFF) * n43 + 128 >> 8;
                n41 = n36 + ((n37 - n36) * n34 + 16384 >> 15) & 0xFFFF;
                nArray5[n15] = n44 |= ((n38 << 15) + (n41 - n38) * n35 + 0x400000 & 0x7F800000) >>> 23;
                ++n23;
                ++n15;
                ++n16;
            }
            n15 += n11;
            n16 += n12;
        }
    }

    public void filterNN(Raster raster, WritableRaster writableRaster, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = this.maxOffX;
        int n4 = this.maxOffY;
        int n5 = n3 + n;
        int n6 = n4 + n2;
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n9 = singlePixelPackedSampleModel.getScanlineStride();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        int n11 = n9 - n;
        int n12 = n10 - n;
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        int n13 = this.xChannel.toInt() * 8;
        int n14 = this.yChannel.toInt() * 8;
        int n15 = (int)((double)this.scaleX / 255.0 * 32768.0 + 0.5);
        int n16 = (int)((double)this.scaleY / 255.0 * 32768.0 + 0.5);
        int n17 = (int)(-127.5 * (double)n15 - 0.5) + 16384;
        int n18 = (int)(-127.5 * (double)n16 - 0.5) + 16384;
        int n19 = n7;
        int n20 = n8;
        long l = System.currentTimeMillis();
        int n21 = nArray[0] - 1;
        int n22 = nArray3[0] - 1;
        int[] nArray7 = null;
        for (int i = n4; i < n6; ++i) {
            for (int j = n3; j < n5; ++j) {
                int n23 = nArray6[n20];
                int n24 = n15 * (n23 >> n13 & 0xFF) + n17;
                int n25 = n16 * (n23 >> n14 & 0xFF) + n18;
                int n26 = j + (n24 >> 15);
                int n27 = i + (n25 >> 15);
                if (n21 != nArray[n26] || n22 != nArray3[n27]) {
                    n21 = nArray[n26];
                    n22 = nArray3[n27];
                    nArray7 = ((DataBufferInt)this.image.getTile(n21, n22).getDataBuffer()).getBankData()[0];
                }
                nArray5[n19] = nArray7[nArray2[n26] + nArray4[n27]];
                ++n19;
                ++n20;
            }
            n19 += n11;
            n20 += n12;
        }
    }

    static class TileOffsets {
        int[] tile;
        int[] off;

        TileOffsets(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.tile = new int[n + 1];
            this.off = new int[n + 1];
            if (n7 == n8) {
                n5 -= n6;
            }
            for (int i = 0; i < n; ++i) {
                this.tile[i] = n7++;
                this.off[i] = n2 + n4 * n3;
                if (++n4 != n5) continue;
                n4 = 0;
                if (n7 != n8) continue;
                n5 -= n6;
            }
            this.tile[n] = this.tile[n - 1];
            this.off[n] = this.off[n - 1];
        }
    }
}

