/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.OrNameCombiner;
import org.eclipse.jdt.internal.core.search.matching.OrPathCombiner;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;

public class OrPattern
extends SearchPattern {
    public SearchPattern leftPattern;
    public SearchPattern rightPattern;

    public OrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(-1, false);
        this.leftPattern = leftPattern;
        this.rightPattern = rightPattern;
        this.matchMode = Math.min(leftPattern.matchMode, rightPattern.matchMode);
        this.isCaseSensitive = leftPattern.isCaseSensitive || rightPattern.isCaseSensitive;
        this.needsResolve = leftPattern.needsResolve || rightPattern.needsResolve;
    }

    protected void decodeIndexEntry(IEntryResult entry) {
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
    }

    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, IJavaSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IIndexSearchRequestor orCombiner = detailLevel == 1 ? new OrNameCombiner(requestor) : new OrPathCombiner(requestor);
        this.leftPattern.findIndexMatches(input, orCombiner, detailLevel, progressMonitor, scope);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.rightPattern.findIndexMatches(input, orCombiner, detailLevel, progressMonitor, scope);
    }

    public char[] indexEntryPrefix() {
        return null;
    }

    protected int matchContainer() {
        return this.leftPattern.matchContainer() | this.rightPattern.matchContainer();
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        return this.leftPattern.matchesBinary(binaryInfo, enclosingBinaryInfo) || this.rightPattern.matchesBinary(binaryInfo, enclosingBinaryInfo);
    }

    protected boolean matchIndexEntry() {
        return this.leftPattern.matchIndexEntry() || this.rightPattern.matchIndexEntry();
    }

    protected void matchReportReference(AstNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        int leftLevel = this.leftPattern.matchLevel(reference, true);
        if (leftLevel == 2 || leftLevel == 3) {
            this.leftPattern.matchReportReference(reference, element, accuracy, locator);
        } else {
            this.rightPattern.matchReportReference(reference, element, accuracy, locator);
        }
    }

    public String toString() {
        return String.valueOf(this.leftPattern.toString()) + "\n| " + this.rightPattern.toString();
    }

    public void initializePolymorphicSearch(MatchLocator locator, IProgressMonitor progressMonitor) {
        this.leftPattern.initializePolymorphicSearch(locator, progressMonitor);
        this.rightPattern.initializePolymorphicSearch(locator, progressMonitor);
    }

    public boolean isPolymorphicSearch() {
        return this.leftPattern.isPolymorphicSearch() || this.rightPattern.isPolymorphicSearch();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        switch (this.leftPattern.matchLevel(node, resolve)) {
            case 0: {
                return this.rightPattern.matchLevel(node, resolve);
            }
            case 1: {
                return 1;
            }
            case 3: {
                int rightLevel = this.rightPattern.matchLevel(node, resolve);
                if (rightLevel != 0) {
                    return rightLevel;
                }
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public int matchLevel(Binding binding) {
        switch (this.leftPattern.matchLevel(binding)) {
            case 0: {
                return this.rightPattern.matchLevel(binding);
            }
            case 1: {
                return 1;
            }
            case 3: {
                int rightLevel = this.rightPattern.matchLevel(binding);
                if (rightLevel != 0) {
                    return rightLevel;
                }
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }
}

