/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentInfo;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.Util;

public class JarPackageFragmentRoot
extends PackageFragmentRoot {
    public static final String[] NO_STRINGS = new String[0];
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath jarPath;

    protected JarPackageFragmentRoot(IPath jarPath, IJavaProject project) {
        super(null, project, jarPath.lastSegment());
        this.jarPath = jarPath;
    }

    protected JarPackageFragmentRoot(IResource resource, IJavaProject project) {
        super(resource, project, resource.getName());
        this.jarPath = resource.getFullPath();
    }

    protected boolean computeChildren(OpenableElementInfo info) throws JavaModelException {
        ArrayList vChildren = new ArrayList();
        this.computeJarChildren((JarPackageFragmentRootInfo)info, vChildren);
        IJavaElement[] children = new IJavaElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected void computeJarChildren(JarPackageFragmentRootInfo info, ArrayList vChildren) throws JavaModelException {
        ZipFile jar = null;
        try {
            try {
                jar = this.getJar();
                HashMap<String, ArrayList[]> packageFragToTypes = new HashMap<String, ArrayList[]>();
                packageFragToTypes.put("", new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
                Enumeration<? extends ZipEntry> e = jar.entries();
                block4: while (e.hasMoreElements()) {
                    String packageName;
                    String fileName;
                    ZipEntry member = e.nextElement();
                    String entryName = member.getName();
                    if (member.isDirectory()) {
                        int last = entryName.length() - 1;
                        entryName = entryName.substring(0, last);
                        entryName = entryName.replace('/', '.');
                        while (!packageFragToTypes.containsKey(entryName)) {
                            packageFragToTypes.put(entryName, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
                            last = entryName.lastIndexOf(46);
                            if (last < 0) continue block4;
                            entryName = entryName.substring(0, last);
                        }
                        continue;
                    }
                    int lastSeparator = entryName.lastIndexOf(47);
                    if (lastSeparator != -1) {
                        entryName = entryName.replace('/', '.');
                        fileName = entryName.substring(lastSeparator + 1);
                        packageName = entryName.substring(0, lastSeparator);
                    } else {
                        fileName = entryName;
                        packageName = "";
                    }
                    String currentPackageName = packageName;
                    while (!packageFragToTypes.containsKey(currentPackageName)) {
                        packageFragToTypes.put(currentPackageName, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
                        int last = currentPackageName.lastIndexOf(46);
                        if (last < 0) break;
                        currentPackageName = currentPackageName.substring(0, last);
                    }
                    ArrayList[] children = (ArrayList[])packageFragToTypes.get(packageName);
                    if (Util.isClassFileName(entryName)) {
                        if (children[0] == EMPTY_LIST) {
                            children[0] = new ArrayList();
                        }
                        children[0].add(fileName);
                        continue;
                    }
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(fileName);
                }
                Iterator packages = packageFragToTypes.keySet().iterator();
                while (packages.hasNext()) {
                    int resLength;
                    String packName = (String)packages.next();
                    ArrayList[] entries = (ArrayList[])packageFragToTypes.get(packName);
                    JarPackageFragment packFrag = (JarPackageFragment)this.getPackageFragment(packName);
                    JarPackageFragmentInfo fragInfo = (JarPackageFragmentInfo)packFrag.createElementInfo();
                    if (entries[0].size() > 0) {
                        fragInfo.setEntryNames(entries[0]);
                    }
                    if ((resLength = entries[1].size()) == 0) {
                        packFrag.computeNonJavaResources(NO_STRINGS, fragInfo, jar.getName());
                    } else {
                        String[] resNames = new String[resLength];
                        entries[1].toArray(resNames);
                        packFrag.computeNonJavaResources(resNames, fragInfo, jar.getName());
                    }
                    packFrag.computeChildren(fragInfo);
                    JavaModelManager.getJavaModelManager().putInfo(packFrag, fragInfo);
                    vChildren.add(packFrag);
                }
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(jar);
            throw throwable;
        }
        Object var13_21 = null;
        JavaModelManager.getJavaModelManager().closeZipFile(jar);
    }

    protected OpenableElementInfo createElementInfo() {
        return new JarPackageFragmentRootInfo();
    }

    protected int determineKind(IResource underlyingResource) throws JavaModelException {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot other = (JarPackageFragmentRoot)o;
            return this.jarPath.equals((Object)other.jarPath);
        }
        return false;
    }

    public ZipFile getJar() throws CoreException {
        return JavaModelManager.getJavaModelManager().getZipFile(this.getPath());
    }

    public int getKind() {
        return 2;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((JarPackageFragment)this.getPackageFragment("")).storedNonJavaResources();
    }

    public IPackageFragment getPackageFragment(String packageName) {
        return new JarPackageFragment(this, packageName);
    }

    public IPath getPath() {
        if (this.isExternal()) {
            return this.jarPath;
        }
        return super.getPath();
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.jarPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    public boolean hasChildren() throws JavaModelException {
        if (this.isOpen()) {
            return this.getChildren().length > 0;
        }
        return true;
    }

    public int hashCode() {
        return this.jarPath.hashCode();
    }

    public boolean isArchive() {
        return true;
    }

    public boolean isExternal() {
        return this.getResource() == null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void refreshChildren() {
    }

    protected boolean resourceExists() {
        if (this.isExternal()) {
            return JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    public IJavaElement rootedAt(IJavaProject project) {
        if (this.isExternal()) {
            return new JarPackageFragmentRoot(this.jarPath, project);
        }
        return new JarPackageFragmentRoot(this.getResource(), project);
    }
}

