/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeCompletionRequestor;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.Util;

public class ClassFile
extends Openable
implements IClassFile {
    protected BinaryType fBinaryType = null;

    protected ClassFile(IPackageFragment parent, String name) {
        super(6, parent, name);
        if (!Util.isClassFileName(name)) {
            throw new IllegalArgumentException(Util.bind("element.invalidClassFileName"));
        }
    }

    public void codeComplete(int offset, ICompletionRequestor requestor) throws JavaModelException {
        String source = this.getSource();
        if (source != null) {
            String encoding = this.getJavaProject().getOption("org.eclipse.jdt.core.encoding", true);
            String elementName = this.getElementName();
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), null, String.valueOf(elementName.substring(0, elementName.length() - ".class".length())) + ".java", encoding);
            this.codeComplete((ICompilationUnit)cu, (ICompilationUnit)cu, offset, requestor);
        }
    }

    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            IType parent;
            IType current = this.getType();
            while ((parent = current.getDeclaringType()) != null) {
                current = parent;
            }
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, null, String.valueOf(current.getElementName()) + ".java", null);
            return super.codeSelect(cu, offset, length);
        }
        return new IJavaElement[0];
    }

    protected OpenableElementInfo createElementInfo() {
        return new ClassFileInfo(this);
    }

    protected IJavaElement findElement(IJavaElement elt, int position, SourceMapper mapper) {
        SourceRange range = mapper.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaElement[] children = ((IParent)((Object)elt)).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement match = this.findElement(children[i], position, mapper);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return elt;
    }

    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        IBinaryType typeInfo = this.getBinaryTypeInfo((IFile)underlyingResource);
        if (typeInfo == null) {
            info.setChildren(new IJavaElement[0]);
            return false;
        }
        BinaryType type = new BinaryType(this, new String(ClassFile.simpleName(typeInfo.getName())));
        info.addChild(type);
        newElements.put(type, typeInfo);
        return true;
    }

    private IBinaryType getBinaryTypeInfo(IFile file) throws JavaModelException {
        JavaElement le = (JavaElement)this.getParent();
        if (le instanceof JarPackageFragment) {
            try {
                JarPackageFragmentRoot root = (JarPackageFragmentRoot)le.getParent();
                ClassFileReader info = null;
                ZipFile zip = null;
                try {
                    zip = root.getJar();
                    String entryName = this.getParent().getElementName();
                    entryName = entryName.replace('.', '/');
                    entryName = entryName.equals("") ? String.valueOf(entryName) + this.getElementName() : String.valueOf(entryName) + '/' + this.getElementName();
                    info = ClassFileReader.read(zip, entryName, true);
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    JavaModelManager.getJavaModelManager().closeZipFile(zip);
                    throw throwable;
                }
                Object var7_12 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
                if (info == null) {
                    throw this.newNotPresentException();
                }
                return info;
            }
            catch (ClassFormatException classFormatException) {
                return null;
            }
            catch (IOException ioe) {
                throw new JavaModelException(ioe, 985);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        byte[] contents = Util.getResourceContentsAsByteArray(file);
        try {
            return new ClassFileReader(contents, this.getElementName().toCharArray());
        }
        catch (ClassFormatException classFormatException) {
            return null;
        }
    }

    public IClassFile getClassFile() {
        return this;
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement parent = this.getParent();
        while (parent.getElementType() != 3) {
            parent = parent.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parent;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        IType type = this.getType();
        return this.findElement(type, position, mapper);
    }

    protected char getHandleMementoDelimiter() {
        return '(';
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    public IType getType() throws JavaModelException {
        if (this.fBinaryType == null) {
            String name = this.fName.substring(0, this.fName.lastIndexOf(46));
            int index = (name = name.substring(name.lastIndexOf(46) + 1)).lastIndexOf(36);
            if (index > -1 && name.length() > index + 1 && !Character.isDigit(name.charAt(index + 1))) {
                name = name.substring(index + 1);
            }
            this.fBinaryType = new BinaryType(this, name);
        }
        return this.fBinaryType;
    }

    public IJavaElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws JavaModelException {
        IBuffer buffer;
        char[] contents = null;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            contents = mapper.findSource(this.getType());
        }
        if (contents == null) {
            return null;
        }
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy();
        workingCopy.buffer = buffer = factory == null ? this.getBuffer() : factory.createBuffer(workingCopy);
        if (buffer != null && buffer.getCharacters() == null) {
            buffer.setContents(contents);
        }
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean hasChildren() throws JavaModelException {
        if (this.isOpen()) {
            return this.getChildren().length > 0;
        }
        return true;
    }

    public boolean isClass() throws JavaModelException {
        return this.getType().isClass();
    }

    public boolean isInterface() throws JavaModelException {
        return this.getType().isInterface();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            char[] contents = mapper.findSource(this.getType());
            if (contents != null) {
                IBuffer buffer = this.getBufferFactory().createBuffer(this);
                if (buffer == null) {
                    return null;
                }
                BufferManager bufManager = this.getBufferManager();
                bufManager.addBuffer(buffer);
                if (buffer.getCharacters() == null) {
                    buffer.setContents(contents);
                }
                buffer.addBufferChangedListener(this);
                mapper.mapSource(this.getType(), contents);
                return buffer;
            }
        } else {
            String qualifiedName = this.getType().getFullyQualifiedName();
            NameLookup lookup = ((JavaProject)this.getJavaProject()).getNameLookup();
            org.eclipse.jdt.core.ICompilationUnit cu = lookup.findCompilationUnit(qualifiedName);
            if (cu != null) {
                return cu.getBuffer();
            }
        }
        return null;
    }

    protected void openWhenClosed(IProgressMonitor pm) throws JavaModelException {
        IResource resource = this.getResource();
        if (resource != null && !resource.isAccessible()) {
            throw this.newNotPresentException();
        }
        super.openWhenClosed(pm);
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return new ClassFile((IPackageFragment)((JavaElement)this.fParent).rootedAt(project), this.fName);
    }

    static char[] simpleName(char[] className) {
        int lastPosition;
        if (className == null) {
            return null;
        }
        className = ClassFile.unqualifiedName(className);
        int count = 0;
        int i = lastPosition = className.length - 1;
        while (i > -1) {
            if (className[i] == '$' && i != lastPosition) {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                if (Character.isDigit(name[0])) break;
                return name;
            }
            ++count;
            --i;
        }
        return className;
    }

    public static char[] translatedName(char[] name) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length;
        char[] newName = new char[nameLength];
        int i = 0;
        while (i < nameLength) {
            newName[i] = name[i] == '/' ? 46 : name[i];
            ++i;
        }
        return newName;
    }

    static char[][] translatedNames(char[][] names) {
        if (names == null) {
            return null;
        }
        int length = names.length;
        char[][] newNames = new char[length][];
        int i = 0;
        while (i < length) {
            newNames[i] = ClassFile.translatedName(names[i]);
            ++i;
        }
        return newNames;
    }

    static char[] unqualifiedName(char[] className) {
        if (className == null) {
            return null;
        }
        int count = 0;
        int i = className.length - 1;
        while (i > -1) {
            if (className[i] == '/') {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                return name;
            }
            ++count;
            --i;
        }
        return className;
    }

    public void codeComplete(int offset, final ICodeCompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            this.codeComplete(offset, (ICompletionRequestor)null);
            return;
        }
        this.codeComplete(offset, new ICompletionRequestor(){

            public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptClass(packageName, className, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptError(IProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptField(declaringTypePackageName, declaringTypeName, name, typePackageName, typeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptKeyword(keywordName, completionStart, completionEnd);
            }

            public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptLabel(labelName, completionStart, completionEnd);
            }

            public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptModifier(modifierName, completionStart, completionEnd);
            }

            public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptPackage(packageName, completionName, completionStart, completionEnd);
            }

            public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptType(packageName, typeName, completionName, completionStart, completionEnd);
            }

            public void acceptVariableName(char[] typePackageName, char[] typeName, char[] name, char[] completionName, int completionStart, int completionEnd, int relevance) {
            }
        });
    }
}

