/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;

public class ImportDeclaration
extends ASTNode {
    private Name importName = null;
    private boolean onDemand = false;

    ImportDeclaration(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 26;
    }

    ASTNode clone(AST target) {
        ImportDeclaration result = new ImportDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOnDemand(this.isOnDemand());
        result.setName((Name)this.getName().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    public Name getName() {
        if (this.importName == null) {
            long count = this.getAST().modificationCount();
            this.setName(this.getAST().newQualifiedName(new SimpleName(this.getAST()), new SimpleName(this.getAST())));
            this.getAST().setModificationCount(count);
        }
        return this.importName;
    }

    public void setName(Name name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.importName, name, false);
        this.importName = name;
    }

    public boolean isOnDemand() {
        return this.onDemand;
    }

    public void setOnDemand(boolean onDemand) {
        this.modifying();
        this.onDemand = onDemand;
    }

    public IBinding resolveBinding() {
        return this.getAST().getBindingResolver().resolveImport(this);
    }

    int memSize() {
        return 44;
    }

    int treeSize() {
        return this.memSize() + (this.importName == null ? 0 : this.getName().treeSize());
    }
}

