/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class CompilationUnit
extends ASTNode {
    private PackageDeclaration optionalPackageDeclaration = null;
    private ASTNode.NodeList imports;
    private ASTNode.NodeList types;
    private int[] lineEndTable;
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    private Message[] messages;
    private IProblem[] problems;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    void setLineEndTable(int[] lineEndTable) {
        if (lineEndTable == null) {
            throw new NullPointerException();
        }
        this.modifying();
        this.lineEndTable = lineEndTable;
    }

    CompilationUnit(AST ast) {
        super(ast);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.imports = new ASTNode.NodeList(false, clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.types = new ASTNode.NodeList(false, clazz2);
        this.lineEndTable = new int[0];
        this.problems = EMPTY_PROBLEMS;
    }

    public int getNodeType() {
        return 15;
    }

    ASTNode clone(AST target) {
        CompilationUnit result = new CompilationUnit(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setPackage((PackageDeclaration)ASTNode.copySubtree(target, this.getPackage()));
        result.imports().addAll(ASTNode.copySubtrees(target, this.imports()));
        result.types().addAll(ASTNode.copySubtrees(target, this.types()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getPackage());
            this.acceptChildren(visitor, this.imports);
            this.acceptChildren(visitor, this.types);
        }
        visitor.endVisit(this);
    }

    public PackageDeclaration getPackage() {
        return this.optionalPackageDeclaration;
    }

    public void setPackage(PackageDeclaration pkgDecl) {
        this.replaceChild(this.optionalPackageDeclaration, pkgDecl, false);
        this.optionalPackageDeclaration = pkgDecl;
    }

    public List imports() {
        return this.imports;
    }

    public List types() {
        return this.types;
    }

    public ASTNode findDeclaringNode(IBinding binding) {
        return this.getAST().getBindingResolver().findDeclaringNode(binding);
    }

    public ASTNode findDeclaringNode(String key) {
        return this.getAST().getBindingResolver().findDeclaringNode(key);
    }

    public int lineNumber(int position) {
        int length = this.lineEndTable.length;
        if (length == 0) {
            return 1;
        }
        int low = 0;
        if (position <= this.lineEndTable[low]) {
            return 1;
        }
        int hi = length - 1;
        if (position > this.lineEndTable[hi]) {
            if (position >= this.getStartPosition() + this.getLength()) {
                return 1;
            }
            return length + 1;
        }
        while (low + 1 != hi) {
            int mid = (low + hi) / 2;
            if (position <= this.lineEndTable[mid]) {
                hi = mid;
                continue;
            }
            low = mid;
        }
        return low + 2;
    }

    public Message[] getMessages() {
        if (this.messages == null) {
            int problemLength = this.problems.length;
            if (problemLength == 0) {
                this.messages = EMPTY_MESSAGES;
            } else {
                this.messages = new Message[problemLength];
                int i = 0;
                while (i < problemLength) {
                    IProblem problem = this.problems[i];
                    int start = problem.getSourceStart();
                    int end = problem.getSourceEnd();
                    this.messages[i] = new Message(problem.getMessage(), start, end - start + 1);
                    ++i;
                }
            }
        }
        return this.messages;
    }

    public IProblem[] getProblems() {
        return this.problems;
    }

    void setProblems(IProblem[] problems) {
        if (problems == null) {
            throw new IllegalArgumentException();
        }
        this.problems = problems;
    }

    void appendDebugString(StringBuffer buffer) {
        buffer.append("CompilationUnit");
        buffer.append("[");
        Iterator it = this.types().iterator();
        while (it.hasNext()) {
            TypeDeclaration d = (TypeDeclaration)it.next();
            buffer.append(d.getName().getIdentifier());
            if (!it.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("]");
    }

    int memSize() {
        int size = 52;
        if (this.lineEndTable != null) {
            size += 12 + 4 * this.lineEndTable.length;
        }
        return size;
    }

    int treeSize() {
        return this.memSize() + (this.optionalPackageDeclaration == null ? 0 : this.getPackage().treeSize()) + this.imports.listSize() + this.types.listSize();
    }
}

