/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ValidatorActionResult;
import org.apache.cocoon.components.language.markup.xsp.XSPFormValidatorHelper;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.util.HashMap;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleFormTransformer
extends AbstractSAXTransformer
implements Recyclable {
    private boolean stripNumber = true;
    private static final int ELEMENT_DEFAULT = 0;
    private static final int ELEMENT_INPUT = 1;
    private static final int ELEMENT_SELECT = 2;
    private static final int ELEMENT_OPTION = 3;
    private static final int ELEMENT_TXTAREA = 4;
    private static final int ELEMENT_ERROR = 5;
    private static final int ELEMENT_FORM = 6;
    private static final int ELEMENT_REPEAT = 7;
    private static final Integer defaultElement = new Integer(0);
    private static final int TYPE_DEFAULT = 0;
    private static final int TYPE_CHECKBOX = 1;
    private static final int TYPE_RADIO = 2;
    private static final Integer defaultType = new Integer(0);
    protected static final String INPUT_MODULE_ROLE = InputModule.ROLE;
    protected static final String INPUT_MODULE_SELECTOR = INPUT_MODULE_ROLE + "Selector";
    private static final HashMap elementNames;
    private static final HashMap inputTypes;
    private static final HashMap validatorResults;
    private static final HashMap validatorResultLabel;
    protected Object[] values = null;
    protected Map validationResults = null;
    private boolean fixed = false;
    private boolean documentFixed = false;
    private String fixedName = "fixed";
    private String prefix = null;
    private String suffix = null;
    private String defaultPrefix = null;
    private String defaultSuffix = null;
    private String separator = null;
    private String formName = null;
    private boolean useFormName = false;
    private boolean useFormNameTwice = false;
    private boolean ignoreValidation = false;
    private int decorationSize = 1;
    private String defaultInput = "request-param";
    private Configuration defaultInputConf = null;
    private Configuration inputConf = null;
    private InputModule input = null;
    private ServiceSelector inputSelector = null;
    private String inputName = null;
    protected boolean skipChildrenOnly = false;
    protected int recordingCount = 0;
    protected List repeater = null;
    protected Map formValues = null;

    public SimpleFormTransformer() {
        this.defaultNamespaceURI = "";
        this.namespaceURI = "";
    }

    private void reset() {
        this.skipChildrenOnly = false;
        this.values = null;
        this.validationResults = null;
        this.documentFixed = false;
        this.fixed = false;
        this.formName = null;
        this.recordingCount = 0;
        this.repeater = new LinkedList();
        this.formValues = new HashMap();
        if (this.inputSelector != null) {
            if (this.input != null) {
                this.inputSelector.release((Object)this.input);
            }
            this.manager.release((Object)this.inputSelector);
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.defaultInputConf = config.getChild("input-module");
        this.defaultInput = this.defaultInputConf.getAttribute("name", this.defaultInput);
        this.separator = config.getChild("separator").getValue(this.separator);
        this.defaultPrefix = config.getChild("prefix").getValue(this.defaultPrefix);
        this.defaultSuffix = config.getChild("suffix").getValue(this.defaultSuffix);
        this.fixedName = config.getChild("fixed-attribute").getValue(this.fixedName);
        this.useFormName = config.getChild("use-form-name").getValueAsBoolean(this.useFormName);
        this.useFormNameTwice = config.getChild("use-form-name-twice").getValueAsBoolean(this.useFormNameTwice);
        boolean bl = this.useFormName = this.useFormName || this.useFormNameTwice;
        if (this.useFormName) {
            this.defaultPrefix = this.separator = this.separator == null || this.separator.equals("") ? "/" : this.separator;
        }
        this.ignoreValidation = config.getChild("ignore-validation").getValueAsBoolean(this.ignoreValidation);
        this.decorationSize = config.getChild("decoration").getValueAsInteger(this.decorationSize);
        this.stripNumber = config.getChild("strip-number").getValueAsBoolean(this.stripNumber);
    }

    private void evaluateParameters() {
        this.fixed = this.documentFixed = this.parameters.getParameterAsBoolean("fixed", false);
        this.prefix = this.parameters.getParameter("prefix", this.defaultPrefix);
        this.suffix = this.parameters.getParameter("suffix", this.defaultSuffix);
        this.inputName = this.parameters.getParameter("input", null);
        this.decorationSize = this.parameters.getParameterAsInteger("decoration", this.decorationSize);
        this.stripNumber = this.parameters.getParameterAsBoolean("strip-number", this.stripNumber);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.reset();
        super.setup(resolver, objectModel, src, par);
        if (this.request == null) {
            this.getLogger().debug("no request object");
            throw new ProcessingException("no request object");
        }
        this.evaluateParameters();
        this.setupInputModule();
    }

    private void setupInputModule() {
        block7: {
            this.inputConf = null;
            this.validationResults = this.ignoreValidation ? null : XSPFormValidatorHelper.getResults(this.objectModel);
            if (this.inputName == null) {
                this.inputName = this.defaultInput;
                this.inputConf = this.defaultInputConf;
            }
            try {
                this.inputSelector = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                if (this.inputName != null && this.inputSelector != null && this.inputSelector.isSelectable((Object)this.inputName)) {
                    this.input = (InputModule)this.inputSelector.select((Object)this.inputName);
                    if (!(this.input instanceof ThreadSafe) || !(this.inputSelector instanceof ThreadSafe)) {
                        this.inputSelector.release((Object)this.input);
                        this.manager.release((Object)this.inputSelector);
                        this.input = null;
                        this.inputSelector = null;
                    }
                } else if (this.inputName != null && this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("A problem occurred setting up '" + this.inputName + "': Selector is " + (this.inputSelector != null ? "not " : "") + "null, Component is " + (this.inputSelector != null && this.inputSelector.isSelectable((Object)this.inputName) ? "known" : "unknown"));
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block7;
                this.getLogger().warn("A problem occurred setting up '" + this.inputName + "': " + e.getMessage());
            }
        }
    }

    public void recycle() {
        super.recycle();
        this.reset();
    }

    protected String printAttributes(Attributes attr) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < attr.getLength(); ++i) {
            sb.append('@').append(attr.getLocalName(i)).append("='").append(attr.getValue(i)).append("' ");
        }
        sb.append(']');
        return sb.toString();
    }

    protected void startCheckableElement(String aName, String uri, String name, String raw, AttributesImpl attributes) throws SAXException {
        this.values = this.getValues(aName);
        String checked = attributes.getValue("checked");
        String value = attributes.getValue("value");
        boolean found = false;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startCheckableElement " + name + " attributes " + this.printAttributes(attributes));
        }
        if (this.values != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                found = true;
                if (checked != null) break;
                attributes.addAttribute("", "checked", "checked", "CDATA", "");
                break;
            }
            if (!found && checked != null) {
                attributes.removeAttribute(attributes.getIndex("checked"));
            }
        }
        this.relayStartElement(uri, name, raw, attributes);
    }

    protected void startNonCheckableElement(String aName, String uri, String name, String raw, AttributesImpl attributes) throws SAXException {
        Object fValue = this.getNextValue(aName);
        String value = attributes.getValue("value");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startNonCheckableElement " + name + " attributes " + this.printAttributes(attributes));
        }
        if (fValue != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            if (value != null) {
                attributes.setValue(attributes.getIndex("value"), String.valueOf(fValue));
            } else {
                attributes.addAttribute("", "value", "value", "CDATA", String.valueOf(fValue));
            }
        }
        this.relayStartElement(uri, name, raw, attributes);
    }

    protected void startInputElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        String aName = this.getName(attr.getValue("name"));
        String fixed = attr.getValue(this.fixedName);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startInputElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (aName == null || this.fixed || fixed != null && SimpleFormTransformer.parseBoolean(fixed)) {
            this.relayStartElement(uri, name, raw, attr);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            attr = this.normalizeAttributes(attr);
            AttributesImpl attributes = null;
            attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
            String type = attributes.getValue("type");
            switch ((Integer)inputTypes.get(type, defaultType)) {
                case 1: 
                case 2: {
                    this.startCheckableElement(aName, uri, name, raw, attributes);
                    break;
                }
                case 0: {
                    this.startNonCheckableElement(aName, uri, name, raw, attributes);
                }
            }
            this.values = null;
        }
    }

    protected void startSelectElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        String aName = this.getName(attr.getValue("name"));
        String fixed = attr.getValue(this.fixedName);
        this.values = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startSelectElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (!(aName == null || this.fixed || fixed != null && SimpleFormTransformer.parseBoolean(fixed))) {
            if (attr.getIndex("multiple") > -1) {
                this.values = this.getValues(aName);
            } else {
                Object val = this.getNextValue(aName);
                if (val != null) {
                    this.values = new Object[1];
                    this.values[0] = val;
                } else {
                    this.values = null;
                }
            }
            attr = this.normalizeAttributes(attr);
        }
        this.relayStartElement(uri, name, raw, attr);
    }

    protected void startOptionElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startOptionElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (this.values == null || this.fixed) {
            this.relayStartElement(uri, name, raw, attr);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            AttributesImpl attributes = null;
            attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
            String selected = attributes.getValue("selected");
            String value = attributes.getValue("value");
            boolean found = false;
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                found = true;
                if (selected != null) break;
                attributes.addAttribute("", "selected", "selected", "CDATA", "");
                break;
            }
            if (!found && selected != null) {
                attributes.removeAttribute(attributes.getIndex("selected"));
            }
            this.relayStartElement(uri, name, raw, attributes);
        }
    }

    protected void startTextareaElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        String aName = this.getName(attributes.getValue("name"));
        String fixed = attributes.getValue(this.fixedName);
        Object value = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startTextareaElement " + name + " attributes " + this.printAttributes(attributes));
        }
        if (aName != null) {
            value = this.getNextValue(aName);
        }
        if (value == null || this.fixed || fixed != null && SimpleFormTransformer.parseBoolean(fixed)) {
            this.relayStartElement(uri, name, raw, attributes);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            this.relayStartElement(uri, name, raw, this.normalizeAttributes(attributes));
            String valString = String.valueOf(value);
            this.characters(valString.toCharArray(), 0, valString.length());
            if (this.ignoreEventsCount == 0) {
                this.skipChildrenOnly = true;
            }
            ++this.ignoreEventsCount;
        }
    }

    protected void startErrorElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startErrorElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (this.ignoreValidation) {
            this.relayStartElement(uri, name, raw, attr);
        } else if (this.validationResults == null || this.fixed) {
            this.relayStartElement(true, false, uri, name, raw, attr);
        } else {
            String aName = attr.getValue("name");
            if (aName == null) {
                this.relayStartElement(uri, name, raw, attr);
            } else {
                ValidatorActionResult validation = XSPFormValidatorHelper.getParamResult(this.objectModel, aName);
                String when = attr.getValue("when");
                String when_ge = attr.getValue("when-ge");
                if (when != null && when.equals(validatorResults.get(validation)) || when_ge != null && validation.ge((ValidatorActionResult)validatorResultLabel.get(when_ge, ValidatorActionResult.MAXERROR))) {
                    AttributesImpl attributes = null;
                    attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
                    attributes.removeAttribute(attributes.getIndex("name"));
                    if (when != null) {
                        attributes.removeAttribute(attributes.getIndex("when"));
                    }
                    if (when_ge != null) {
                        attributes.removeAttribute(attributes.getIndex("when-ge"));
                    }
                    this.relayStartElement(uri, name, raw, this.normalizeAttributes(attributes));
                } else {
                    this.relayStartElement(true, true, uri, name, raw, attr);
                }
            }
        }
    }

    protected void startFormElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        String fixed = attr.getValue(this.fixedName);
        if (this.useFormName) {
            this.formName = attr.getValue("name");
        }
        if (fixed == null) {
            this.relayStartElement(uri, name, raw, attr);
        } else {
            if (!this.fixed && SimpleFormTransformer.parseBoolean(fixed)) {
                this.fixed = true;
            }
            AttributesImpl attributes = null;
            attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
            attributes.removeAttribute(attributes.getIndex(this.fixedName));
            this.relayStartElement(uri, name, raw, this.normalizeAttributes(attributes));
        }
    }

    protected void startRepeatElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.recordingCount == 0) {
            if (!this.fixed && !SimpleFormTransformer.parseBoolean(attr.getValue(this.fixedName))) {
                RepeaterStatus status = new RepeaterStatus("${" + attr.getValue("using") + "}", 0, attr.getValue("on"));
                this.repeater.add(status);
                this.startRecording();
                ++this.recordingCount;
            } else {
                this.relayStartElement(uri, name, raw, attr);
            }
        } else {
            this.relayStartElement(uri, name, raw, attr);
            ++this.recordingCount;
        }
    }

    protected void endRepeatElement(String uri, String name, String raw) throws SAXException {
        --this.recordingCount;
        if (this.recordingCount == 0) {
            DocumentFragment fragment = this.endRecording();
            RepeaterStatus status = (RepeaterStatus)this.repeater.get(this.repeater.size() - 1);
            Object[] vals = this.getValues(this.getName(status.expr));
            int count = vals != null ? vals.length : 0;
            status.count = 1;
            while (status.count <= count) {
                DOMStreamer streamer = new DOMStreamer(this, this);
                streamer.stream(fragment);
                ++status.count;
            }
            this.repeater.remove(this.repeater.size() - 1);
        } else {
            this.relayEndElement(uri, name, raw);
            if (this.recordingCount < 0) {
                this.recordingCount = 0;
            }
        }
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.ignoreEventsCount == 0 && this.recordingCount == 0) {
            switch ((Integer)elementNames.get(name, defaultElement)) {
                case 1: {
                    this.startInputElement(uri, name, raw, attr);
                    break;
                }
                case 2: {
                    this.startSelectElement(uri, name, raw, attr);
                    break;
                }
                case 3: {
                    this.startOptionElement(uri, name, raw, attr);
                    break;
                }
                case 4: {
                    this.startTextareaElement(uri, name, raw, attr);
                    break;
                }
                case 5: {
                    this.startErrorElement(uri, name, raw, attr);
                    break;
                }
                case 6: {
                    this.startFormElement(uri, name, raw, attr);
                    break;
                }
                case 7: {
                    this.startRepeatElement(uri, name, raw, attr);
                    break;
                }
                default: {
                    this.relayStartElement(uri, name, raw, attr);
                    break;
                }
            }
        } else if (this.recordingCount > 0) {
            switch ((Integer)elementNames.get(name, defaultElement)) {
                case 7: {
                    this.startRepeatElement(uri, name, raw, attr);
                    break;
                }
                default: {
                    this.relayStartElement(uri, name, raw, attr);
                    break;
                }
            }
        } else {
            this.relayStartElement(uri, name, raw, attr);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws SAXException {
        if (this.ignoreEventsCount > 0) {
            this.relayEndElement(uri, name, raw);
        } else if (this.recordingCount > 0) {
            switch ((Integer)elementNames.get(name, defaultElement)) {
                case 7: {
                    this.endRepeatElement(uri, name, raw);
                    break;
                }
                default: {
                    this.relayEndElement(uri, name, raw);
                    break;
                }
            }
        } else {
            switch ((Integer)elementNames.get(name, defaultElement)) {
                case 2: {
                    this.values = null;
                    this.relayEndElement(uri, name, raw);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    this.relayEndElement(uri, name, raw);
                    break;
                }
                case 6: {
                    this.fixed = this.documentFixed;
                    this.formName = null;
                    this.relayEndElement(uri, name, raw);
                    break;
                }
                case 7: {
                    this.endRepeatElement(uri, name, raw);
                    break;
                }
                default: {
                    this.relayEndElement(uri, name, raw);
                }
            }
        }
    }

    private static boolean parseBoolean(String aBoolean) {
        return "true".equalsIgnoreCase(aBoolean) || "yes".equalsIgnoreCase(aBoolean);
    }

    private Attributes normalizeAttributes(Attributes attr) {
        String name;
        Attributes result = attr;
        if (this.stripNumber && this.repeater.size() > 0 && (name = attr.getValue("name")) != null) {
            Iterator i = this.repeater.iterator();
            while (i.hasNext()) {
                RepeaterStatus status = (RepeaterStatus)i.next();
                int pos = name.indexOf(status.var);
                if (pos < 0) continue;
                AttributesImpl attributes = result instanceof AttributesImpl ? (AttributesImpl)result : new AttributesImpl(result);
                name = name.substring(0, pos - this.decorationSize) + name.substring(pos + status.var.length() + this.decorationSize);
                attributes.setValue(attributes.getIndex("name"), name);
                result = attributes;
            }
        }
        return result;
    }

    private String getName(String name) {
        String result = name;
        if (this.useFormName && this.formName != null) {
            result = this.separator != null ? (this.useFormNameTwice ? this.formName + this.separator + this.formName + this.separator + result : this.formName + this.separator + result) : (this.useFormNameTwice ? this.formName + result : this.formName + this.formName + result);
        }
        if (this.prefix != null) {
            result = this.prefix + result;
        }
        if (this.suffix != null) {
            result = result + this.prefix;
        }
        if (this.repeater.size() > 0) {
            Iterator i = this.repeater.iterator();
            while (i.hasNext()) {
                RepeaterStatus status = (RepeaterStatus)i.next();
                int pos = result.indexOf(status.var);
                if (pos == -1) continue;
                result = result.substring(0, pos) + status.count + result.substring(pos + status.var.length());
            }
        }
        return result;
    }

    private Object getNextValue(String name) {
        Object result = null;
        if (this.formValues.containsKey(name)) {
            ValueList vList = (ValueList)this.formValues.get(name);
            result = vList.getNext();
        } else {
            ValueList vList = new ValueList(this.getValues(name));
            result = vList.getNext();
            this.formValues.put(name, vList);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getValues(String name) {
        ServiceSelector iputSelector;
        Object[] values;
        block14: {
            values = null;
            iputSelector = null;
            InputModule iput = null;
            try {
                block13: {
                    try {
                        if (this.input != null) {
                            values = this.input.getAttributeValues(name, this.inputConf, this.objectModel);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("cached module " + this.input + " attribute " + name + " returns " + values);
                            }
                            break block13;
                        }
                        iputSelector = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                        if (this.inputName != null && iputSelector != null && iputSelector.isSelectable((Object)this.inputName)) {
                            iput = (InputModule)iputSelector.select((Object)this.inputName);
                        }
                        if (iput != null) {
                            values = iput.getAttributeValues(name, this.inputConf, this.objectModel);
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("fresh module " + iput + " attribute " + name + " returns " + values);
                        }
                    }
                    catch (Exception e) {
                        if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn("A problem occurred acquiring a value from '" + this.inputName + "' for '" + name + "': " + e.getMessage());
                        }
                        Object var7_6 = null;
                        if (iputSelector == null) return values;
                        if (iput != null) {
                            iputSelector.release(iput);
                        }
                        this.manager.release((Object)iputSelector);
                        return values;
                    }
                }
                Object var7_5 = null;
                if (iputSelector == null) return values;
                if (iput == null) break block14;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (iputSelector == null) throw throwable;
                if (iput != null) {
                    iputSelector.release(iput);
                }
                this.manager.release((Object)iputSelector);
                throw throwable;
            }
            iputSelector.release((Object)iput);
        }
        this.manager.release((Object)iputSelector);
        return values;
    }

    protected void relayStartElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        this.relayStartElement(false, false, uri, name, raw, attr);
    }

    protected void relayStartElement(boolean skip, boolean children, String uri, String name, String raw, Attributes attr) throws SAXException {
        if (skip) {
            this.skipChildrenOnly = children;
        }
        if (skip && !children) {
            ++this.ignoreEventsCount;
        }
        try {
            super.startTransformingElement(uri, name, raw, attr);
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        if (skip && children) {
            ++this.ignoreEventsCount;
        }
    }

    protected void relayEndElement(String uri, String name, String raw) throws SAXException {
        if (this.ignoreEventsCount == 1 && this.skipChildrenOnly) {
            --this.ignoreEventsCount;
        }
        try {
            super.endTransformingElement(uri, name, raw);
        }
        catch (ProcessingException e) {
            throw new SAXException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            this.getLogger().error("exception", (Throwable)e);
        }
        if (this.ignoreEventsCount > 0) {
            --this.ignoreEventsCount;
        }
    }

    static {
        HashMap names = new HashMap();
        names.put("input", new Integer(1));
        names.put("select", new Integer(2));
        names.put("option", new Integer(3));
        names.put("textarea", new Integer(4));
        names.put("error", new Integer(5));
        names.put("form", new Integer(6));
        names.put("repeat", new Integer(7));
        elementNames = names;
        names = null;
        names = new HashMap();
        names.put("checkbox", new Integer(1));
        names.put("radio", new Integer(2));
        inputTypes = names;
        names = null;
        names = new HashMap();
        names.put("ok", ValidatorActionResult.OK);
        names.put("not-present", ValidatorActionResult.NOTPRESENT);
        names.put("error", ValidatorActionResult.ERROR);
        names.put("is-null", ValidatorActionResult.ISNULL);
        names.put("too-small", ValidatorActionResult.TOOSMALL);
        names.put("too-large", ValidatorActionResult.TOOLARGE);
        names.put("no-match", ValidatorActionResult.NOMATCH);
        validatorResultLabel = names;
        names = new HashMap();
        names.put(ValidatorActionResult.OK, "ok");
        names.put(ValidatorActionResult.NOTPRESENT, "not-present");
        names.put(ValidatorActionResult.ERROR, "error");
        names.put(ValidatorActionResult.ISNULL, "is-null");
        names.put(ValidatorActionResult.TOOSMALL, "too-small");
        names.put(ValidatorActionResult.TOOLARGE, "too-large");
        names.put(ValidatorActionResult.NOMATCH, "no-match");
        validatorResults = names;
        Object var0 = null;
    }

    protected class ValueList {
        private int current = -1;
        private Object[] values = null;

        public ValueList(Object[] values) {
            this.values = values;
            this.current = values != null && values.length > 0 ? 0 : -1;
        }

        public Object getNext() {
            Object result = null;
            if (this.values != null && this.current < this.values.length) {
                result = this.values[this.current++];
            }
            return result;
        }
    }

    protected class RepeaterStatus {
        public String var = null;
        public String expr = null;
        public int count = 0;

        public RepeaterStatus(String var, int count, String expr) {
            this.var = var;
            this.count = count;
            this.expr = expr;
        }

        public String toString() {
            return "[" + this.var + "," + this.expr + "," + this.count + "]";
        }
    }
}

