/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.servlet.multipart.MultipartException;
import org.apache.cocoon.servlet.multipart.PartInMemory;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.TokenStream;

public class MultipartParser {
    private static final int FILE_BUFFER_SIZE = 4096;
    private static final int INLINE_BUFFER_SIZE = 256;
    private static final int MAX_BOUNDARY_SIZE = 128;
    private boolean saveUploadedFilesToDisk;
    private File uploadDirectory = null;
    private boolean allowOverwrite;
    private boolean silentlyRename;
    private int maxUploadSize;
    private String characterEncoding;
    private Hashtable parts;

    public MultipartParser(boolean saveUploadedFilesToDisk, File uploadDirectory, boolean allowOverwrite, boolean silentlyRename, int maxUploadSize, String characterEncoding) {
        this.saveUploadedFilesToDisk = saveUploadedFilesToDisk;
        this.uploadDirectory = uploadDirectory;
        this.allowOverwrite = allowOverwrite;
        this.silentlyRename = silentlyRename;
        this.maxUploadSize = maxUploadSize;
        this.characterEncoding = characterEncoding;
    }

    public Hashtable getParts(int contentLength, String contentType, InputStream requestStream) throws IOException, MultipartException {
        if (contentLength > this.maxUploadSize) {
            throw new IOException("Content length exceeds maximum upload size");
        }
        this.parts = new Hashtable();
        BufferedInputStream bufferedStream = new BufferedInputStream(requestStream);
        PushbackInputStream pushbackStream = new PushbackInputStream(bufferedStream, 128);
        TokenStream stream = new TokenStream(pushbackStream);
        this.parseMultiPart(stream, this.getBoundary(contentType));
        return this.parts;
    }

    public Hashtable getParts(HttpServletRequest request) throws IOException, MultipartException {
        return this.getParts(request.getContentLength(), request.getContentType(), (InputStream)request.getInputStream());
    }

    private void parseMultiPart(TokenStream ts, String boundary) throws IOException, MultipartException {
        ts.setBoundary(boundary.getBytes());
        ts.read();
        ts.setBoundary(("\r\n" + boundary).getBytes());
        while (ts.getState() == -2) {
            ts.nextPart();
            this.parsePart(ts);
        }
        if (ts.getState() != -3) {
            throw new MultipartException("Malformed stream");
        }
    }

    private void parsePart(TokenStream ts) throws IOException, MultipartException {
        block9: {
            Hashtable headers = new Hashtable();
            headers = this.readHeaders(ts);
            try {
                if (headers.containsKey("filename")) {
                    if (!"".equals(headers.get("filename"))) {
                        this.parseFilePart(ts, headers);
                    } else {
                        byte[] buf = new byte[32];
                        while (ts.getState() == -5) {
                            ts.read(buf);
                        }
                    }
                    break block9;
                }
                if (((String)headers.get("content-disposition")).toLowerCase().equals("form-data")) {
                    this.parseInlinePart(ts, headers);
                    break block9;
                }
                if (((String)headers.get("content-disposition")).toLowerCase().indexOf("multipart") > -1) {
                    this.parseMultiPart(new TokenStream(ts, 128), "--" + (String)headers.get("boundary"));
                    ts.read();
                    break block9;
                }
                throw new MultipartException("Unknown part type");
            }
            catch (IOException e) {
                throw new MultipartException("Malformed stream: " + e.getMessage());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw new MultipartException("Malformed header");
            }
        }
    }

    private void parseFilePart(TokenStream in, Hashtable headers) throws IOException, MultipartException {
        byte[] buf = new byte[4096];
        OutputStream out = null;
        File file = null;
        if (!this.saveUploadedFilesToDisk) {
            out = new ByteArrayOutputStream();
        } else {
            String fileName = (String)headers.get("filename");
            fileName = File.separatorChar == '\\' ? fileName.replace('/', '\\') : fileName.replace('\\', '/');
            String filePath = this.uploadDirectory.getPath() + File.separator;
            fileName = new File(fileName).getName();
            file = new File(filePath + fileName);
            if (!this.allowOverwrite && !file.createNewFile()) {
                if (this.silentlyRename) {
                    int c = 0;
                    while (!(file = new File(filePath + c++ + "_" + fileName)).createNewFile()) {
                    }
                } else {
                    throw new MultipartException("Duplicate file " + file.getName() + ".");
                }
            }
            out = new FileOutputStream(file);
        }
        int read = 0;
        while (in.getState() == -5) {
            read = in.read(buf);
            ((OutputStream)out).write(buf, 0, read);
        }
        ((OutputStream)out).close();
        if (file == null) {
            byte[] bytes = out.toByteArray();
            this.parts.put(headers.get("name"), new PartInMemory(headers, new ByteArrayInputStream(bytes), bytes.length));
        } else {
            this.parts.put(headers.get("name"), new PartOnDisk(headers, file));
        }
    }

    private void parseInlinePart(TokenStream in, Hashtable headers) throws IOException {
        byte[] buf = new byte[256];
        StringBuffer value = new StringBuffer();
        while (in.getState() == -5) {
            int read = in.read(buf);
            value.append(new String(buf, 0, read, this.characterEncoding));
        }
        String field = (String)headers.get("name");
        Vector<String> v = (Vector<String>)this.parts.get(field);
        if (v == null) {
            v = new Vector<String>();
            this.parts.put(field, v);
        }
        v.add(value.toString());
    }

    private Hashtable readHeaders(TokenStream in) throws IOException {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        String hdrline = this.readln(in);
        while (!"".equals(hdrline)) {
            StringTokenizer tokenizer = new StringTokenizer(hdrline);
            headers.put(tokenizer.nextToken(" :").toLowerCase(), tokenizer.nextToken(" :;"));
            while (tokenizer.hasMoreTokens()) {
                headers.put(tokenizer.nextToken(" ;=\""), tokenizer.hasMoreTokens() ? tokenizer.nextToken("=\"") : "");
            }
            hdrline = this.readln(in);
        }
        return headers;
    }

    private String getBoundary(String hdr) {
        int start = hdr.toLowerCase().indexOf("boundary=");
        if (start > -1) {
            return "--" + hdr.substring(start + 9);
        }
        return null;
    }

    private String readln(TokenStream in) throws IOException {
        StringBuffer out = new StringBuffer();
        int b = in.read();
        while (b != -1 && b != 13) {
            out.append((char)b);
            b = in.read();
        }
        if (b == 13) {
            in.read();
        }
        return out.toString();
    }
}

