/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.CascadingThrowable;
import org.xml.sax.SAXParseException;

public class CascadingIOException
extends IOException
implements CascadingThrowable {
    private final Throwable m_throwable;

    public CascadingIOException(String message) {
        this(message, null);
    }

    public CascadingIOException(Exception ex) {
        this(ex.getMessage(), ex);
    }

    public CascadingIOException(String message, Throwable t) {
        super(message);
        this.m_throwable = t;
    }

    public final Throwable getCause() {
        return this.m_throwable;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString());
        Throwable t = this.getCause();
        if (t != null) {
            s.append(": ");
            s.append(this.extraInfo(t));
            s.append(t.toString());
        }
        return s.toString();
    }

    private String extraInfo(Throwable t) {
        TransformerException transformerException;
        SourceLocator sourceLocator;
        StringBuffer sb = new StringBuffer();
        if (t instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)t;
            sb.append(String.valueOf(spe.getSystemId()));
            sb.append(":");
            sb.append(String.valueOf(spe.getLineNumber()));
            sb.append(":");
            sb.append(String.valueOf(spe.getColumnNumber()));
            sb.append(":");
        } else if (t instanceof TransformerException && null != (sourceLocator = (transformerException = (TransformerException)t).getLocator())) {
            sb.append(String.valueOf(sourceLocator.getSystemId()));
            sb.append(":");
            sb.append(String.valueOf(sourceLocator.getLineNumber()));
            sb.append(":");
            sb.append(String.valueOf(sourceLocator.getColumnNumber()));
            sb.append(":");
        }
        return sb.toString();
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.getCause() != null) {
            this.getCause().printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        }
    }
}

