/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSessionContext;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;

class StandardSession
implements HttpSession,
Session,
Serializable {
    private static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    private HashMap attributes = new HashMap();
    private transient String authType = null;
    private transient Method containerEventMethod = null;
    private static final Class[] containerEventTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StandardSession.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = StandardSession.class$("java.lang.Object")) : class$java$lang$Object};
    private long creationTime = 0L;
    private transient int debug = 0;
    private transient boolean expiring = false;
    private transient StandardSessionFacade facade = null;
    private String id = null;
    private static final String info = "StandardSession/1.0";
    private long lastAccessedTime = this.creationTime;
    private transient ArrayList listeners = new ArrayList();
    private Manager manager = null;
    private int maxInactiveInterval = -1;
    private boolean isNew = false;
    private boolean isValid = false;
    private transient HashMap notes = new HashMap();
    private transient Principal principal = null;
    private static StringManager sm = StringManager.getManager("org.apache.catalina.session");
    private static HttpSessionContext sessionContext = null;
    private transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    private long thisAccessedTime = this.creationTime;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public StandardSession(Manager manager) {
        this.manager = manager;
        if (manager instanceof ManagerBase) {
            this.debug = ((ManagerBase)manager).getDebug();
        }
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = id;
        if (this.manager != null) {
            this.manager.add(this);
        }
        this.tellNew();
    }

    public void tellNew() {
        this.fireSessionEvent("createSession", null);
        Context context = (Context)this.manager.getContainer();
        Object[] listeners = context.getApplicationListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionCreated", listener);
                    listener.sessionCreated(event);
                    this.fireContainerEvent(context, "afterSessionCreated", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(context, "afterSessionCreated", listener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.log(sm.getString("standardSession.sessionEvent"), t);
                }
            }
        }
    }

    public String getInfo() {
        return info;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            this.facade = new StandardSessionFacade(this);
        }
        return this.facade;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void access() {
        this.isNew = false;
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(SessionListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    public void expire() {
        this.expire(true);
    }

    public void expire(boolean notify) {
        if (this.expiring) {
            return;
        }
        this.expiring = true;
        this.setValid(false);
        if (this.manager != null) {
            this.manager.remove(this);
        }
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.removeAttribute(keys[i], notify);
        }
        if (notify) {
            this.fireSessionEvent("destroySession", null);
        }
        Context context = (Context)this.manager.getContainer();
        Object[] listeners = context.getApplicationListeners();
        if (notify && listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            for (int i = 0; i < listeners.length; ++i) {
                int j = listeners.length - 1 - i;
                if (!(listeners[j] instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listeners[j];
                try {
                    this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                    listener.sessionDestroyed(event);
                    this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.log(sm.getString("standardSession.sessionEvent"), t);
                }
            }
        }
        this.expiring = false;
        if (this.manager != null && this.manager instanceof ManagerBase) {
            this.recycle();
        }
    }

    public void passivate() {
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object attribute = this.getAttribute(keys[i]);
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            if (event == null) {
                event = new HttpSessionEvent((HttpSession)this);
            }
            ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
        }
    }

    public void activate() {
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object attribute = this.getAttribute(keys[i]);
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            if (event == null) {
                event = new HttpSessionEvent((HttpSession)this);
            }
            ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNote(String name) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNoteNames() {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            return this.notes.keySet().iterator();
        }
    }

    public void recycle() {
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = -1;
        this.notes.clear();
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
        this.manager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(String name) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(SessionListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String name, Object value) {
        HashMap hashMap = this.notes;
        synchronized (hashMap) {
            this.notes.put(name, value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject(stream);
    }

    void writeObjectData(ObjectOutputStream stream) throws IOException {
        this.writeObject(stream);
    }

    public long getCreationTime() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getCreationTime.ise"));
        }
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        Context context = (Context)this.manager.getContainer();
        if (context == null) {
            return null;
        }
        return context.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(this.attributes.keySet(), true);
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.getValueNames.ise"));
        }
        return this.keys();
    }

    public void invalidate() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.invalidate.ise"));
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.isNew.ise"));
        }
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name, boolean notify) {
        Context context;
        Object[] listeners;
        if (!this.expiring && !this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        Object value = null;
        boolean found = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            found = this.attributes.containsKey(name);
            if (!found) {
                return;
            }
            value = this.attributes.get(name);
            this.attributes.remove(name);
        }
        if (!notify) {
            return;
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.log(sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Context context;
        Object[] listeners;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise"));
        }
        if (this.manager != null && this.manager.getDistributable() && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae"));
        }
        Object unbound = null;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            unbound = this.attributes.get(name);
            this.attributes.put(name, value);
        }
        if (unbound != null && unbound instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        HttpSessionBindingEvent event = null;
        event = unbound != null ? new HttpSessionBindingEvent((HttpSession)this, name, unbound) : new HttpSessionBindingEvent((HttpSession)this, name, value);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(event);
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                if (unbound != null) {
                    this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    continue;
                }
                this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                listener.attributeAdded(event);
                this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    if (unbound != null) {
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    } else {
                        this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.log(sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        this.principal = null;
        this.id = (String)stream.readObject();
        if (this.debug >= 2) {
            this.log("readObject() loading session " + this.id);
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        int n = (Integer)stream.readObject();
        boolean isValidSave = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (value instanceof String && value.equals(NOT_SERIALIZED)) continue;
            if (this.debug >= 2) {
                this.log("  loading attribute '" + name + "' with value '" + value + "'");
            }
            HashMap hashMap = this.attributes;
            synchronized (hashMap) {
                this.attributes.put(name, value);
                continue;
            }
        }
        this.isValid = isValidSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(new Long(this.creationTime));
        stream.writeObject(new Long(this.lastAccessedTime));
        stream.writeObject(new Integer(this.maxInactiveInterval));
        stream.writeObject(new Boolean(this.isNew));
        stream.writeObject(new Boolean(this.isValid));
        stream.writeObject(new Long(this.thisAccessedTime));
        stream.writeObject(this.id);
        if (this.debug >= 2) {
            this.log("writeObject() storing session " + this.id);
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList saveValues = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            Object value = null;
            HashMap hashMap = this.attributes;
            synchronized (hashMap) {
                value = this.attributes.get(keys[i]);
            }
            if (value == null || !(value instanceof Serializable)) continue;
            saveNames.add(keys[i]);
            saveValues.add(value);
        }
        int n = saveNames.size();
        stream.writeObject(new Integer(n));
        for (int i = 0; i < n; ++i) {
            stream.writeObject((String)saveNames.get(i));
            try {
                stream.writeObject(saveValues.get(i));
                if (this.debug < 2) continue;
                this.log("  storing attribute '" + saveNames.get(i) + "' with value '" + saveValues.get(i) + "'");
                continue;
            }
            catch (NotSerializableException e) {
                this.log(sm.getString("standardSession.notSerializable", saveNames.get(i), this.id), e);
                stream.writeObject(NOT_SERIALIZED);
                if (this.debug < 2) continue;
                this.log("  storing attribute '" + saveNames.get(i) + "' with value NOT_SERIALIZED");
            }
        }
    }

    private void fireContainerEvent(Context context, String type, Object data) throws Exception {
        if (!"org.apache.catalina.core.StandardContext".equals(context.getClass().getName())) {
            return;
        }
        if (this.containerEventMethod == null) {
            this.containerEventMethod = context.getClass().getMethod("fireContainerEvent", containerEventTypes);
        }
        Object[] containerEventParams = new Object[]{type, data};
        this.containerEventMethod.invoke((Object)context, containerEventParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent event = new SessionEvent(this, type, data);
        SessionListener[] list = new SessionListener[]{};
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = this.listeners.toArray(list);
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].sessionEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys() {
        String[] results = new String[]{};
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.keySet().toArray(results);
        }
    }

    private void log(String message) {
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(message);
        } else {
            System.out.println("StandardSession: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        if (this.manager != null && this.manager instanceof ManagerBase) {
            ((ManagerBase)this.manager).log(message, throwable);
        } else {
            System.out.println("StandardSession: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

