/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.fonts;

import java.net.URL;
import java.util.Map;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.FontReader;

public class LazyFont
extends Font
implements FontDescriptor {
    private URL metricsFile = null;
    private URL fontEmbedPath = null;
    private boolean useKerning = false;
    private boolean isMetricsLoaded = false;
    private Font realFont = null;
    private FontDescriptor realFontDescriptor = null;

    public LazyFont(URL fontEmbedPath, URL metricsFile, boolean useKerning) {
        this.metricsFile = metricsFile;
        this.fontEmbedPath = fontEmbedPath;
        this.useKerning = useKerning;
    }

    private void load() {
        block3: {
            if (this.isMetricsLoaded) break block3;
            this.isMetricsLoaded = true;
            try {
                FontReader reader = new FontReader(this.metricsFile);
                reader.useKerning(this.useKerning);
                reader.setFontEmbedPath(this.fontEmbedPath);
                this.realFont = reader.getFont();
                if (this.realFont instanceof FontDescriptor) {
                    this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                }
            }
            catch (Exception ex) {
                MessageHandler.error("Failed to read font metrics file " + this.metricsFile.toExternalForm() + ": " + ex.getMessage());
            }
        }
    }

    public Font getRealFont() {
        return this.realFont;
    }

    public String encoding() {
        this.load();
        return this.realFont.encoding();
    }

    public String fontName() {
        this.load();
        return this.realFont.fontName();
    }

    public byte getSubType() {
        this.load();
        return this.realFont.getSubType();
    }

    public char mapChar(char c) {
        this.load();
        return this.realFont.mapChar(c);
    }

    public int getAscender(int size) {
        this.load();
        return this.realFont.getAscender(size);
    }

    public int getCapHeight(int size) {
        this.load();
        return this.realFont.getCapHeight(size);
    }

    public int getDescender(int size) {
        this.load();
        return this.realFont.getDescender(size);
    }

    public int getXHeight(int size) {
        this.load();
        return this.realFont.getXHeight(size);
    }

    public int getFirstChar() {
        this.load();
        return this.realFont.getFirstChar();
    }

    public int getLastChar() {
        this.load();
        return this.realFont.getLastChar();
    }

    public int width(int i, int size) {
        this.load();
        return this.realFont.width(i, size);
    }

    public int[] getWidths(int size) {
        this.load();
        return this.realFont.getWidths(size);
    }

    public int getCapHeight() {
        this.load();
        return this.realFontDescriptor.getCapHeight();
    }

    public int getDescender() {
        this.load();
        return this.realFontDescriptor.getDescender();
    }

    public int getAscender() {
        this.load();
        return this.realFontDescriptor.getAscender();
    }

    public int getFlags() {
        this.load();
        return this.realFontDescriptor.getFlags();
    }

    public int[] getFontBBox() {
        this.load();
        return this.realFontDescriptor.getFontBBox();
    }

    public int getItalicAngle() {
        this.load();
        return this.realFontDescriptor.getItalicAngle();
    }

    public int getStemV() {
        this.load();
        return this.realFontDescriptor.getStemV();
    }

    public boolean hasKerningInfo() {
        this.load();
        return this.realFontDescriptor.hasKerningInfo();
    }

    public Map getKerningInfo() {
        this.load();
        return this.realFontDescriptor.getKerningInfo();
    }

    public boolean isEmbeddable() {
        this.load();
        return this.realFontDescriptor.isEmbeddable();
    }

    public PDFStream getFontFile(int objNum) {
        this.load();
        return this.realFontDescriptor.getFontFile(objNum);
    }
}

