<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="page/navbar">
  <navigation>

   <!-- Outer table -->
   <table cellpadding="0" cellspacing="0" border="0" height="100%" width="100%">
   <tbody>
     <tr valign="top">
      <td>
	<!-- table for formatting purposes -->
        <table cellpadding="0" cellspacing="0" border="0" width="100%">
	<tbody>

              <!-- one row for name of user and service -->
	      <tr>
		<td align="left" colspan="4">
		   <img src="images/gnome/mailer_icon.png" class="image_icon"/>
			<span class="navbar_header">
			   <xsl:value-of select="user" />@<xsl:value-of
	      select="host" />
			</span>
		</td>
	      </tr>

	       <!-- one row for each folder -->
            <xsl:for-each select="folder">
	    <xsl:variable name="link_to_action">
	       <xsl:value-of select="concat('folder.xsl?act=folder&amp;folderNr=',normalize-space(nr))"/>
	    </xsl:variable>

             <tr>
	        <td width="10%">&#160;</td>
                <td align="right" width="10%">
		    <xsl:attribute name="class">
			<xsl:choose>
				<xsl:when test="position() mod 2">field_light_bg</xsl:when>
				<xsl:otherwise>field_middle_bg</xsl:otherwise>
			</xsl:choose>
		    </xsl:attribute>
		    <xsl:choose>
			<xsl:when test="selectable">
			    <img src="images/gnome/folder6-small.png"/>
			</xsl:when>
			<xsl:otherwise>
			    <img src="images/gnome/folder3-small.png" class="image_icon"/>
			</xsl:otherwise>
		    </xsl:choose>
		</td>
                <td width="40%">
                   <xsl:attribute name="class">
			<xsl:choose>
				<xsl:when test="position() mod 2">field_light_bg</xsl:when>
				<xsl:otherwise>field_middle_bg</xsl:otherwise>
			</xsl:choose>
                   </xsl:attribute>

                   <xsl:choose>
                      <xsl:when test="selectable">
                         <span class="navigation">
                          <a target="Main">
                              <xsl:attribute name="href">
	                        <xsl:value-of select="$link_to_action"/>
		              </xsl:attribute>
                              <xsl:value-of select="normalize-space(name)" />
                          </a>
                         </span>
                      </xsl:when>
                      <xsl:otherwise>
                         <span class="navigation">
                             <xsl:value-of select="normalize-space(name)" />
                         </span>
                      </xsl:otherwise>
                   </xsl:choose>
                </td>
		<td width="40%">
                   <xsl:attribute name="class">
			<xsl:choose>
				<xsl:when test="position() mod 2">field_light_bg</xsl:when>
				<xsl:otherwise>field_middle_bg</xsl:otherwise>
			</xsl:choose>
                   </xsl:attribute>
		   <!-- display nb of messages in folder, only if folder is
	        selectable -->
		   <xsl:if test="selectable">

		      <span class="simpletext"><span class="boldgreen"><xsl:value-of select="nbMessages" /></span>/<span class="bold_red"><xsl:value-of select="nbNewMessages" /></span> &#160;<xsl:value-of select="../headertext2" /></span>
		   </xsl:if>
		</td>
            </tr>
	    <!-- <xsl:comment><xsl:copy-of select="."/></xsl:comment> -->
            </xsl:for-each>
       </tbody>
       </table>
      </td>
     </tr>

     <tr valign="bottom" class="lower_info_row">
      <td>
	<!-- table for formatting purposes -->
        <table cellpadding="0" cellspacing="0" border="0" width="100%">
	<tbody>
           <!-- folder-list header and color information -->
           <tr>
	    <td class="infotext">

	     <xsl:value-of select="normalize-space(msgoverview_text1)" />&#160;<span class="boldgreen"><xsl:value-of select="normalize-space(msgoverview_text2)" /></span>, <br/>
	     <xsl:value-of select="normalize-space(msgoverview_text3)" />&#160;<span class="bold_red"><xsl:value-of select="normalize-space(msgoverview_text4)" /></span>
	    </td>
	   </tr>
	  </tbody>
	 </table>
	</td>
       </tr>

     <!-- end outer table -->
     </tbody>
     </table>
 </navigation>	  
</xsl:template>
	
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>

</xsl:stylesheet>
