<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="flagbox.xsl" />
<xsl:import href="copybox.xsl" />

<xsl:template match="page/folder">
 <content>

   <xsl:variable name="select_action"
       select="'folder.xsl?act=folder&amp;refresh=1&amp;folderNr='"/>
   <xsl:variable name="flag_action"
       select="'folder.xsl?act=setflag&amp;folderNr='"/>
   <xsl:variable name="message_link_prefix"
       select="'message.xsl?act=message&amp;folderNr='"/>
   <xsl:variable name="page_action_prefix"
       select="'folder.xsl?act=folder&amp;folderNr='"/>

	<table cellpadding="2" cellspacing="1" border="0" width="100%"><tbody>
	<tr>

		<!-- Header information on the folder contents: a picture, and a note saying 
	  	     how many messages this folder contains.
		-->
        	<td class="simpletext" height="22" colspan="5" width="70%">
        		<img align="middle" border="0" hspace="5" src="images/gnome/my_documents-48.png" />    
			<xsl:choose>
				<xsl:when test="folder/isempty">
				     <xsl:value-of select="normalize-space(emptyfoldertext)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="header" />
				</xsl:otherwise>
			</xsl:choose>
 
		</td>

		<td class="simpletext" height="22" colspan="2" width="30%">
		    <xsl:choose>
		      <xsl:when test="pagingOn">
		        <xsl:if test="previous">
			  <a>
			    <xsl:attribute name="href">
			       <xsl:value-of select="concat($page_action_prefix,normalize-space(folder/nr),'&amp;pageNr=',normalize-space(previous/value))"/>
			    </xsl:attribute>
			    <xsl:value-of select="normalize-space(previous/label)"/>
			  </a>
			</xsl:if>
			&#160;
		        <xsl:if test="next">
			  <a>
			    <xsl:attribute name="href">
			       <xsl:value-of select="concat($page_action_prefix,normalize-space(folder/nr),'&amp;pageNr=',normalize-space(next/value))"/>
			    </xsl:attribute>
			    <xsl:value-of select="normalize-space(next/label)"/>
			  </a>
			</xsl:if>
		      </xsl:when>
		      <xsl:otherwise>&#160;
		      </xsl:otherwise>
		    </xsl:choose>
		</td>

		<!-- Refresh box: provides link to the current folder, with a parameter to force refresh 
		<xsl:variable name="link_refresh" select="concat($select_action,normalize-space(folder/nr))"/>
		<td class="simpletext" height="22" colspan="2" width="30%">
            		<a>
				<xsl:attribute name="href"><xsl:value-of select="$link_refresh"/></xsl:attribute>
				<img align="middle" border="0" hspace="5" src="images/gnome/refresh-blue.png" />
 				<xsl:value-of select="normalize-space(refresh_buttonlabel)" />
			</a> - <xsl:value-of select="normalize-space(refresh_text)" />.
		</td>
		Note WK: commented out refresh box for now, as semantics
		are now unclear (because of new frameless navigation)
		-->

	</tr>

	<xsl:if test="warning">
		<tr>
			<td class="simpletext" height="22" colspan="7"> 
		            <span class="bold">
		            	<xsl:value-of select="warning/usertext"/>
			   </span>.
			</td>
		</tr>
 		<xsl:comment>Warning content: <xsl:value-of select="warning/content"/></xsl:comment>
 	</xsl:if>
		
	<xsl:if test="not(folder/isempty)">

	   <!-- folder contents -->
	   <xsl:variable name="link_setflag" select="concat($flag_action,normalize-space(folder/nr))"/>
	   <form method="post" >
		<xsl:attribute name="action"><xsl:value-of select="$link_setflag" /></xsl:attribute>
		<!-- action line -->

		<tr>
		<!-- Stuff to change flag settings on selected messages -->
		<xsl:call-template name="flagbox">
		   <xsl:with-param name="index" select="'1'"/>
		</xsl:call-template>
		
		<!-- Stuff to move or copy messages to another folder -->
		<xsl:call-template name="copybox">
		   <xsl:with-param name="index" select="'1'"/>
		</xsl:call-template>

		</tr>
        

		<!-- column headers -->
                <tr class="field_dark_bg">
                    <td align="center" class="simpletext" height="22" width="5%">&#160;</td>
                    <td class="link_text" width="5%"><xsl:value-of select="folder/tableheader1" />
</td>
                    <td class="link_text" width="7%"><xsl:value-of select="folder/tableheader2" /></td>
		    <td class="link_text" width="28%"><xsl:value-of select="folder/tableheader3" /></td>
		    <td class="link_text" width="25%"><xsl:value-of select="folder/tableheader4" /></td>
		    <td class="link_text" width="25%"><xsl:value-of select="folder/tableheader5" /></td>
		    <td class="link_text" width="5%"><xsl:value-of select="folder/tableheader6" /></td>
                </tr>

		
		   <!--message header contents -->
	           <xsl:for-each select="folder/message">

		     <!-- Define the link to the message contents -->
		     <xsl:variable name="link_to_message" select="concat($message_link_prefix,normalize-space(../nr),'&amp;messageNr=',normalize-space(nr))" />

                <tr>
                    <xsl:attribute name="class">
			<xsl:choose>
				<xsl:when test="position() mod 2">field_light_bg</xsl:when>
				<xsl:otherwise>field_middle_bg</xsl:otherwise>
			</xsl:choose>
                    </xsl:attribute>
			
                    <td class="simpletext" align="center" width="5%">
                    	<input class="simpletext" name="checkedmessage" type="checkbox">
                    		<xsl:attribute name="value">
                    			<xsl:value-of select="normalize-space(nr)" />
                    		</xsl:attribute>
                    	</input>
                    </td>
                    <td class="simpletext" align="center" width="5%">
  			    <a>
				<xsl:attribute name="href"><xsl:value-of select="$link_to_message"/></xsl:attribute>
                               	<xsl:value-of select="nr" />
                            </a>
                    </td>

		<!-- flag box -->
                    <td width="7%">
			<xsl:for-each select="flag">
				<img hspace="2" border="0">
					<xsl:attribute name="src"><xsl:value-of select="concat('images/gnome/flag-',normalize-space(.),'.png')"/></xsl:attribute>
				</img>
                    	</xsl:for-each>
                    </td>

		<td class="simpletext" width="28%">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$link_to_message"/></xsl:attribute>
				<xsl:value-of select="subject" />
				<xsl:if test="not(subject)">
					<xsl:value-of select="../emptysubject" />
				</xsl:if>
			</a>
		</td>

		<!-- "From" box -->
		<td class="simpletext" width="25%">
			<xsl:value-of select="from/name" /><br />
				<span class="bold">EMail:</span><xsl:value-of select="from/email" />
		</td>

                <td class="simpletext" width="25%"><xsl:value-of select="date" /></td>
                <td class="simpletext" width="5%"><xsl:value-of select="size" /></td>

             	</tr>
        	</xsl:for-each> <!-- end loop for each message -->
	
		<!-- action line -->
		<tr>
		<!-- Stuff to change flag settings on selected messages -->
		<xsl:call-template name="flagbox">
		   <xsl:with-param name="index" select="'2'"/>
		</xsl:call-template>
		
		<!-- Stuff to move or copy messages to another folder -->
		<xsl:call-template name="copybox">
		   <xsl:with-param name="index" select="'2'"/>
		</xsl:call-template>

		</tr>
        
        	<!-- done form area -->        
        	</form>
         
         	<!-- Status icon line -->
                <tr class="field_dark_bg">
                    <td class="simpletext" align="center" colspan="7" width="100%">
                        <table cellpadding="0" cellspacing="0" border="0" width="100%">
                            <tbody><tr>
                                <td class="smalltext"><span class="bold"><xsl:value-of select="folder/footertext1" /></span></td>
                                <td class="smalltext"><img hspace="2" border="0" src="images/gnome/flag-attach.png" /></td>
                                <td class="smalltext"><xsl:value-of select="folder/footertext2" /></td>
                                <td class="smalltext"><img hspace="2" border="0" src="images/gnome/flag-recent.png" /></td>
				<td class="smalltext"><xsl:value-of select="folder/footertext3" /></td>
				<td class="smalltext"><img hspace="2" border="0" src="images/gnome/flag-seen.png" /></td>
				<td class="smalltext"><xsl:value-of select="folder/footertext4" /></td>
				<td class="smalltext"><img hspace="2" border="0" src="images/gnome/flag-answered.png" /></td>
				<td class="smalltext"><xsl:value-of select="folder/footertext5" /></td>
				<td class="smalltext"><img hspace="2" border="0" src="images/gnome/flag-deleted.png" /></td>
				<td class="smalltext"><xsl:value-of select="folder/footertext6" /></td>
                            </tr>
                        </tbody></table>
                    </td>
                </tr>

		<!-- space row
                <tr class="bg_for_invert">
                    <td align="center" class="simpletext" height="22" width="100%" colspan="7">
                    </td>
                </tr>
		-->

		<!-- Done with stuff to be displayed only if folder is not empty. Close the xsl:if -->
	</xsl:if>

	<!-- done with table -->            
        </tbody></table>

  </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
