/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailServerConnection;
import net.jatec.ironmailer.controller.NoConnectionException;
import net.jatec.ironmailer.framework.FrameworkException;
import net.jatec.ironmailer.framework.xml.XMLReader;
import net.jatec.ironmailer.framework.xml.XMLWriter;
import org.apache.log4j.Logger;

public class GeneralStore {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$GeneralStore == null ? (class$net$jatec$ironmailer$controller$GeneralStore = GeneralStore.class$((String)"net.jatec.ironmailer.controller.GeneralStore")) : class$net$jatec$ironmailer$controller$GeneralStore));
    private static final String UTF = "UTF-8";
    private Folder myFolder;
    private Hashtable entries;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$GeneralStore;

    public GeneralStore(MailServerConnection mailServerConnection, String string) throws ControllerException {
        this.log.debug((Object)("GeneralStore() called for name " + string));
        try {
            Store store = mailServerConnection.getStore();
            this.myFolder = store.getFolder(string);
            if (!this.myFolder.exists()) {
                this.log.debug((Object)("GeneralStore() folder " + string + " does not yet exist in this backend, creating"));
                this.myFolder.create(1);
                this.myFolder.setSubscribed(false);
            } else {
                this.log.debug((Object)"GeneralStore() existing folder was found");
            }
            this.myFolder.open(2);
            Message[] messageArray = this.myFolder.getMessages();
            this.entries = new Hashtable(messageArray.length);
            for (int i = 0; i < messageArray.length; ++i) {
                MimeMessage mimeMessage = (MimeMessage)messageArray[i];
                if (mimeMessage.isSet(Flags.Flag.DELETED)) continue;
                String string2 = mimeMessage.getSubject();
                this.entries.put(string2, mimeMessage);
            }
        }
        catch (Throwable throwable) {
            throw new ControllerException("error initializing GeneralStore for name " + string, throwable);
        }
        this.log.debug((Object)"GeneralStore() successful");
    }

    public void close() throws ControllerException {
        this.log.debug((Object)"close() called");
        try {
            if (this.myFolder.isOpen()) {
                this.myFolder.close(true);
            }
        }
        catch (Throwable throwable) {
            throw new ControllerException("error closing GeneralStore", throwable);
        }
    }

    public boolean hasEntry(String string) {
        return this.entries.containsKey(string);
    }

    private InputStream read(String string) throws ControllerException {
        InputStream inputStream;
        this.log.debug((Object)("read() called for id " + string));
        try {
            MimeMessage mimeMessage = (MimeMessage)this.entries.get(string);
            inputStream = mimeMessage != null ? mimeMessage.getInputStream() : null;
        }
        catch (Throwable throwable) {
            throw new ControllerException("error writing retrieving input stream", throwable);
        }
        return inputStream;
    }

    public Object getObject(String string, Class clazz) throws ControllerException {
        this.log.debug((Object)("getObject() called for entryId " + string));
        Object object = null;
        InputStream inputStream = this.read(string);
        if (inputStream != null) {
            this.log.debug((Object)"getObject() got data stream");
            try {
                object = new XMLReader().getObject(inputStream);
            }
            catch (FrameworkException frameworkException) {
                throw new ControllerException("error retrieving data", (Throwable)frameworkException);
            }
            if (object == null) {
                throw new ControllerException("internal error: there is a datastream but I cannot read it");
            }
            if (!clazz.isInstance(object)) {
                throw new ControllerException("bad type read from store: expected " + clazz.getClass().getName() + " but got " + object.getClass().getName());
            }
        } else {
            object = null;
            this.log.debug((Object)("getObject() found no data for entryId " + string));
        }
        return object;
    }

    public void write(String string, String string2, String string3) throws ControllerException {
        MimeMessage mimeMessage;
        this.log.debug((Object)("write() called for id " + string));
        try {
            mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
            mimeMessage.setSubject(string);
            mimeMessage.setText(string2.toString(), string3);
        }
        catch (Throwable throwable) {
            throw new ControllerException("error writing to GeneralStore", throwable);
        }
        this.log.debug((Object)"write() successfully created message, now calling store");
        this.storeMessage(mimeMessage);
        this.log.debug((Object)"write() completed");
    }

    public void writeAsXml(String string, Object object, Class[] classArray) throws ControllerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("writeAsXml() called for entryId " + string));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new XMLWriter((OutputStream)byteArrayOutputStream, object, classArray);
        }
        catch (FrameworkException frameworkException) {
            throw new ControllerException("error writing data", (Throwable)frameworkException);
        }
        this.log.debug((Object)"writeAsXml() got data, now calling store");
        try {
            this.write(string, byteArrayOutputStream.toString(UTF), UTF);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ControllerException("error converting string", (Throwable)unsupportedEncodingException);
        }
    }

    private void storeMessage(MimeMessage mimeMessage) throws ControllerException {
        try {
            String string = mimeMessage.getSubject();
            MimeMessage mimeMessage2 = (MimeMessage)this.entries.get(string);
            this.log.debug((Object)"storeMessage() check 1");
            if (mimeMessage2 != null) {
                this.log.debug((Object)"storeMessage() detected old message, removing");
                mimeMessage2.setFlag(Flags.Flag.DELETED, true);
                this.entries.remove(string);
                this.myFolder.expunge();
                this.log.debug((Object)"storeMessage() expunged old message");
            }
            Message[] messageArray = new Message[]{mimeMessage};
            this.log.debug((Object)"storeMessage() check 2");
            this.myFolder.appendMessages(messageArray);
            this.log.debug((Object)"storeMessage() check 3");
            this.entries.put(string, mimeMessage);
            this.log.debug((Object)"storeMessage() check 4");
        }
        catch (FolderClosedException folderClosedException) {
            throw new NoConnectionException("no connection", (Throwable)folderClosedException);
        }
        catch (Exception exception) {
            throw new ControllerException("error writing to GeneralStore", (Throwable)exception);
        }
        this.log.debug((Object)"storeMessage() completed");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

