/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import net.jatec.ironmailer.controller.ServerConnection;
import org.apache.log4j.Logger;

public class MailServerConnection
implements ServerConnection {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailServerConnection == null ? (class$net$jatec$ironmailer$controller$MailServerConnection = MailServerConnection.class$((String)"net.jatec.ironmailer.controller.MailServerConnection")) : class$net$jatec$ironmailer$controller$MailServerConnection));
    private Session session;
    private Store store;
    private String user;
    private String host;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailServerConnection;

    public void connect(String string, String string2, char[] cArray) throws IllegalArgumentException, FailedLoginException, LoginException {
        this.log.info((Object)("connect() called for host " + string + " and user " + string2));
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("parameter host must contain a value");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("parameter user must contain a value");
        }
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("parameter password must contain a value");
        }
        try {
            Properties properties = new Properties();
            properties.put("mail.imap.host", string);
            this.session = Session.getInstance((Properties)properties);
            this.store = this.session.getStore("imap");
            this.store.connect(string, string2, String.valueOf(cArray));
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            this.log.info((Object)("connect() failed: " + authenticationFailedException.toString()));
            throw new FailedLoginException(authenticationFailedException.toString());
        }
        catch (Throwable throwable) {
            this.log.error((Object)("connect() failed with unexpected error " + throwable.toString()), throwable);
            throw new LoginException("unexpected connection exception " + throwable.toString());
        }
        this.user = string2;
        this.host = string;
    }

    public void disconnect() {
        this.log.info((Object)"disconnect() called");
        try {
            this.store.close();
        }
        catch (MessagingException messagingException) {
            this.log.info((Object)("disconnect() ignoring exception: " + messagingException.toString()));
        }
        this.store = null;
        this.session = null;
    }

    public Session getSession() {
        return this.session;
    }

    public Store getStore() {
        return this.store;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

