<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:import href="mailpartheader.xsl" />

<xsl:template match="page/viewattachment">
   <content>

	<center class="headertext">
		<i18n:text>viewattachment_title</i18n:text>
	</center>

	<xsl:variable name="link_to_message">
	   <xsl:value-of select="concat('folderNr=',normalize-space(folderNr),'&amp;messageNr=',normalize-space(messageNr))"/>
	</xsl:variable>

	<!-- Attachments -->
        <xsl:for-each select="attachment/part">

	   <xsl:variable name="link_refs">
	         <xsl:value-of
	         select="concat($link_to_message,'&amp;attachmentNr=',normalize-space(../attachmentNr),'&amp;partNr=',normalize-space(nr))"
	         />
           </xsl:variable>

	   <xsl:variable name="link_to_part">
		<xsl:value-of select="concat('getattachment/',normalize-space(filename),'?act=getattachment&amp;',$link_refs)" />
	   </xsl:variable>

  	   <xsl:call-template name="mailpartheader">
	       <xsl:with-param name="link_to_part"><xsl:value-of select="$link_to_part"/></xsl:with-param>
	   </xsl:call-template>

	</xsl:for-each>

   </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>

