<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG and Politux.org, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * @author JWK
 * @author FM
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:variable name="action_link_prefix" 
      select="'folder.xsl?act=folder&amp;folderNr='"/>

<xsl:template match="page/navbar">

  <navigation>
   <!-- Outer table -->
   <table cellpadding="0" cellspacing="0" border="0" height="100%" width="100%">
     <tr valign="top">
      <td>
<!-- table for formatting purposes -->
        <table cellpadding="0" cellspacing="0" border="0" width="100%">
              <!-- one row for name of user and service -->
	      <tr>
		<td align="left" colspan="2" style="border-bottom:1px solid black;padding-top: 3px; padding-bottom: 6px;background: #92d1b2;">
		   <img src="images/gnome/mailer_icon.png" class="image_icon"/>
			<span class="navbar_header">
			   <xsl:value-of select="normalize-space(user)"/>@<xsl:value-of
	      select="normalize-space(host)" />
			</span>
		</td>
	      </tr>

	       <!-- one row for each folder -->
            <xsl:for-each select="folder">
	    <xsl:variable name="link_to_action">
	       <xsl:value-of select="concat($action_link_prefix,normalize-space(nr))"/>
	    </xsl:variable>

             <tr>
	        <!--<td style="border-bottom: 1px dotted black;" width="5%">
                  <xsl:attribute name="class">
                    <xsl:choose>
                      <xsl:when test="position() mod 2">field_light_bg</xsl:when>
                      <xsl:otherwise>field_middle_bg</xsl:otherwise>
                    </xsl:choose>
                  </xsl:attribute>
                  &#160;
                </td>-->

                <td width="100%" style="padding-left: 6px;border-bottom: 1px dotted #CCCCCC;">
                  <!--<xsl:attribute name="class">
                    <xsl:choose>
                      <xsl:when test="position() mod 2">field_light_bg</xsl:when>
                      <xsl:otherwise>field_middle_bg</xsl:otherwise>
                    </xsl:choose>
                  </xsl:attribute>-->
                 <table style="padding:0px;border-spacing:0px" width="100%">
                 <tr>
                  <td>
		  <!-- seem to need a table to format correctly icon + text -->
		  <table style="padding:1px;border-spacing:0px">
		    <tr>
		      <td>
                         <xsl:for-each select="level">&#160;&#160;&#160;</xsl:for-each>
		      </td>
		      <td>
 		       <xsl:choose>
			<xsl:when test="selectable">
			    <img src="images/gnome/folder-open.png" class="image_icon"/>
			</xsl:when>
			<xsl:otherwise>
			    <img src="images/gnome/directory.png" class="image_icon"/>
			</xsl:otherwise>
		       </xsl:choose>
		      </td>
		      <td class="navigation">
                      <xsl:choose>
                        <xsl:when test="selectable">
                          <a>
                              <xsl:attribute name="href">
	                        <xsl:value-of select="$link_to_action"/>
		              </xsl:attribute>
                              <xsl:value-of select="normalize-space(name)" />
                          </a>
                        </xsl:when>
                        <xsl:otherwise>
                             <xsl:value-of select="normalize-space(name)" />
                        </xsl:otherwise>
                      </xsl:choose>
		      </td>
		    </tr>
		  </table>

                </td>
		<td style="text-align: right">
                   <xsl:attribute name="class">
			<!--<xsl:choose>
				<xsl:when test="position() mod 2">field_light_bg</xsl:when>
				<xsl:otherwise>field_middle_bg</xsl:otherwise>
			</xsl:choose>-->
                   </xsl:attribute>
		   <!-- display nb of messages in folder, only if folder is
	        selectable -->
		   <xsl:if test="selectable">

		      <span class="simpletext"><span class="boldgreen"><xsl:value-of select="nbMessages" /></span>/<span class="bold_red"><xsl:value-of select="nbNewMessages" /></span> &#160;<xsl:value-of select="../headertext2" /></span>
		   </xsl:if>
		</td>
                  </tr>
                </table>
              </td>
            </tr>
	    <!-- <xsl:comment><xsl:copy-of select="."/></xsl:comment> -->
            </xsl:for-each>
       </table>
      </td>
     </tr>

     <tr valign="bottom" class="lower_info_row">
      <td>
	<!-- table for formatting purposes -->
        <table cellpadding="0" cellspacing="0" border="0" width="100%">
           <!-- folder-list header and color information -->
           <tr>
	    <td class="infotext">

	     <i18n:text>msgoverview_text1</i18n:text>&#160;<span class="boldgreen"><i18n:text>msgoverview_text2</i18n:text></span>, <br/>
	     <i18n:text>msgoverview_text3</i18n:text>&#160;<span class="bold_red"><i18n:text>msgoverview_text4</i18n:text></span>
	    </td>
	   </tr>
	 </table>
	</td>
       </tr>

     <!-- end outer table -->
     </table>
 </navigation>	  
</xsl:template>


<!-- This would work if we were able to do recursion in the XSP stuff 
<xsl:template match="branch">
   <xsl:variable name="link_to_action">
       <xsl:value-of select="concat($action_link_prefix,normalize-space(nr))"/>
   </xsl:variable>
   <table>
      <tr>
         <xsl:attribute name="class">
            <xsl:choose>
		<xsl:when test="number(normalize-space(nr)) mod 2">field_light_bg</xsl:when>
		<xsl:otherwise>field_middle_bg</xsl:otherwise>
	    </xsl:choose>
         </xsl:attribute>
         <td>
                   <xsl:choose>
                      <xsl:when test="selectable">
                         <span class="navigation">
                          <a>
                              <xsl:attribute name="href">
	                        <xsl:value-of select="$link_to_action"/>
		              </xsl:attribute>
                              <xsl:value-of select="normalize-space(name)" />
                          </a>
                         </span>
                      </xsl:when>
                      <xsl:otherwise>
                         <span class="navigation">
                             <xsl:value-of select="normalize-space(name)" />
                         </span>
                      </xsl:otherwise>
                   </xsl:choose>
         </td>
      </tr>
      <tr>
         <td>
            <xsl:for-each select="branch">
               <xsl:apply-templates select="."/>
            </xsl:for-each>    
         </td>
      </tr>
   </table>
</xsl:template>
-->


  <!-- pass the rest through -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>

</xsl:stylesheet>
