<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template name="mailpartheader">

    <!-- Display headers for a part of a mail (as in mime part) -->

    <!-- Prerequisite: variable link_to_part is set -->
    <xsl:param name="link_to_part"/>

    <center>
	<p class="link_text"><i18n:text>partheader_headertext</i18n:text>&#160;<xsl:value-of select="position()" /></p>
    </center>
    <table cellpadding="4" cellspacing="2" border="0" width="100%">
	<tr class="field_middle_bg">
	   <td width="13%" class="link_text" height="22"><i18n:text>partheader_nametext</i18n:text></td>
	   <td width="87%" class="simpletext" height="22">
	   	<a>
		   <xsl:attribute name="href"><xsl:value-of select="$link_to_part"/></xsl:attribute>
		   <xsl:value-of select="normalize-space(filename)" />
		   <xsl:if test="not(filename)">
			<i18n:text>partheader_emptyfilenametext</i18n:text>
		   </xsl:if>
	    	</a>
	   </td>
	</tr>
	<tr class="field_light_bg">
	    <td width="13%" class="link_text" height="22"><i18n:text>partheader_typetext</i18n:text></td>
	    <td width="87%" class="simpletext" height="22"><xsl:value-of select="normalize-space(type)" /></td>
	</tr>
	<tr class="field_middle_bg">
	    <td width="13%" class="link_text" height="22"><i18n:text>partheader_sizetext</i18n:text></td>
	    <td width="87%" class="simpletext" height="22"><xsl:value-of select="normalize-space(size)" /></td>
	</tr>
     </table>


</xsl:template>

</xsl:stylesheet>
