<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page/attach">
  <content>

   <xsl:variable name="delete_link_prefix"
      select="'attach.xsl?act=attach&amp;delete=true&amp;fileId='"/>
   <xsl:variable name="compose_link" 
      select="'compose.xsl?act=compose&amp;continue=true'"/>
   <xsl:variable name="fileattach_link"
      select="'attach.xsl'"/>

   <form enctype="multipart/form-data" method="post" name="attachform">
      <xsl:attribute name="action">
         <xsl:value-of select="$fileattach_link"/>
      </xsl:attribute>
      <input type="hidden" name="act" value="fileattach" />
		
      <table cellpadding="4" cellspacing="2" border="0" width="100%"><tbody>
	<!-- Header row -->
	<tr>
	   <td class="simpletext" colspan="2">
	      <img align="middle" border="0" hspace="5" src="images/gnome/composer.png" /><i18n:text>attach_headertext1</i18n:text>
	   </td>
	</tr>
	<!-- "Browse file" step row 1 -->
	<tr class="bg_for_invert">
	   <td class="white_text" colspan="2">
	   	<b><i18n:text>attach_step1header</i18n:text></b>&#160;<i18n:text>attach_step1content</i18n:text>
	   </td>
	</tr>
	<!-- "Browse file" step row 2 -->
	<tr class="field_light_bg">
		<td class="simpletext" colspan="2">
			<!-- note: input widget with type file does not seem to have a way of setting it's button name :( -->
			<input class="simpletext" size="20" name="file" type="file">
			</input>
		</td>
	</tr>
	<!-- space row -->
	<tr class="field_dark_bg">
		<td class="link_text">
			&#160;
		</td>
	</tr>
	<!-- "Attach file" step row 1 -->
	<tr class="bg_for_invert">
		<td class="white_text">
        		<b><i18n:text>attach_step2header</i18n:text></b>&#160;<i18n:text>attach_step2content</i18n:text>
        	</td>
	</tr>
	<!-- "Attach file" step row 2 -->
	<tr class="field_light_bg">
		<td  class="simpletext">
			<input class="simpletext" name="add" type="submit" i18n:attr="value">
				<xsl:attribute name="value">attach_loadactiontext</xsl:attribute>
			</input>
		</td>				
	</tr>
	<!-- space row -->
	<tr class="field_dark_bg">
		<td class="link_text" align="left">
			&#160;
		</td>
	</tr>

	</tbody></table>
   </form>

   <!-- List of already attached files -->			
   <table cellpadding="4" cellspacing="2" border="0" width="100%"><tbody>
	<!-- header -->
	<tr class="bg_for_invert">
		<td class="white_text" colspan="3">
	        	<b><i18n:text>attach_step3header</i18n:text></b>&#160;<i18n:text>attach_step3content</i18n:text>
	        </td>
	</tr>

	<!-- list header row -->
	<tr class="bg_for_invert">
		<td class="white_text"><i18n:text>attach_listheader1</i18n:text></td>
		<td class="white_text"><i18n:text>attach_listheader2</i18n:text></td>
		<td class="white_text">&#160;</td>
	</tr>	
	<!-- list of attached files -->
	<xsl:for-each select="attach/file">
		<tr class="field_light_bg">
			<td class="simpletext">
				<xsl:value-of select="normalize-space(name)" />
			</td>
			<td class="simpletext">
				<xsl:value-of select="normalize-space(size)" />
			</td>
			<td class="simpletext">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="concat($delete_link_prefix,normalize-space(id))"/>
					</xsl:attribute>
					<img
					src="images/gnome/flag-deleted.png"
					border="0" i18n:attr="alt">
						<xsl:attribute name="alt">attach_delactionhelp</xsl:attribute>
					</img>
				</a>
			</td>
		</tr>
	</xsl:for-each>

	<!-- size row -->
	<tr class="field_middle_bg">
		<td class="link_text" align="left" colspan="3">
			<i18n:text>attach_sizetext</i18n:text>&#160;<xsl:value-of select="normalize-space(attach/size/used)" />&#160;/&#160;<xsl:value-of select="normalize-space(attach/size/allowed)" />
		</td>
	</tr>
			
	<!-- space row -->
	<tr class="field_dark_bg">
		<td class="link_text" align="left" colspan="3">
			&#160;
		</td>
	</tr>
			
	<!-- footer row (with "back" button) -->
	<tr class="bg_for_invert">
		<td colspan="3">
			<table cellspacing="0" cellpadding="0" border="0">
			<tbody>
				<tr>
					<td>
						<a>
						  <xsl:attribute name="href"><xsl:value-of select="$compose_link"/></xsl:attribute>
							<img border="0" hspace="5" src="images/gnome/arrow_back.png" />
						</a>
					</td>
					<td>
						<a>
						  <xsl:attribute name="href"><xsl:value-of select="$compose_link"/></xsl:attribute>
							<span class="white_text"><i18n:text>attach_footertext1</i18n:text></span>
						</a>
					</td>
				</tr>
			</tbody>
			</table>
		</td>
	</tr>
			
   </tbody></table>	
		
	
   <xsl:if test="error">
      <p class="bold_red">
	 <img align="middle" border="0" src="images/gnome/dialog-error.png" />
         <xsl:choose>
	   <xsl:when test="error/isSize">
	     <i18n:translate>
		<i18n:text>attach_sizeexceeded</i18n:text>
		<i18n:param><xsl:value-of select="normalize-space(error/content/name)"/></i18n:param>
		<i18n:param><xsl:value-of select="normalize-space(error/content/size)"/></i18n:param>
		<i18n:param><xsl:value-of select="normalize-space(error/content/allowedSize)"/></i18n:param>
		<i18n:param><xsl:value-of select="normalize-space(error/content/currentSize)"/></i18n:param>
	     </i18n:translate>
	   </xsl:when>
	   <xsl:when test="error/isNoSelection">
	      <i18n:text>general_noselection</i18n:text>
	   </xsl:when>
	   <xsl:otherwise>
	      <i18n:text>Error</i18n:text>
	   </xsl:otherwise>
	 </xsl:choose>
	</p>
	<xsl:comment>Error stack: <xsl:value-of select="normalize-space(error/stack)"/></xsl:comment>
   </xsl:if>
 </content>
</xsl:template>
	
   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
