/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import java.io.File;
import java.util.Vector;
import javax.mail.internet.MimeBodyPart;
import net.jatec.ironmailer.model.AttachmentSizeExceededException;
import net.jatec.ironmailer.model.FileAttachment;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

public class AttachmentHolder {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$AttachmentHolder == null ? (class$net$jatec$ironmailer$model$AttachmentHolder = AttachmentHolder.class$((String)"net.jatec.ironmailer.model.AttachmentHolder")) : class$net$jatec$ironmailer$model$AttachmentHolder));
    private Vector attachments = new Vector(3);
    private long totalSize = 0L;
    private long maxSize;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$AttachmentHolder;

    public AttachmentHolder(long l) {
        this.maxSize = l;
    }

    public void add(File file) throws AttachmentSizeExceededException, ModelException {
        FileAttachment fileAttachment = new FileAttachment(file);
        long l = fileAttachment.getSize();
        if (this.totalSize + l > this.maxSize) {
            String string = fileAttachment.getName();
            fileAttachment.destroy();
            throw new AttachmentSizeExceededException(this.maxSize, this.totalSize, l, string);
        }
        this.attachments.add(fileAttachment);
        this.totalSize += fileAttachment.getSize();
    }

    public void delete(int n) {
        FileAttachment fileAttachment = (FileAttachment)this.attachments.remove(n);
        this.totalSize -= fileAttachment.getSize();
        fileAttachment.destroy();
    }

    public int getNbAttachments() {
        if (this.attachments != null) {
            return this.attachments.size();
        }
        return 0;
    }

    public String getAttachmentName(int n) {
        return ((FileAttachment)this.attachments.get(n)).getName();
    }

    public String getAttachmentSize(int n) {
        return ((FileAttachment)this.attachments.get(n)).getSizeAsString();
    }

    public MimeBodyPart getAttachment(int n) {
        FileAttachment fileAttachment = (FileAttachment)this.attachments.get(n);
        return fileAttachment.getMimeBodyPart();
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public String getAttachmentNames(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getNbAttachments(); ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(this.getAttachmentName(i));
        }
        return stringBuffer.toString();
    }

    public void destroy() {
        this.log.debug((Object)"destroy() called");
        for (int i = this.getNbAttachments() - 1; i >= 0; --i) {
            this.delete(i);
        }
        this.attachments = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

