<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['blog'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP BLOG -------------------------------------------------------
require_once('class/Blog.class.php');
$blog = new Blog($db, null, $file);


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_language_name.lang.php');


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['blog']);
$rsp->user_id = $me['user_id'];


// SETUP WIKI ---------------------------------------------------------------
$wiki_path = "lib_view.php?user_id=" . $me['user_id'] . "&page=";
$wiki_new_path = "lib_edit.php?page=";
$wiki_image_base = "get_file.php?file=";

require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);


// SETUP BOOKMARKS ---------------------------------------------------------
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['blog'], $me['user_id']);
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];


//RECEIVE POST AND PROCESS --------------------------------------------------
if (!empty($frmdata)) {
	
	$frmdata['blog_synopsis'] = htmlspecialchars($frmdata['blog_synopsis']);
	$frmdata['blog_title'] = htmlspecialchars($frmdata['blog_title']);


	if (isset($frmdata['preview'])) {
		$frmdata['blog_body'] = stripslashes($frmdata['blog_body']);
		$frmdata['blog_synopsis'] = stripslashes($frmdata['blog_synopsis']);
		$frmdata['blog_title'] = stripslashes($frmdata['blog_title']);
		$frmdata['blog_body_preview'] = $wiki->transform($frmdata['blog_body'], 'Xhtml');
		
		if (!isset($frmdata['rsp_public_featured'])) {
			$frmdata['rsp_public_featured'] = 0;
		}
		
		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node'], 'degree_id' => $frmdata['rsp_node'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		$output_blog = $frmdata;
		
		$display = "allow_edit";
	}
	elseif (isset($frmdata['save']) || isset($frmdata['save_go'])) {

		if (empty($frmdata['blog_title'])) {
		    $GLOBALS['igloo_error_log'][] = array(11, null, null);
		}

		if (empty($frmdata['blog_synopsis'])) {
		    $GLOBALS['igloo_error_log'][] = array(30, null, null);
		}

		if (empty($frmdata['language_id'])) {
		    $frmdata['language_id'] = $me['language_id'];
		}

		if (empty($GLOBALS['igloo_error_log'])) {
			//
			if (isset($frmdata['blog_id']) && $frmdata['blog_id'] > 0) {
		         //we update the event
		 		$blog->updateBlog($frmdata);
			}
		 	else { //we insert record
		 		$blog->user_id = $me['user_id'];
		 		$blog->insertBlog($frmdata);

		 	}

			if (empty($GLOBALS['igloo_error_log'])) {
				//insert into setup rsp
				$temp['language_id'] = $me['language_id'];
				
				$temp['item_id'] = $blog->blog_id;
				//delete all
				$rsp->deleteRspItem($blog->blog_id);

				//insert node rsp entry
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					if (!empty($frmdata['rsp_node_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if ($frmdata['rsp_node'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_node'];
					}
					
					if($c_node['rsp']['node']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					
					if (!empty($frmdata['rsp_public_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if($c_node['rsp']['public']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				// add bookmark tracking
				$bookmark->item_id = $blog->blog_id;
				$bookmark->deleteBookmark();
				if (!empty($frmdata['ins_mark'])) {
					$bookmark->insertBookmark(1);
				}
				
				//setup statistics
				require_once('class/Statistic.class.php');
				$statistic = new Statistic($db, $c_node['rsp']['item_type']['blog'], $date);

				//update stats
				$statistic->user_id = $me['user_id'];
				$statistic->section_item_id = $me['user_id'];
				$statistic->statistic_type_id = $c_node['statistic']['user']['total_blogs'];
				
				$statistic->setStatistic($blog->selBlogCount());
				
				if (isset($frmdata['save_go'])) {
					header("Location: blg_view.php?blog_id=" . $blog->blog_id . "&".SID);
					exit;
				}
				else {
					header("Location: blg_edit.php?blog_id=" . $blog->blog_id . "&".SID);
					exit;
				}
			}
		}
		else { // something errored
			$output_blog = $frmdata;
		}

		$display = "allow_edit";


	}
}
elseif (isset($_REQUEST['blog_id']) && $_REQUEST['blog_id'] > 0) {
	$blog->blog_id = $_REQUEST['blog_id'];
	$output_blog = $blog->selBlog();

	if (isset($output_blog['user_id']) && $output_blog['user_id'] == $me['user_id']) { // we are allowed to edit
	    $display = "allow_edit";
	}
	else {
		unset($output_blog, $display);
	}
	
	//get bookmark
	$bookmark->item_id = $output_blog['blog_id'];
	$output_blog['bookmark'] = $bookmark->getBookmark(1);
}
else { // we add a record

	$display = "allow_edit";
}


// SETUP LIBRARY ---------------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, null);
$output_wikipages = $library->getPages();
$file->user_id = $me['user_id'];
$output_filenames = $file->getFiles();


//setup file ----------------------------------------------------------------
$file->user_id = $me['user_id'];
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


		
//RSP items
if (!empty($blog->blog_id)) {
	$output_blog['rsp'] = $rsp->selRspItem($blog->blog_id);
}

//move vars to template
if (!empty($output_wikipages)) {
	$body->set('wikipages', $output_wikipages);
}

if (!empty($output_filenames)) {
	$body->set('filenames', $output_filenames);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
