<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// Schedule contains all event and task functions

class Schedule {
	// CLASS FUNCTIONS
	// Schedule
	// selScheduleItems
	// addSelScheduleID
	// selScheduleItem
	// countScheduleAllocation
	// selScheduleAllocation
	// insertScheduleItem
	// updateScheduleItem
	// selScheduleAllocations
	// insertScheduleAllocation
	// updateScheduleAllocations
	// updateScheduleAllocation
	// deleteScheduleItem
	// addRpsLevelID
	// countScheduleItems




	// Schedule --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 7th April 2004
	//
	function Schedule($db, $rsp_item_type_id, $date, $file = null) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
		$this->date = $date;

		if (isset($file)) {
		    $this->file = $file;
		}

	}//EO Schedule



	// selScheduleItems ----------------------------------------------------
	// returns multiple rows from DB
	// tom calthrop - 7th April 2004
	//
	function selScheduleItems($search = null, $inc_allocation=null) {
		//SETUP DATES -----------------------------------------------------
		if (!empty($this->start_date)) {
			
			$start_date = $this->start_date;
			$start_date = $this->db->DBDate($start_date);
			
			if (!empty($this->no_of_days_shown)) {
				$da = trim(substr($start_date, 10, 2));
				$mh = trim(substr($start_date, 6, 2));
				$yr = trim(substr($start_date, 1, 4));
				
				$start_timestamp = mktime(0, 0, 0, $mh, $da, $yr);
				// 1 h = 3600 sec
				// 1 d = 24 h
				// 1 d = 86400 sec
				$this->end_date = $start_timestamp + (86400 * $this->no_of_days_shown);
				
				$end_date = Date("Y-m-d 00:00", $this->end_date);
				$end_date = $this->db->DBDate($end_date);
			}
		}
		
		$now = $this->db->DBDate(Date("Y-m-d 00:00"));
		
		//SELECT FROM DB -------------------------------------------------
		$query = "
			SELECT DISTINCT s.schedule_id, s.schedule_type_id, s.schedule_create_datetime,
			s.schedule_start_datetime, s.schedule_end_datetime,
			s.schedule_title, s.schedule_synopsis, s.schedule_body,
			s.schedule_location, s.schedule_occurence, s.file_id,
			s.schedule_category_id, s.status_id, s.schedule_priority_id,
			s.schedule_p_complete, s.schedule_allocation, s.user_id "
		;
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", pr.profile_create_datetime, pr.profile_nic, pr.profile_hometown, rsp.rsp_sticky, rsp.rsp_featured ";
		}
		
		if (isset($inc_allocation)) {
			$query .= ", sa.status_id as allocation_status_id ";
		}
		
		$query .= "FROM " . $this->db->prefix . "_schedule s ";
		
		if (isset($this->tag)) {
			$query .= ", " . $this->db->prefix . "_tag t  ";
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", " . $this->db->prefix . "_rsp rsp 
			JOIN " . $this->db->prefix . "_user_profile pr ON s.user_id=pr.user_id AND pr.profile_default=1 ";
		}
		
		if (isset($inc_allocation)) {
			$query .= ", " . $this->db->prefix . "_schedule_allocation sa ";
		}
		
		$query .= "WHERE ";
		
		if (isset($inc_allocation)) {
			$query .= "s.schedule_id=sa.schedule_id AND s.user_id=sa.user_id AND ";
		}
		
		if (isset($this->tag)) {
			$query .= "
				s.schedule_id=t.item_id AND 
				t.rsp_item_type_id=" . $this->item_types['schedule'] . " AND
				t.tag_body like " . $this->db->qstr("%" . $this->tag . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "
				rsp.item_id=s.schedule_id AND
				rsp.level_id=" . $this->rsp_level_id . " AND 
				rsp.rsp_item_type_id=" . $this->rsp_item_type_id . " AND "
			;
			
			if (isset($this->rsp_status_id)) {
				$query .= "rsp.status_id=" . $this->rsp_status_id . " AND ";
			}
			
			if (isset($this->degree_id)) {
				$query .= "rsp.degree_id>=" . $this->degree_id . " AND ";
			}
			else {
				$query .= "rsp.degree_id IS NULL AND ";
			}
			
			if (isset($this->rsp_featured)) {
				$query .= "rsp.rsp_featured=" . $this->rsp_featured . " AND ";
			}
			
		}
		
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->schedule_ids)) { //used for bookmarks
			$schedule_ids = "";
			foreach($this->schedule_ids as $key => $i):
				$schedule_ids .= $i;
				if (count($this->schedule_ids) > $key+1) {
					$schedule_ids .=",";
				}
			endforeach;
			$query .= "s.schedule_id in (" . $schedule_ids . ") AND ";
		}
		else {
			if (isset($this->schedule_type_id) && $this->schedule_type_id > 0) {
			    $query .= "s.schedule_type_id=" . $this->schedule_type_id . " AND ";
			}
		}
		
		if (isset($this->status_ids)) {
			$status_ids = "";
			foreach($this->status_ids as $key => $i):
				$status_ids .= $i;
				if (count($this->status_ids) > $key+1) {
					$status_ids .=",";
				}
			endforeach;
			$query .="s.status_id in (" . $status_ids . ") and ";
		}
		
		//NO REPEAT
		$query .= "(";
		
		if (isset($start_date)) {
			$query .= "s.schedule_start_datetime>=" . $start_date . " AND ";
		}
		
		if (isset($end_date)) {
			$query .= "s.schedule_end_datetime<=" . $end_date . " AND ";
		}
		
		$query .= "(s.schedule_occurence is null OR s.schedule_occurence=" . $this->schedule_config['occurrence']['no_repeat'] . ") OR ";
		
		if (isset($end_date)) {
			$repeat_end = " AND s.schedule_repeat_until<=" . $end_date;
		}
		else {
			$repeat_end = "";
		}
		
		//DAILY
		$query .= "(
			s.schedule_occurence=" . $this->schedule_config['occurrence']['daily'] . " AND 
			(s.schedule_repeat_until>" . $now . $repeat_end . " OR s.schedule_repeat_until is null)) OR ";
		
		//WEEKLY
		$query .= "
			(
			s.schedule_occurence=" . $this->schedule_config['occurrence']['weekly'] . " AND 
			(schedule_repeat_until>" . $now . $repeat_end . " OR s.schedule_repeat_until is null 
			)) OR "
		;
		
		//MONTHLY
		$query .= "
			(
			s.schedule_occurence=" . $this->schedule_config['occurrence']['monthly'] . " AND 
			(schedule_repeat_until>" . $now . $repeat_end . " OR s.schedule_repeat_until is null 
			)) OR"
		;
		
		//YEARLY
		$query .= "
			(
			s.schedule_occurence=" . $this->schedule_config['occurrence']['yearly'] . " AND 
			(schedule_repeat_until>" . $now . $repeat_end . " OR s.schedule_repeat_until is null 
			))"
		;
		
		$query .= ") AND ";
		
		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
					$user_ids .=",";
				}
			endforeach;
			$query .="s.user_id in (" . $user_ids . ") and ";
		}
		
		if (isset($search)) {
			$query .= "
				(s.schedule_title like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " OR
				s.schedule_synopsis like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . ") AND "
			;
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by s." . $this->order_by;
		}
		else {
			$query .= "order by s.schedule_start_datetime";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		//echo $query;
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				if (empty($temp1['schedule_all_day_item'])) {
				    $temp1['display_schedule_start_datetime'] = $this->date->formatDate($temp1['schedule_start_datetime'], 1);
					$temp1['display_schedule_end_datetime'] = $this->date->formatDate($temp1['schedule_end_datetime'], 1);
				}
				else {
					$temp1['display_schedule_start_datetime'] = $this->date->formatDate($temp1['schedule_start_datetime']);
					$temp1['display_schedule_end_datetime'] = $this->date->formatDate($temp1['schedule_end_datetime']);
				}

				if (isset($this->file)) {

					if (isset($this->file)) {
						if (isset($temp1['file_id'])) {
							$this->file->file_id = $temp1['file_id'];
							$temp1['image'] = $this->file->getFileRecord();
						}
						else {
							$temp1['image']['file_title'] = "";
							$temp1['image']['file'] = $this->file->noimage;
						}
					}
				}
				
				if (isset($search)) { //format search results
					$temp1['schedule_title'] = searchTextFormat($search, $temp1['schedule_title']);
					$temp1['schedule_synopsis'] = searchTextFormat($search, $temp1['schedule_synopsis']);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=selScheduleItems class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selScheduleItems



	// addSelScheduleID --------------------------------------------------------------------
	// builds an array of schedule ids for select statement.
	// addSelScheduleID(1); addSelScheduleID(2); addSelScheduleID(4)
	// select * from schedule where id in (1,2,4);
	// tom calthrop - 28th March 2005
	//
	function addSelScheduleID($schedule_id) {
		if (!isset($this->schedule_ids)) {
		    $this->schedule_ids = array();
		}

		$this->schedule_ids[] = $schedule_id;

	} //EO addSelScheduleID



	// selScheduleItem --------------------------------------------------------------------
	// returns single DB row
	// tom calthrop - 7th April 2004
	//
	function selScheduleItem() {
		$query = "
			SELECT schedule_id, schedule_type_id, schedule_create_datetime,
			schedule_start_datetime, schedule_end_datetime,
			schedule_title, schedule_synopsis, schedule_body,
			schedule_location, schedule_occurence, file_id,
			schedule_category_id, status_id, schedule_priority_id,
			schedule_p_complete, schedule_allocation,
			user_id, schedule_allow_comments, schedule_repeat_until 
			FROM " . $this->db->prefix . "_schedule
			WHERE schedule_id=" . $this->schedule_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;

			if (isset($temp['schedule_id'])) {
				//get allocation
				$temp['schedule_applicants'] = $this->countScheduleAllocation($temp['schedule_id'], $this->schedule_config['allocation_status']['pending']);
				$temp['schedule_confirmed'] = $this->countScheduleAllocation($temp['schedule_id'], $this->schedule_config['allocation_status']['confirmed']);

				//get my allocation status
				if (isset($this->user_id)) {
					$temp['allocation'] = $this->selScheduleAllocation($this->user_id, $temp['schedule_id']);
				}
			}
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selScheduleItem class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //selScheduleItem



	// countScheduleAllocation --------------------------------------------------------------------
	// returns count of the allocation
	// tom calthrop - 25th December 2004
	//
	function countScheduleAllocation($schedule_id, $status_id = null) {
		$query = "
			SELECT count(schedule_id) as total
			FROM " . $this->db->prefix . "_schedule_allocation
			WHERE
			schedule_id=" . $schedule_id . " AND "
		;

		if (isset($status_id)) {
		    $query .= "status_id=" . $status_id . " AND ";
		}

		$query .= "1=1";

		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=countScheduleAllocation class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO countScheduleAllocation



	// selScheduleAllocation --------------------------------------------------------------------
	// gets a users schedule allocation record
	// tom calthrop - 11th April 2004
	//
	function selScheduleAllocation($user_id, $schedule_id) {

		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_schedule_allocation
			WHERE
			user_id=" . $user_id . " and
			schedule_id=" . $schedule_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			$temp['schedule_allocation_create_datetime'] = $this->date->formatDate($temp['schedule_allocation_create_datetime']);

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=selScheduleAllocation class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selScheduleAllocation



	// insertScheduleItem --------------------------------------------------------------------
	// inserts a single DB row
	// tom calthrop - 31st March 2005
	//
	function insertScheduleItem($data) {
		
		if (empty($data['schedule_start_datetime'])) {
		    $data['schedule_start_datetime'] = "null";
		}

		if (empty($data['schedule_end_datetime'])) {
		    $data['schedule_end_datetime'] = "null";
		}
		
		if (empty($data['schedule_repeat_until'])) {
		    $data['schedule_repeat_until'] = "null";
		}
		
		if (empty($data['schedule_all_day_item'])) {
			$data['schedule_all_day_item']= "null";
		}

		if (empty($data['file_id'])) {
			$data['file_id']= "null";
		}

		if (empty($data['schedule_status_id'])) {
			$data['schedule_status_id'] = "null";
		}

		if (empty($data['schedule_type_id']) || (isset($data['schedule_type_id']) && $data['schedule_type_id'] < 1)) {
			$data['schedule_type_id'] = $this->schedule_config['type']['event'];
		}

		if (empty($data['schedule_p_complete'])) {
			$data['schedule_p_complete'] = "null";
		}

		if (empty($data['schedule_complete'])) {
			$data['schedule_complete'] = "null";
		}

		if (empty($data['schedule_allocation'])) {
			$data['schedule_allocation'] = "null";
		}

		if (empty($data['schedule_priority_id'])) {
			$data['schedule_priority_id'] = "null";
		}

		if (empty($data['schedule_allow_comments'])) {
			$data['schedule_allow_comments'] = "null";
		}

		if (empty($data['schedule_occurence'])) {
			$data['schedule_occurence'] = "null";
		}
		
		$rec = array();
		$rec['schedule_type_id'] = $data['schedule_type_id'];
		$rec['schedule_create_datetime'] = time();
		$rec['schedule_start_datetime'] = $data['schedule_start_datetime'];
		$rec['schedule_end_datetime'] = $data['schedule_end_datetime'];
		$rec['schedule_title'] = $data['schedule_title'];
		$rec['schedule_synopsis'] = $data['schedule_synopsis'];
		$rec['schedule_body'] = $data['schedule_body'];
		$rec['schedule_location'] = $data['schedule_location'];
		$rec['schedule_occurence'] = $data['schedule_occurence'];
		$rec['schedule_repeat_until'] = $data['schedule_repeat_until'];
		$rec['file_id'] = $data['file_id'];
		$rec['user_id'] = $this->user_id;
		$rec['schedule_category_id'] = $data['schedule_category_id'];
		$rec['status_id'] = $data['schedule_status_id'];
		$rec['schedule_priority_id'] = $data['schedule_priority_id'];
		$rec['schedule_complete'] = $data['schedule_complete'];
		$rec['schedule_p_complete'] = $data['schedule_p_complete'];
		$rec['schedule_allocation'] = $data['schedule_allocation'];
		$rec['schedule_allow_comments'] = $data['schedule_allow_comments'];
		$rec['language_id'] = $data['language_id'];
		
		$table = $this->db->prefix . "_schedule";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			
			$this->schedule_id = $this->db->Insert_ID();
			
		}
		else {
			$error_info = "function=insertScheduleItem class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertScheduleItem




	// updateScheduleItem --------------------------------------------------------------------
	// upates schedule item
	// tom calthrop - 31st March 2005
	//
	function updateScheduleItem($data) {
		
		if (empty($data['schedule_start_datetime'])) {
		    $data['schedule_start_datetime'] = "null";
		}

		if (empty($data['schedule_end_datetime'])) {
		    $data['schedule_end_datetime'] = "null";
		}
		
		if (empty($data['schedule_repeat_until'])) {
		    $data['schedule_repeat_until'] = "null";
		}

		if (empty($data['file_id'])) {
			$data['file_id']= "null";
		}

		if (empty($data['schedule_status_id'])) {
			$data['schedule_status_id'] = "null";
		}

		if (empty($data['schedule_type_id']) || (isset($data['schedule_type_id']) && $data['schedule_type_id'] < 1)) {
			$data['schedule_type_id'] = $this->schedule_config['type']['event'];
		}

		if (empty($data['schedule_p_complete'])) {
			$data['schedule_p_complete'] = "null";
		}

		if (empty($data['schedule_allocation'])) {
			$data['schedule_allocation'] = "null";
		}

		if (empty($data['schedule_priority_id'])) {
			$data['schedule_priority_id'] = "null";
		}

		if (empty($data['schedule_allow_comments'])) {
			$data['schedule_allow_comments'] = "null";
		}

		if (empty($data['schedule_complete'])) {
			$data['schedule_complete'] = "null";
		}

		if (empty($data['schedule_occurence'])) {
			$data['schedule_occurence'] = "null";
		}

		$this->schedule_id = $data['schedule_id'];
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_schedule 
			WHERE 
			schedule_id=" . $this->schedule_id
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['schedule_start_datetime'] = $data['schedule_start_datetime'];
		$rec['schedule_end_datetime'] = $data['schedule_end_datetime'];
		$rec['schedule_title'] = $data['schedule_title'];
		$rec['schedule_synopsis'] = $data['schedule_synopsis'];
		$rec['schedule_body'] = $data['schedule_body'];
		$rec['schedule_location'] = $data['schedule_location'];
		$rec['schedule_occurence'] = $data['schedule_occurence'];
		$rec['schedule_repeat_until'] = $data['schedule_repeat_until'];
		$rec['file_id'] = $data['file_id'];
		$rec['schedule_category_id'] = $data['schedule_category_id'];
		$rec['status_id'] = $data['schedule_status_id'];
		$rec['schedule_priority_id'] = $data['schedule_priority_id'];
		$rec['schedule_complete'] = $data['schedule_complete'];
		$rec['schedule_p_complete'] = $data['schedule_p_complete'];
		$rec['schedule_allocation'] = $data['schedule_allocation'];
		$rec['schedule_allow_comments'] = $data['schedule_allow_comments'];
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		
	}//EO updateScheduleItem



	// selScheduleAllocation --------------------------------------------------------------------
	// returns multiple DB rows
	// tom calthrop - 7th April 2004
	//
	function selScheduleAllocations() {

		$query = "
			SELECT user_id, schedule_allocation_create_datetime, status_id
			FROM " . $this->db->prefix . "_schedule_allocation
			WHERE
			schedule_id=" . $this->schedule_id
			;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selScheduleAllocations class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selScheduleAllocations



	// insertScheduleAllocation --------------------------------------------------------------------
	// inserts multiple DB rows
	// tom calthrop - 7th April 2004
	//
	function insertScheduleAllocation($schedule_id, $user_id, $status_id) {
		
		$rec = array();
		$rec['schedule_id'] = $schedule_id;
		$rec['status_id'] = $status_id;
		$rec['schedule_allocation_create_datetime'] = time();
		$rec['user_id'] = $user_id;
		
		$table = $this->db->prefix . "_schedule_allocation";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	}//EO insertScheduleAllocation



	// updateScheduleAllocations --------------------------------------------------------------------
	// updates multiple DB rows
	// tom calthrop - 11th April 2004
	//
	function updateScheduleAllocations($schedule_id, $user_arr, $status_arr)
	{
		$rownums = count ($user_arr);

		for ($i=0; $i < $rownums; $i++) {
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_schedule_allocation 
				WHERE 
				user_id = " . $user_arr[$i] . " AND 
				schedule_id=" . $schedule_id
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['status_id'] = $status_arr[$i];
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
		}
	}//EO updateScheduleAllocations



	// updateScheduleAllocation --------------------------------------------------------------------
	// updates single DB rows
	// tom calthrop - 11th April 2004
	//
	function updateScheduleAllocation($schedule_id, $user_id, $status_id) {
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_schedule_allocation 
			WHERE 
			user_id = " . $user_id . " AND 
			schedule_id=" . $schedule_id
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['status_id'] = $status_arr[$i];
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	}//EO updateScheduleAllocation



	// deleteScheduleItem --------------------------------------------------------------------
	// deletes a single DB row
	// tom calthrop - 11th April 2004
	//
	function deleteScheduleItem($schedule_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_schedule
			WHERE schedule_id=" .  $schedule_id
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteScheduleItem class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteScheduleItem



	// addRpsLevelID --------------------------------------------------------------------
	// builds an array of rsp level ids for select statement.
	// addRpsLevelID(1); addRpsLevelID(2); addRpsLevelID(4)
	// select * from schedule left join on rsp where rsp.level_id in (1,2,4);
	// tom calthrop - 28th March 2005
	//
	function addRpsLevelID($level_id) {
		if (!isset($this->rsp_level_ids)) {
		    $this->rsp_level_ids = array();
		}

		$this->rsp_level_ids[] = $level_id;

	} //EO addRpsLevelID



	// countScheduleItems --------------------------------------------------------------------
	// returns count of future events
	// tom calthrop - 20th April 2005
	//
	function countScheduleItems() {

		//SETUP DATES -----------------------------------------------------
		$this->start_date = mktime();

		$mh  = $this->start_date['mon'];
		$da  = $this->start_date['mday'];
		$yr  = $this->start_date['year'];

		$start_date = Date("d-m-Y H:i", $this->start_date);
		

		//SELECT FROM DB -------------------------------------------------
		$query = "
			SELECT count(s.schedule_id) as total 
			FROM " . $this->db->prefix . "_schedule s 
			WHERE 
			s.status_id in (" . $this->schedule_config['status']['confirmed'] . "," . $this->schedule_config['status']['tentative'] . ") AND 
			s.schedule_start_datetime>='" . $start_date . "' AND "
		;
		
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->schedule_type_id)) {
		    $query .= "s.schedule_type_id=" . $this->schedule_type_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			if ($result->fields['total'] > 0) {
			    return $result->fields['total'];
			}
			else {
				return 0;
			}
			
		}
		else {
			$error_info = "function=countScheduleItems class=Schedule.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO countScheduleItems

}

?>
