<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "config/config_igloo.inc.php";
include "config/config_acs.inc.php";
include "inc/functions.inc.php";


// SETUP ERROR HANDLING -----------------------------------------------------------------------
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['igloo_error_log'] = array();


// SETUP DATABASE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
if (!$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db'])) {
	header("Location: error.php?error=1");
	exit;
}
$db->prefix = $c_node['db']['prefix'];


//SETUP DATE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Date.class.php');
$date = new Date();


// START SESSION --------------------------------------------------------------
session_start();


// SETUP USER -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'User.class.php');
$user = new User($db, $date);
$user->relation_type = $c_node['user']['relation_type']['approved']; //not sure we need this - tom 7th dec 2004
$user->status_ids = $c_node['user']['status'];
$user->language_arr = $c_node['node']['language'];

if(!empty($_SESSION['s_md5'])) {
	//authenticate user
	$user->authUser();
	
	$me = $_SESSION;
	$me['user_id'] = $me['s_user_id'];
	
	
	//SETUP USER MESSAGES ------------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'IM.class.php');
	$im = new IM($me['user_id'], $db, $c_node['messaging']['message_box_max_size']);
	// Setting the message status coding
	$im->setStatus($c_node['messaging']['message_status_unread'], $c_node['messaging']['message_status_read']);
	$im->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
	//get inbox unread message count
	$me['mail'] = $im->messageCount();
	
	$rsp_level_id = $c_node['rsp']['rsp_level']['node'];
}
else { //treat as public
	$me['role_id'] = 				0;
	$me['language_id'] = 			$c_node['node']['language']['default'];
	$me['template_id'] = 			$c_node['node']['template_default_name'];
	
	if(empty($_SESSION['language_ids'])) {
		$_SESSION['breadcrumb'] = 			array();
		$_SESSION['language_ids'] = 		array();
		$_SESSION['user_homepage'] = 		$c_node['node']['page_default'];
		
		if (!empty($c_node['node']['language']['pack'])) {
			foreach($c_node['node']['language']['pack'] as $key => $i):
				$me['language_ids'][] = $key;
			endforeach;
		}
	}
		
	$me['breadcrumb'] = 			$_SESSION['breadcrumb'];
	$me['language_ids'] = 			$_SESSION['language_ids'];
	$me['user_homepage'] = 			$_SESSION['user_homepage'];
	
	$user_acs = array();
	
	$rsp_level_id = $c_node['rsp']['rsp_level']['public'];
}


// SETUP UP USER ACS -------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Acs.class.php');
$user_acs = new Acs($me['role_id'], $db);







//SETUP SHOUT -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Shout.class.php');
$shout = new Shout($db, $date);
$shoutbox = $shout->getShout();


//SETUP FILE -----------------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'File.class.php');
$file = new File($db, null, $c_node['file'], $c_node['dir']);
$file->config_ids = $c_node['file'];


// SETUP TEMPLATE -------------------------------------------------------------------
$template_path = $c_node['dir']['template_path'];

if (isset($me['template_id'])) {
    $template_name = $me['template_id'];
}
else {
	$template_name = $c_node['node']['template_default_name'];
}

$template_path = $template_path . $template_name . "/";

require_once($c_node['dir']['class_path'] . 'Template.class.php');
$tpl = & new Template($template_path); // This is the outter template
$tpl->date = $date;
$body = & new Template($template_path); // This is the inner template
$body->date = $date;
$page_name_full = basename($_SERVER['REQUEST_URI']);
$page_name = explode(".",$page_name_full);

// SETUP LANGUAGE -----------------------------------------------------------
if (!isset($me['user_id']) || $me['user_id'] < 1) {
	if (isset($_REQUEST['language_id'])) {
		$_SESSION['language_id'] = $_REQUEST['language_id'];
	}
	
	if (isset($_SESSION['language_id'])) {
		$me['language_id'] = $_SESSION['language_id'];
	}
}

$languagePath = "language/" . $me['language_id'] . "/" . $template_name . "/";
$languageArrayPath = $languagePath . "arrays/";
$languageTextPath = $languagePath . "texts/";
//require_once($languagePath . 'common.lang.php');
require_once($languageArrayPath . 'arr_links.lang.php');
require_once($languageArrayPath . 'arr_error.lang.php');
require_once($languagePath . $page_name[0] .'.lang.php');


// RETREIVE FORM VARS ------------------------------------------------------
if (isset($_POST)) {
	$frmdata = $_POST;
}

// DICTIONARY ---------------------------------------------------------------
// Is the config set to allow spell checking?
if (!empty($c_node['node']['language']['aspell']['command'])) {
    $body->set('allow_spellcheck', 1);
}


// SETUP LOGGING ---------------------------------------------------
$GLOBALS['igloo_log'] = $c_node['log'];

//display languages if not logged in
if (!isset($me['user_id']) || $me['user_id'] < 1) {
	require_once($languageArrayPath . 'arr_language_name.lang.php');
}

?>
