#!/usr/bin/perl -w  # -*- cperl -*- #
#
#  oggtagreader.pm - A simplistic OGG Vorbis file tag reader.
#
#  GNU MP3D - A portable(ish) MP3 server.
#
# Homepage:
#   http://www.gnump3d.org/
#
# Author:
#  Steve Kemp <steve@steve.org.uk>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  Steve Kemp
#  ---
#  http://www.steve.org.uk/


package gnump3d::oggtagreader;  # Must live in oggtagreader.pm
# use utf8;                       # Support foreign character sets.


#
#  Create a new instance of this class.
#
sub new {
    my $classname  = shift;         # What class are we constructing?
    my $self      = {};             # Allocate new memory
    bless($self, $classname);       # Mark it of the right type

    return $self;
} 


#
#  Read and return a hash of all the tags found in the given file.
#
#  This is a very simplistic algorithm, which may not work for you.
#
#
sub getTags($)
{
    my($self, $filename ) = (@_);
    open(OGG, "<$filename" )         or die "can't open $filename: $!";
    binmode(OGG);
    my $buff = "";
    read(OGG, $buff, 2048);
    close( OGG );

    my %TAGS = ();

    $TAGS{'artist'}   = getTag( $buff, "artist" );
    $TAGS{'title'}    = getTag( $buff, "title" );
    $TAGS{'album'}    = getTag( $buff, "album" );
    $TAGS{'comment'}  = getTag( $buff, "comment" );
    $TAGS{'genre'}    = getTag( $buff, "genre" );
    $TAGS{'track'}    = getTag( $buff, "tracknumber" );

    return( %TAGS );
}


#
#  Find a given tag in the buffer read from the file in
# our 'getTags' method
#
sub getTag( $ $ )
{
    my ( $buff, $tag ) = (@_);

    $buff =~ s/[[:^print:]]/=/g;

    if ( $buff =~ /$tag=([^=]+)/i )
    {
	my $value = $1;
	return( $value );
    }
    return( undef );
}


#
# End of module
#
1;
