% FUNCTION M = gf_mdstate_set(cmd, [, args])
%   Modify a model state object.
%   
%   * gf_mdstate_set(mds,'compute_reduced_system')
%   Compute the reduced system from the tangent matrix and constraints.
% 
%   * gf_mdstate_set(mds,'compute_reduced_residual')
%   Compute the reduced residual from the residual and constraints.
% 
%   * gf_mdstate_set(mds,'compute_residual', @mdbrick B)
%   Compute the residual for the brick B.
% 
%   * gf_mdstate_set(mds,'compute_tangent_matrix', @mdbrick B)
%   Update the tangent matrix from the brick B.
% 
%   * gf_mdstate_set(mds,'clear')
%   Clear the model state.
% 
% 
%   $Id: gf_mdstate_set.cc,v 1.4 2006/03/28 10:06:35 pommier Exp $
function [varargout]=gf_mdstate_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdstate_set',varargin{:});
  else
    gf_matlab('mdstate_set',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
