% FUNCTION I = gf_geotrans_get(GT, ...)
%     General function for querying information about geometric transformations 
%     objects.
% 
%   * gf_geotrans_get(CVS,'dim')
%   Get the dimension of the geometric transformation.   This is the dimension of
%   the source space, i.e. the dimension of the reference convex.
% 
%   * gf_geotrans_get(CVS,'is_linear')
%   Return 0 if the geometric transformation is not linear.
% 
%   * gf_geotrans_get(CVS,'nbpts')
%   return the number of points of the geometric transformation.
% 
%   * gf_geotrans_get(CVS,'pts')
%   Return the reference convex points.  The points are stored in the columns of
%   the output matrix.
% 
%   * gf_geotrans_get(CVS,'normals')
%   Get the normals for each face of the reference convex
% 
%   * gf_geotrans_get(CVS,'transform',G,pts)
%   Apply the geometric transformation to a set of points.  G is the set of
%   vertices of the real convex, pts is the set of points (in the reference
%   convex) that are to be transformed. The corresponding set of points in the
%   real convex is returned.
% 
%   * gf_geotrans_get(CVS,'char')
%   Output a (unique) string representation of the @tgeotrans.   This can be used
%   to perform comparisons between two different @tgeotrans objects.
% 
function [varargout]=gf_geotrans_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('geotrans_get',varargin{:});
  else
    gf_matlab('geotrans_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
