% FUNCTION I = gf_geotrans(name)
% General function for building descriptors to geometric transformations.  Name
% can be:  * 'GT_PK(N,K)'   : Transformation on simplexes, dim N, degree K *
% 'GT_QK(N,K)'   : Transformation on parallelepipeds, dim N, degree K *
% 'GT_PRISM(N,K)'          : Transformation on prisms, dim N, degree K *
% 'GT_PRODUCT(a,b)'        : tensorial product of two transformations *
% 'GT_LINEAR_PRODUCT(a,b)' : Linear tensorial product of two transformations
function [varargout]=gf_geotrans(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('geotrans',varargin{:});
  else
    gf_matlab('geotrans',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
