/*
 * Decompiled with CFR 0.152.
 */
package org.natto.swingGUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.natto.ExecSecurity;
import org.natto.GenGui;
import org.natto.Infofiles;
import org.natto.jobDescription;
import org.natto.swingGUI.BareBonesBrowserLaunch;
import org.natto.swingGUI.SubmitGui;
import org.natto.swingGUI.hostSelectDialog;

public class MainGui
implements GenGui {
    static ExecSecurity mySecurity = ExecSecurity.getInstance();
    private final String secIsOffText = "<html>&nbsp;Security is off, tasks will be executed<br/>&nbsp;without checking their signatures.</html>";
    private final String secIsOnText = "<html>&nbsp;Security is on, only valid, signed tasks<br/>&nbsp;will be executed.</html>";
    private final String turnSecOnButtonText = "Turn security on";
    private final String turnSecOffButtonText = "Turn security off";
    private JLabel messageLabel = new JLabel();
    private String defaultMsg = "";
    private JLabel tellLabel = new JLabel(" ");
    private JLabel secLabel = new JLabel(" ");
    private JButton secButton = null;
    private JButton submitButton = null;
    private JButton spyButton = null;
    private JButton cButton = null;
    private String mainDir = "";
    private HashMap infos = null;

    public MainGui(String appName, String myDir) {
        String myMsg;
        this.defaultMsg = myMsg = "Program " + appName + " is now running in directory" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n" + myDir + "\nuntil you close this application.";
        this.mainDir = myDir;
        try {
            new nonBlockingDialog("Executor", myMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(myMsg);
        }
    }

    public void updateInfosActivate(HashMap hm) {
        this.infos = hm;
        if (this.cButton != null) {
            this.cButton.setEnabled(true);
        }
        if (this.submitButton != null) {
            this.submitButton.setEnabled(true);
        }
        if (this.spyButton != null) {
            this.spyButton.setEnabled(true);
        }
        if (this.secButton != null) {
            this.secButton.setEnabled(true);
        }
    }

    public void setMessage(String msg) {
        if ("".equals(msg)) {
            msg = this.defaultMsg;
        }
        String htmlMsg = msg.replace("\n", "<br/>");
        htmlMsg = "<html>" + htmlMsg + "</html>";
        try {
            this.messageLabel.setHorizontalAlignment(2);
            this.messageLabel.setText(htmlMsg);
        }
        catch (Exception e) {
            System.out.println(msg);
        }
    }

    public void setSecurityMessages() {
        try {
            if (mySecurity.securityOn()) {
                this.secLabel.setText("<html>&nbsp;Security is on, only valid, signed tasks<br/>&nbsp;will be executed.</html>");
                this.secButton.setText("Turn security off");
            } else {
                this.secLabel.setText("<html>&nbsp;Security is off, tasks will be executed<br/>&nbsp;without checking their signatures.</html>");
                this.secButton.setText("Turn security on");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showJobFinishDiag(String notif, String dirName, int exitCode) {
        int optionType = 2;
        int res = JOptionPane.showConfirmDialog(null, "Task finished, code: " + exitCode + ".\n" + notif + "\n" + "Press OK to see the files", "Your task", optionType);
        if (res == 0) {
            try {
                BareBonesBrowserLaunch.openURL(dirName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String doAsk(String myQuestion) {
        int okLen = 40;
        String[] parts = myQuestion.split(" ");
        String tmp = "";
        int thisLineLen = 0;
        for (int i = 0; i < parts.length; ++i) {
            int thisPartLen = parts[i].length();
            tmp = tmp + " " + parts[i];
            if ((thisLineLen += thisPartLen) <= okLen) continue;
            tmp = tmp + "\n";
            thisLineLen = 0;
        }
        String s = JOptionPane.showInputDialog(null, (Object)tmp);
        return s;
    }

    public void doTell(String myNote) {
        this.tellLabel.setText(" " + myNote);
    }

    class myMenuListener
    implements MenuListener {
        myMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            try {
                String toPage = "http://www.nongnu.org/executor/";
                BareBonesBrowserLaunch.openURL(toPage);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void menuDeselected(MenuEvent e) {
        }
    }

    public class nonBlockingDialog
    extends JDialog
    implements ActionListener {
        public nonBlockingDialog(String title, String message) {
            super(new JFrame(), title, true);
            JMenuBar menubar = new JMenuBar();
            JMenu helpMenu = new JMenu("Help and examples");
            menubar.add(helpMenu);
            this.setJMenuBar(menubar);
            myMenuListener mml = new myMenuListener();
            helpMenu.addMenuListener(mml);
            JPanel messagePane = new JPanel();
            this.getContentPane().add((Component)messagePane, "North");
            messagePane.add(MainGui.this.messageLabel);
            MainGui.this.setMessage(message);
            JPanel discPane = new JPanel(new BorderLayout());
            discPane.add((Component)MainGui.this.secLabel, "West");
            MainGui.this.secButton = new JButton("");
            MainGui.this.secButton.addActionListener(this);
            MainGui.this.setSecurityMessages();
            discPane.add((Component)MainGui.this.secButton, "East");
            discPane.add((Component)MainGui.this.tellLabel, "South");
            this.getContentPane().add((Component)discPane, "Center");
            JPanel buttonPane = new JPanel();
            MainGui.this.cButton = new JButton("Close");
            MainGui.this.spyButton = new JButton("See hosts");
            JLabel empty = new JLabel("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>");
            MainGui.this.submitButton = new JButton("Submit");
            this.setModal(false);
            buttonPane.add(MainGui.this.submitButton);
            buttonPane.add(MainGui.this.spyButton);
            buttonPane.add(empty);
            buttonPane.add(MainGui.this.cButton);
            MainGui.this.submitButton.addActionListener(this);
            MainGui.this.spyButton.addActionListener(this);
            MainGui.this.cButton.addActionListener(this);
            MainGui.this.submitButton.setEnabled(false);
            MainGui.this.cButton.setEnabled(false);
            MainGui.this.secButton.setEnabled(false);
            MainGui.this.spyButton.setEnabled(false);
            this.getContentPane().add((Component)buttonPane, "South");
            this.setDefaultCloseOperation(0);
            this.pack();
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent actEv) {
            String alertMsg = "";
            if (actEv.getSource() == MainGui.this.cButton) {
                this.setVisible(false);
                this.dispose();
                System.exit(0);
            }
            if (actEv.getSource() == MainGui.this.secButton) {
                if (mySecurity.securityOn()) {
                    mySecurity.turnOff();
                } else {
                    alertMsg = mySecurity.turnOn();
                    String sigNers = mySecurity.getSigners();
                    if (!sigNers.equals("")) {
                        JOptionPane.showMessageDialog(null, "Accepting tasks from:\n" + sigNers);
                    }
                }
                if (!"".equals(alertMsg)) {
                    JOptionPane.showMessageDialog(null, alertMsg);
                }
                JOptionPane.showMessageDialog(null, "Please make sure you\nunderstand how this works by checking\nHelp and Examples in the menu.");
                MainGui.this.setSecurityMessages();
            }
            if (actEv.getSource() == MainGui.this.submitButton) {
                SubmitGui subGui = new SubmitGui(MainGui.this.mainDir, MainGui.this.infos, "");
            }
            if (actEv.getSource() == MainGui.this.spyButton) {
                Set keys = MainGui.this.infos.keySet();
                Object[] keyObjVals = keys.toArray();
                String[] keyVals = new String[keyObjVals.length];
                for (int i = 0; i < keyObjVals.length; ++i) {
                    String hostInfoKey = keyObjVals[i].toString();
                    String n = Infofiles.getHostProperty(MainGui.this.infos, hostInfoKey, "name");
                    keyVals[i] = n + " (" + hostInfoKey + ")";
                }
                hostSelectDialog hSel = new hostSelectDialog(null, true, keyVals);
                String[] hostAction = hSel.getSelectedHostAndAction();
                String toHost = hostAction[0];
                String toAction = hostAction[1];
                if (toHost != null) {
                    if (toAction.equals("see")) {
                        jobDescription jDesc = new jobDescription(MainGui.this.mainDir);
                        jDesc.writeInternalCommand("XMLLS", "$HOME", toHost);
                    } else {
                        SubmitGui subGui = new SubmitGui(MainGui.this.mainDir, MainGui.this.infos, toHost);
                    }
                }
            }
        }
    }
}

