# Use genStubs.tcl (/tools in TCL source package) to generate
# versisDecls.h and versisStubInit.c from this file.
#
# Procedure:
# touch versisDecls.h
# touch versisStubInit.c
# ./genStubs.tcl . versis.decls
#
# Problem: if there are no arguments, you have to add parenthesis and
# remove some '*' in generated file versisDecls.h, moreover you have to
# remove '&' in generated file versisStubInit.c.

library versis
interface versis
declare 0 generic {
  int versis_status
}
declare 1 generic {
  void Versis_InitPkg()
}
declare 2 generic {
  void Versis_ExitPkg()
} 
declare 3 generic {
  void Versis_AboutPkg()
} 
declare 4 generic {
  void Versis_Compose(Est_String name, int type, Est_String process, Est_String actions, Est_Boolean onthefly)
} 
declare 5 generic {
  void Versis_ComposeInit(Est_String name)
} 
declare 6 generic {
  int Versis_ComposeStep(int numcomp, int N)
} 
declare 7 generic {
  void Versis_ComposeFinish(int numcomp)
} 
declare 8 generic {
  Est_Boolean Versis_Equivalence(int type, int par1, Est_String name1, int par2, Est_String name2)
} 
declare 9 generic {
  int Versis_Minimization(int type, int par, Est_String name)
} 
declare 10 generic {
  void Versis_ChangeRename(Est_String process, Est_String name1, Est_String name2)
} 
declare 11 generic {
  void Versis_ChangeHide(Est_String process, Est_String name1)
} 
declare 12 generic {
  void Versis_ChangeForbid(Est_String process, Est_String name1)
} 
declare 13 generic {
  Bdd_Edge Versis_CheckDeadlock(Bdd_Edge D)
} 
declare 14 generic {
  Bdd_Edge Versis_CheckDivergence(Bdd_Edge D, Bdd_Edge tau)
} 
