/**CHeaderFile*************************************************************
  PackageName [bdd]
  Synopsis    [Package 'bdd' enable symbolic computations by representing
               Boolean functions with ROBDDs.]

  FileName    [bddDecls.h]
  Revision    [$Revision: 76 $]
  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [Generated by genStubs.tcl, see http://wiki.tcl.tk/3358]
  SeeAlso     [bdd.h, bdd.decls, bddStubInit.c, bddStubLib.c]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2013
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations: implemented in bdd.h
 */

typedef struct BddStubs {
    int magic;
    const struct BddStubHooks *hooks;

    int *bdd_status; /* 0 */
    Bdd_Edge *bdd_termTrue; /* 1 */
    Bdd_Edge *bdd_termFalse; /* 2 */
    Bdd_Edge *bdd_termNull; /* 3 */
    void (*bdd_InitPkg) (); /* 4 */
    void (*bdd_ExitPkg) (); /* 5 */
    void (*bdd_AboutPkg) (); /* 6 */
    Bdd_Edge (*bdd_GetThen) (Bdd_Edge f); /* 7 */
    Bdd_Edge (*bdd_GetElse) (Bdd_Edge f); /* 8 */
    Bdd_Variable (*bdd_GetVariable) (Bdd_Edge f); /* 9 */
    Est_String (*bdd_GetVariableName) (Bdd_Edge f); /* 10 */
    char (*bdd_GetVariableChar) (Bdd_Edge f); /* 11 */
    Est_String (*bdd_GetIthVariableName) (int i); /* 12 */
    int (*bdd_GetVariableOrder) (Bdd_Edge f); /* 13 */
    Bdd_Edge (*bdd_FoaTerminal) (Est_String x); /* 14 */
    Bdd_Edge (*bdd_NOT) (Bdd_Edge f); /* 15 */
    Bdd_Edge (*bdd_TransferMark) (Bdd_Edge f, Est_Boolean mark); /* 16 */
    Bdd_Edge (*bdd_ITE) (Bdd_Edge f, Bdd_Edge g, Bdd_Edge h); /* 17 */
    Bdd_Edge (*bdd_Restrict) (Bdd_Edge f, Bdd_Variable v, Est_Boolean value); /* 18 */
    Bdd_Edge (*bdd_Compose) (Bdd_Edge f, Bdd_Variable v, Bdd_Edge g); /* 19 */
    Bdd_Edge (*bdd_E) (Bdd_Edge f, Bdd_Variable v); /* 20 */
    Bdd_Edge (*bdd_A) (Bdd_Edge f, Bdd_Variable v); /* 21 */
    void (*bdd_IncCounter) (); /* 22 */
    void (*bdd_Fresh) (Bdd_Edge f); /* 23 */
    void (*bdd_Fortify) (Bdd_Edge f); /* 24 */
    void (*bdd_Garbage) (); /* 25 */
    void (*bdd_SystemStat) (FILE *s); /* 26 */
    int (*bdd_FunctionStat) (FILE *s, Bdd_Edge f); /* 27 */
    Est_Boolean (*bdd_FindFormula) (Est_String x, Bdd_Edge *f); /* 28 */
    void (*bdd_AddFormula) (Est_String x, Bdd_Edge f); /* 29 */
    void (*bdd_SaveFormula) (Est_String prefix, Est_String name, Bdd_Edge f); /* 30 */
    Bdd_Edge (*bdd_ExtractBranch) (Bdd_Edge f); /* 31 */
    Bdd_Edge (*bdd_Expand) (Est_String fname, Bdd_Edge f); /* 32 */
    Bdd_Edge (*bdd_Expr) (Est_String s); /* 33 */
    void (*bdd_WriteFunction) (FILE *s, Est_String name); /* 34 */
    void (*bdd_WriteBDD) (FILE *s, Est_String name); /* 35 */
    int (*bdd_WriteDot) (FILE *s, Est_String name, int id); /* 36 */
    int (*bdd_WriteBDDView) (FILE *s, Est_String name, int id); /* 37 */
    int (*bdd_WriteGraphML) (FILE *s, Est_String name); /* 38 */
    int (*bdd_ReadGraphML) (FILE *s); /* 39 */
    Bdd_Edge (*bdd_RelOp) (Bdd_Edge f, Bdd_Edge g, Est_String format, Est_Boolean firsttime); /* 40 */
    Bdd_Edge (*bdd_RelOpSimple) (Bdd_Edge f, Est_String format, Est_Boolean firsttime); /* 41 */
    Bdd_Edge (*bdd_RelOpComplex) (Bdd_Edge f, Est_String format, Est_Boolean firsttime); /* 42 */
    Bdd_Edge (*bdd_NewState) (Bdd_Edge f); /* 43 */
    Bdd_Edge (*bdd_NewState1) (Bdd_Edge f, Est_String name); /* 44 */
    Bdd_Edge (*bdd_NewState2) (Bdd_Edge f, Est_String name1, Est_String name2); /* 45 */
    Bdd_Edge (*bdd_NewEq) (Bdd_Edge f, Bdd_Edge g); /* 46 */
} BddStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern const BddStubs *bddStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_BDD_STUBS)

/*
 * Inline function declarations:
 */

#define bdd_status \
	(*bddStubsPtr->bdd_status) /* 0 */
#define bdd_termTrue \
	(*bddStubsPtr->bdd_termTrue) /* 1 */
#define bdd_termFalse \
	(*bddStubsPtr->bdd_termFalse) /* 2 */
#define bdd_termNull \
	(*bddStubsPtr->bdd_termNull) /* 3 */
#define Bdd_InitPkg \
	(bddStubsPtr->bdd_InitPkg) /* 4 */
#define Bdd_ExitPkg \
	(bddStubsPtr->bdd_ExitPkg) /* 5 */
#define Bdd_AboutPkg \
	(bddStubsPtr->bdd_AboutPkg) /* 6 */
#define Bdd_GetThen \
	(bddStubsPtr->bdd_GetThen) /* 7 */
#define Bdd_GetElse \
	(bddStubsPtr->bdd_GetElse) /* 8 */
#define Bdd_GetVariable \
	(bddStubsPtr->bdd_GetVariable) /* 9 */
#define Bdd_GetVariableName \
	(bddStubsPtr->bdd_GetVariableName) /* 10 */
#define Bdd_GetVariableChar \
	(bddStubsPtr->bdd_GetVariableChar) /* 11 */
#define Bdd_GetIthVariableName \
	(bddStubsPtr->bdd_GetIthVariableName) /* 12 */
#define Bdd_GetVariableOrder \
	(bddStubsPtr->bdd_GetVariableOrder) /* 13 */
#define Bdd_FoaTerminal \
	(bddStubsPtr->bdd_FoaTerminal) /* 14 */
#define Bdd_NOT \
	(bddStubsPtr->bdd_NOT) /* 15 */
#define Bdd_TransferMark \
	(bddStubsPtr->bdd_TransferMark) /* 16 */
#define Bdd_ITE \
	(bddStubsPtr->bdd_ITE) /* 17 */
#define Bdd_Restrict \
	(bddStubsPtr->bdd_Restrict) /* 18 */
#define Bdd_Compose \
	(bddStubsPtr->bdd_Compose) /* 19 */
#define Bdd_E \
	(bddStubsPtr->bdd_E) /* 20 */
#define Bdd_A \
	(bddStubsPtr->bdd_A) /* 21 */
#define Bdd_IncCounter \
	(bddStubsPtr->bdd_IncCounter) /* 22 */
#define Bdd_Fresh \
	(bddStubsPtr->bdd_Fresh) /* 23 */
#define Bdd_Fortify \
	(bddStubsPtr->bdd_Fortify) /* 24 */
#define Bdd_Garbage \
	(bddStubsPtr->bdd_Garbage) /* 25 */
#define Bdd_SystemStat \
	(bddStubsPtr->bdd_SystemStat) /* 26 */
#define Bdd_FunctionStat \
	(bddStubsPtr->bdd_FunctionStat) /* 27 */
#define Bdd_FindFormula \
	(bddStubsPtr->bdd_FindFormula) /* 28 */
#define Bdd_AddFormula \
	(bddStubsPtr->bdd_AddFormula) /* 29 */
#define Bdd_SaveFormula \
	(bddStubsPtr->bdd_SaveFormula) /* 30 */
#define Bdd_ExtractBranch \
	(bddStubsPtr->bdd_ExtractBranch) /* 31 */
#define Bdd_Expand \
	(bddStubsPtr->bdd_Expand) /* 32 */
#define Bdd_Expr \
	(bddStubsPtr->bdd_Expr) /* 33 */
#define Bdd_WriteFunction \
	(bddStubsPtr->bdd_WriteFunction) /* 34 */
#define Bdd_WriteBDD \
	(bddStubsPtr->bdd_WriteBDD) /* 35 */
#define Bdd_WriteDot \
	(bddStubsPtr->bdd_WriteDot) /* 36 */
#define Bdd_WriteBDDView \
	(bddStubsPtr->bdd_WriteBDDView) /* 37 */
#define Bdd_WriteGraphML \
	(bddStubsPtr->bdd_WriteGraphML) /* 38 */
#define Bdd_ReadGraphML \
	(bddStubsPtr->bdd_ReadGraphML) /* 39 */
#define Bdd_RelOp \
	(bddStubsPtr->bdd_RelOp) /* 40 */
#define Bdd_RelOpSimple \
	(bddStubsPtr->bdd_RelOpSimple) /* 41 */
#define Bdd_RelOpComplex \
	(bddStubsPtr->bdd_RelOpComplex) /* 42 */
#define Bdd_NewState \
	(bddStubsPtr->bdd_NewState) /* 43 */
#define Bdd_NewState1 \
	(bddStubsPtr->bdd_NewState1) /* 44 */
#define Bdd_NewState2 \
	(bddStubsPtr->bdd_NewState2) /* 45 */
#define Bdd_NewEq \
	(bddStubsPtr->bdd_NewEq) /* 46 */

#endif /* defined(USE_BDD_STUBS) */

/* !END!: Do not edit above this line. */
