#  Authors     [Robert Meolic (meolic@uni-mb.si)]
#  Revision    [$Revision: 63 $]
#  Date        [$Date: 2012-07-08 01:34:40 +0200 (ned, 08 jul 2012) $]
#
#  Copyright   [This file is part of EST (Efficient Symbolic Tools).
#               Copyright (C) 2003, 2012
#               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
#
#               EST is free software; you can redistribute it and/or modify
#               it under the terms of the GNU General Public License as
#               published by the Free Software Foundation; either version 2
#               of the License, or (at your option) any later version.
#
#               EST is distributed in the hope that it will be useful,
#               but WITHOUT ANY WARRANTY; without even the implied warranty of
#               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#               GNU General Public License for more details.
#
#               You should have received a copy of the GNU General Public
#               License along with this program; if not, write to the Free
#               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#               Boston, MA 02110-1301 USA.]

global MENU
global MENUITEMS
global MENUBG
global MENUFG

set MENUPA $MENU.pa
menu $MENUPA -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENU insert [expr [$MENU index last]] cascade -menu $MENUPA -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -label "Process algebra"

$MENUPA add command  -command menu_pa_readProcess -label "pa_read_process"
$MENUPA add separator
$MENUPA add command  -command menu_pa_writeSort -label "pa_write_sort"
$MENUPA add command  -command menu_pa_writeProcessCCS -label "pa_write_process_ccs"
$MENUPA add separator
$MENUPA add command  -command menu_pa_encodeProcess -label "pa_encode_process"
$MENUPA add separator
$MENUPA add command  -command menu_pa_decodeProcess -label "pa_decode_process"
$MENUPA add command  -command menu_pa_decodeProcVisible -label "pa_decode_proc_visible"
$MENUPA add command  -command menu_pa_decodeComposition -label "pa_decode_composition"
$MENUPA add command  -command menu_pa_decodeCompVisible -label "pa_decode_comp_visible"
$MENUPA add separator
$MENUPA add command  -command menu_pa_decodeInitialState -label "pa_decode_initial_state"
$MENUPA add command  -command menu_pa_decodeComposedState -label "pa_decode_composed_state"
$MENUPA add separator
$MENUPA add command  -command menu_pa_copyProcess -label "pa_copy_process"
$MENUPA add command  -command menu_pa_process2composition -label "pa_process2composition"
$MENUPA add command  -command menu_pa_composition2process -label "pa_composition2process"
$MENUPA add separator
$MENUPA add cascade  -label "Processes..." -menu $MENUPA.processes
$MENUPA add cascade  -label "Compositions..." -menu $MENUPA.compositions
$MENUPA add separator
$MENUPA add command  -command pa_about -label "pa_about"

menu $MENUPA.processes -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENUPA.processes add command  -command menu_pa_stateNumber -label "pa_state_number"
$MENUPA.processes add command  -command menu_pa_transitionNumber -label "pa_transition_number"
$MENUPA.processes add command  -command menu_pa_transitionVisible -label "pa_transition_visible"

menu $MENUPA.compositions -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENUPA.compositions add command  -command menu_pa_compStateNumber -label "pa_comp_state_number"
$MENUPA.compositions add command  -command menu_pa_compTransitionNumber -label "pa_comp_transition_number"
$MENUPA.compositions add command  -command menu_pa_compTransitionVisible -label "pa_comp_transition_visible"

lappend MENUITEMS $MENUPA
lappend MENUITEMS $MENUPA.processes
lappend MENUITEMS $MENUPA.compositions
refresh

proc pa_about {  } {
    global BINDIR

    outline ""
    outline "\#\#\# "
    out "\# "
    pa_aboutPkg

    set OK ""
    if {[file isfile "/usr/lib/est2ed/pa.about"]} {
      set OK "OK"
      set f [open "/usr/lib/est2ed/pa.about" r]
    } else {
      if {[file isfile "$BINDIR/pa.about"]} {
        set OK "OK"
        set f [open "$BINDIR/pa.about" r]
      }
    }

    if { $OK == "OK"} {
      while {[gets $f line] >= 0} {
        out "\# "
        outline $line
      }
      outline "\#\#\# "
      close $f
    }
}

# ##########################################################
# FIELD1: Initial string/value
# FIELD2: List of arguments/values (where applicable)
#
# BROWSE types defined in mi.tcl
#
# file%s        filename
# boolean%s     false or true
# term%s        list of given terminals
# optional%s    optional parameter, can be left out
# required%s    required parameter, if empty then use ""
# nonempty%s    required parameter, must not be equal to ""
#
# BROWSE types defined in paDialog.tcl
#
# name%s        sort/process/composition name
# list%s        list of sorts/processes/compositions
#
# ##########################################################

global BROWSETYPE

if {[string compare [string range $tcl_patchLevel 0 2] "8.5"] == -1} {
  array set BROWSETYPE {name {{list {Select...}} {lindex $item 2} {nameBrowse}}}
  array set BROWSETYPE {list {{list {Select...}} {lindex $item 2} {listBrowse $IFIELD}}}
} else {
  dict set BROWSETYPE name {{list {Select...}} {lindex $item 2} {nameBrowse}}
  dict set BROWSETYPE list {{list {Select...}} {lindex $item 2} {listBrowse $IFIELD}}
}

proc nameBrowse {  } {
  global MENUFG
  global MENUBG
  global FIELD1
  global FIELD2
  global FIELD3
  global IFIELD
  global tcl_patchLevel

  if {[info exists FIELD3($IFIELD)]} {unset FIELD3($IFIELD)}
  set FIELD3($IFIELD) $FIELD1($IFIELD)

  set list ""

  if {$FIELD2($IFIELD) == "sort"} {set list [pa_list_sorts]}
  if {$FIELD2($IFIELD) == "proc"} {set list [pa_list_processes]}
  if {$FIELD2($IFIELD) == "comp"} {set list [pa_list_compositions]}

  if {$FIELD2($IFIELD) == "proccomp"} {
    set l [pa_list_processes]
    foreach item $l {
      set list "$list {process $item}"
    }
    set l [pa_list_compositions]
    foreach item $l {
      set list "$list {composition $item}"
    }
  }

  set menu [eval tk_optionMenu .commonDialog.dialogFrame.browse.$IFIELD.field FIELD3($IFIELD) {$FIELD1($IFIELD)} $list]
  .commonDialog.dialogFrame.browse.$IFIELD.field configure -font MENUFONT -highlightthickness 0 -borderwidth 1 -indicatoron true -relief solid -anchor w -padx 5
  $menu configure -borderwidth 1 -font MENUFONT -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -relief groove -tearoff 0

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] >= 0} {
    if {![string equal [tk windowingsystem] "aqua"]} {
      .commonDialog.dialogFrame.browse.$IFIELD.field configure -foreground $MENUFG -background $MENUBG -activeforeground $MENUFG -activebackground $MENUBG
      $menu configure -foreground $MENUFG -background $MENUBG
    }
  }

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] == -1} {
    trace variable FIELD3($IFIELD) w refreshCmd
  } else {
    trace add variable FIELD3($IFIELD) write refreshCmd
  }
}

proc listBrowse { i } {
  global MENUFG
  global MENUBG
  global FIELD1
  global FIELD2
  global FIELD3
  global IFIELD
  global PLIST
  global NPLIST
  global BPLIST
  global tcl_patchLevel

  if {[info exists FIELD3($IFIELD)]} {unset FIELD3($IFIELD)}
  set FIELD3($IFIELD) $FIELD1($IFIELD)

  set PLIST ""

  if {$FIELD2($IFIELD) == "sort"} {set PLIST [pa_list_sorts]}
  if {$FIELD2($IFIELD) == "proc"} {set PLIST [pa_list_processes]}
  if {$FIELD2($IFIELD) == "comp"} {set PLIST [pa_list_compositions]}

  menubutton .commonDialog.dialogFrame.browse.$IFIELD.field -textvariable FIELD3($IFIELD) \
    -menu .commonDialog.dialogFrame.browse.$IFIELD.field.menu \
    -font MENUFONT -foreground $MENUFG -background $MENUBG -activeforeground $MENUFG -activebackground $MENUBG \
    -highlightthickness 0 -borderwidth 1 -indicatoron false -relief solid -anchor w -padx 5 -width 30 -direction flush

  menu .commonDialog.dialogFrame.browse.$IFIELD.field.menu -foreground $MENUFG -background $MENUBG -borderwidth 1 -font MENUFONT \
    -activebackground #ffffc0 -activeforeground #000040 -activeborderwidth 1 -activeborderwidth 1 \
    -relief groove -tearoff 0

  set NPLIST 0
  foreach item $PLIST {
    incr NPLIST
    set BPLIST($NPLIST) 0
    .commonDialog.dialogFrame.browse.$IFIELD.field.menu add checkbutton -label $item -variable BPLIST($NPLIST) -indicatoron true \
       -foreground $MENUFG -background $MENUBG -activeforeground $MENUFG -activebackground $MENUBG \
       -command " \
          set l \"\" ;\
          for {set j 1} {\$j<=\$NPLIST} {incr j} { \
            if {\$BPLIST(\$j)} {set l \"\$l \[lindex \$PLIST \[expr \$j - 1\]\]\"} ;\
          } ;\
          set FIELD3($i) \"\[string range \$l 1 \[string length \$l\]\]\" ;\
          if {\$FIELD3($i) == \"\"} {set FIELD3($i) \$FIELD1($i)} \
       "
  }

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] == -1} {
    trace variable FIELD3($IFIELD) w refreshCmd
  } else {
    trace add variable FIELD3($IFIELD) write refreshCmd
  }
}

proc menu_pa_readProcess {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_read_process"
    set SYNOPSIS "Read file."
    set SYNTAX "fname%s"
    set EXAMPLE "pa_read_process data/system.dat"
    set EXPLANATION "Read file ./data/system.dat"
    set BROWSE [list \
        {file "Select file" {{{Internal format} {.dat}}}} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_copyProcess {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_copy_process"
    set SYNOPSIS "Copy process."
    set SYNTAX "pname%s pname%s sname%s alist%s alist%s"
    set EXAMPLE "pa_copy_process p1 p1copy NULL \"a b\" \"A B\""
    set EXPLANATION "Copy process and rename some actions"
    set BROWSE [list \
        {name "Select original process" proc} \
        {nonempty "New process" 30} \
        {optional "Sort of new process (optional, NULL = use original)" 30 ""} \
        {optional "List of original action names (optional)" 30 ""} \
        {optional "List of new action names (optional)" 30 ""} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_process2composition {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_process2composition"
    set SYNOPSIS "Create composition from a process"
    set SYNTAX "pname%s"
    set EXAMPLE "pa_process2composition p1"
    set EXPLANATION "Create a compositon p1 from the process p1"
    set BROWSE [list \
        {name "Select process" proc} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_composition2process {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_composition2process"
    set SYNOPSIS "Create a process from composition"
    set SYNTAX "pname%s"
    set EXAMPLE "pa_composition2process p1"
    set EXPLANATION "Create a process p1 from the composition p1"
    set BROWSE [list \
        {name "Select composition" comp} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_writeSort {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_write_sort"
    set SYNOPSIS "Write sort."
    set SYNTAX "sname%s"
    set EXAMPLE "pa_write_sort mysort"
    set EXPLANATION "Write out sort mysort"
    set BROWSE [list \
        {name "Select sort" sort} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_writeProcessCCS {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_write_process_ccs"
    set SYNOPSIS "Report process in CCS format."
    set SYNTAX "pname%s"
    set EXAMPLE "pa_write_process_ccs p1"
    set EXPLANATION "Report process p1"
    set BROWSE [list \
        {name "Select process" proc} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_encodeProcess {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_encode_process"
    set SYNOPSIS "Encode processes."
    set SYNTAX "plist%s"
    set EXAMPLE "pa_encode_process \"p1 p2\""
    set EXPLANATION "Encode processes p1 and p2"
    set BROWSE [list \
        {list "Select list of processes" proc} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_decodeProcess {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_decode_process"
    set SYNOPSIS "Decode process."
    set SYNTAX "pname%s"
    set EXAMPLE "pa_decode_process p1"
    set EXPLANATION "Decode process p1"
    set BROWSE [list \
        {name "Select process" proc} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_decodeProcVisible {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_decode_proc_visible"
    set SYNOPSIS "Decode visible part of process."
    set SYNTAX "pname%s"
    set EXAMPLE "pa_decode_proc_visible p1"
    set EXPLANATION "Decode visible part of process p1"
    set BROWSE [list \
        {name "Select process" proc} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_decodeComposition {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_decode_composition"
    set SYNOPSIS "Decode composition."
    set SYNTAX "pname%s"
    set EXAMPLE "pa_decode_composition c1"
    set EXPLANATION "Decode composition c1"
    set BROWSE [list \
        {name "Select composition" comp} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_decodeCompVisible {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_decode_comp_visible"
    set SYNOPSIS "Decode visible part of composition."
    set SYNTAX "pname%s"
    set EXAMPLE "pa_decode_comp_visible c1"
    set EXPLANATION "Decode visible part of composition c1"
    set BROWSE [list \
        {name "Select composition" comp} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_decodeInitialState {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_decode_initial_state"
    set SYNOPSIS "Decode initial state."
    set SYNTAX "type%d name%s"
    set EXAMPLE "pa_decode_initial_state 0 p"
    set EXPLANATION "Decode initial state in process p"
    set BROWSE [list \
        {name "Select process/composition" proccomp} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_decodeComposedState {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_decode_composed_state"
    set SYNOPSIS "Decode composed state in a process."
    set SYNTAX "pname%s sname%s"
    set EXAMPLE "pa_decode_composed_state p s0"
    set EXPLANATION "Decode composed state s0 in process p"
    set BROWSE [list \
        {name "Select process" proc} \
        {nonempty "State" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_pa_stateNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_state_number"
    set SYNOPSIS "Count states in a process."
    set SYNTAX "pname%s"
    set EXAMPLE "outline \[pa_state_number p1\]"
    set EXPLANATION "Count states in process p1"
    set BROWSE [list \
        {name "Select process" proc} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_pa_transitionNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_transition_number"
    set SYNOPSIS "Count transitions in a process."
    set SYNTAX "pname%s"
    set EXAMPLE "outline \[pa_transition_number p1\]"
    set EXPLANATION "Count transitions in process p1"
    set BROWSE [list \
        {name "Select process" proc} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_pa_transitionVisible {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_transition_visible"
    set SYNOPSIS "Count visible transitions in a process."
    set SYNTAX "pname%s"
    set EXAMPLE "outline \[pa_transition_visible p1\]"
    set EXPLANATION "Count visible transitions in process p1"
    set BROWSE [list \
        {name "Select process" proc} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_pa_compStateNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_comp_state_number"
    set SYNOPSIS "Count states in a composition."
    set SYNTAX "pname%s"
    set EXAMPLE "outline \[pa_comp_state_number c1\]"
    set EXPLANATION "Count states in composition c1"
    set BROWSE [list \
        {name "Select composition" comp} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_pa_compTransitionNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_comp_transition_number"
    set SYNOPSIS "Count transitions in a composition."
    set SYNTAX "pname%s"
    set EXAMPLE "outline \[pa_comp_transition_number c1\]"
    set EXPLANATION "Count transitions in composition c1"
    set BROWSE [list \
        {name "Select composition" comp} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_pa_compTransitionVisible {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "pa_comp_transition_visible"
    set SYNOPSIS "Count visible transitions in a composition."
    set SYNTAX "pname%s"
    set EXAMPLE "outline \[pa_comp_transition_visible c1\]"
    set EXPLANATION "Count visible transitions in composition c1"
    set BROWSE [list \
        {name "Select composition" comp} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}
