#  Authors     [Robert Meolic (meolic@uni-mb.si)]
#  Revision    [$Revision: 60 $]
#  Date        [$Date: 2012-07-04 14:30:43 +0200 (sre, 04 jul 2012) $]
#
#  Copyright   [This file is part of EST (Efficient Symbolic Tools).
#               Copyright (C) 2003, 2012
#               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
#
#               EST is free software; you can redistribute it and/or modify
#               it under the terms of the GNU General Public License as
#               published by the Free Software Foundation; either version 2
#               of the License, or (at your option) any later version.
#
#               EST is distributed in the hope that it will be useful,
#               but WITHOUT ANY WARRANTY; without even the implied warranty of
#               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#               GNU General Public License for more details.
#
#               You should have received a copy of the GNU General Public
#               License along with this program; if not, write to the Free
#               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#               Boston, MA 02110-1301 USA.]

global MENU
global MENUITEMS
global MENUBG
global MENUFG

set MENUBDD $MENU.bdd
menu $MENUBDD -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENU insert [expr [$MENU index last]] cascade -menu $MENUBDD -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -label "Bdd"

$MENUBDD add command  -command menu_bdd_terminals -label "bdd_terminals"
$MENUBDD add command  -command menu_bdd_expr -label "bdd_expr"
$MENUBDD add separator
$MENUBDD add command  -command menu_bdd_NOT -label "bdd_NOT"
$MENUBDD add command  -command menu_bdd_ITE -label "bdd_ITE"
$MENUBDD add command  -command menu_bdd_E -label "bdd_E"
$MENUBDD add command  -command menu_bdd_A -label "bdd_A"
$MENUBDD add command  -command menu_bdd_restrict -label "bdd_restrict"
$MENUBDD add command  -command menu_bdd_compose -label "bdd_compose"
$MENUBDD add separator
$MENUBDD add command  -command menu_bdd_outFunction -label "bdd_out function"
$MENUBDD add command  -command menu_bdd_outBDD -label "bdd_out_BDD"
$MENUBDD add command  -command menu_bdd_drawBDD -label "bdd_draw_BDD"
$MENUBDD add separator
$MENUBDD add cascade  -label "Functions..." -menu $MENUBDD.functions
$MENUBDD add cascade  -label "Node table..." -menu $MENUBDD.nodeTable
$MENUBDD add cascade  -label "Hash tables..." -menu $MENUBDD.hashTables
$MENUBDD add cascade  -label "Garbage..." -menu $MENUBDD.garbage
$MENUBDD add separator
$MENUBDD add command  -command bdd_about -label "bdd_about"

menu $MENUBDD.functions -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENUBDD.functions add command  -command menu_bdd_cmp -label "bdd_cmp"
$MENUBDD.functions add command  -command menu_bdd_find -label "bdd_find"
$MENUBDD.functions add command  -command menu_bdd_nodeNumber -label "bdd_node_number"
$MENUBDD.functions add command  -command menu_bdd_nodeMaxLevel -label "bdd_node_max_level"
$MENUBDD.functions add command  -command menu_bdd_nodeAvgLevel -label "bdd_node_avg_level"

menu $MENUBDD.nodeTable -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENUBDD.nodeTable add command  -command menu_bdd_tableSize -label "bdd_table_size"
$MENUBDD.nodeTable add command  -command menu_bdd_tableNumber -label "bdd_table_number"
$MENUBDD.nodeTable add command  -command menu_bdd_tableMax -label "bdd_table_max"
$MENUBDD.nodeTable add command  -command menu_bdd_tableFOA -label "bdd_table_foa"
$MENUBDD.nodeTable add command  -command menu_bdd_tableAdd -label "bdd_table_add"
$MENUBDD.nodeTable add command  -command menu_bdd_tableGenerated -label "bdd_table_generated"
$MENUBDD.nodeTable add command  -command menu_bdd_tableFortified -label "bdd_table_fortified"
$MENUBDD.nodeTable add command  -command menu_bdd_tableFresh -label "bdd_table_fresh"
$MENUBDD.nodeTable add command  -command menu_bdd_tableBad -label "bdd_table_bad"
$MENUBDD.nodeTable add command  -command menu_bdd_listUsed -label "bdd_list_used"
$MENUBDD.nodeTable add command  -command menu_bdd_listMaxLength -label "bdd_list_max_length"
$MENUBDD.nodeTable add command  -command menu_bdd_listAvgLength -label "bdd_list_avg_length"

menu $MENUBDD.hashTables -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENUBDD.hashTables add command  -command menu_bdd_cacheITEFind -label "bdd_cache_ITE_find"
$MENUBDD.hashTables add command  -command menu_bdd_cacheITEOverwrite -label "bdd_cache_ITE_overwrite"
$MENUBDD.hashTables add command  -command menu_bdd_cacheRelOpFind -label "bdd_cache_RelOp_find"
$MENUBDD.hashTables add command  -command menu_bdd_cacheRelOpOverwrite -label "bdd_cache_RelOp_overwrite"
$MENUBDD.hashTables add command  -command menu_bdd_cacheRelOpSimpleFind -label "bdd_cache_RelOpSimple_find"
$MENUBDD.hashTables add command  -command menu_bdd_cacheRelOpSimpleOverwrite -label "bdd_cache_RelOpSimple_overwrite"
$MENUBDD.hashTables add command  -command menu_bdd_cacheRelOpComplexFind -label "bdd_cache_RelOpComplex_find"
$MENUBDD.hashTables add command  -command menu_bdd_cacheRelOpComplexOverwrite -label "bdd_cache_RelOpComplex_overwrite"

menu $MENUBDD.garbage -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENUBDD.garbage add command  -command menu_bdd_blockNumber -label "bdd_block_number"
$MENUBDD.garbage add command  -command menu_bdd_garbageNumber -label "bdd_garbage_number"

lappend MENUITEMS $MENUBDD
lappend MENUITEMS $MENUBDD.functions
lappend MENUITEMS $MENUBDD.nodeTable
lappend MENUITEMS $MENUBDD.hashTables
lappend MENUITEMS $MENUBDD.garbage
refresh

proc bdd_about {  } {
    global BINDIR

    outline ""
    outline "\#\#\# "
    out "\# "
    bdd_aboutPkg

    set OK ""
    if {[file isfile "/usr/lib/est2ed/bdd.about"]} {
      set OK "OK"
      set f [open "/usr/lib/est2ed/bdd.about" r]
    } else {
      if {[file isfile "$BINDIR/bdd.about"]} {
        set OK "OK"
        set f [open "$BINDIR/bdd.about" r]
      }
    }

    if { $OK == "OK" } {
      while {[gets $f line] >= 0} {
        out "\# "
        outline $line
      }
      outline "\#\#\# "
      close $f
    }
}

proc bdd_stat { } {
  outline "Statistic about BDD package:"
  out "  bdd_table_number: "
  outline [bdd_table_number]
  out "  bdd_table_max: "
  outline [bdd_table_max]
  out "  bdd_table_generated: "
  outline [bdd_table_generated]
  out "  bdd_table_foa: "
  outline [bdd_table_foa]
  out "  bdd_table_add: "
  outline [bdd_table_add]
  out "  bdd_table_compare: "
  outline [bdd_table_compare]
  out "  bdd_block_number: "
  outline [bdd_block_number]
  out "  bdd_garbage_number: "
  outline [bdd_garbage_number]
}

# ##########################################################
# FIELD1: Initial string/value
# FIELD2: List of arguments/values (where applicable)
#
# BROWSE types defined in mi.tcl
#
# file%s        filename
# boolean%s     false or true
# term%s        list of given terminals
# optional%s    optional parameter, can be left out
# required%s    required parameter, if empty then use ""
# nonempty%s    required parameter, must not be equal to ""
#
# ##########################################################

proc menu_bdd_terminals {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_terminals"
    set SYNOPSIS "Create terminal nodes"
    set SYNTAX "vlist%s"
    set EXAMPLE "bdd_terminals \"A B C\""
    set EXPLANATION "Create terminals with variables A, B, and C"
    set BROWSE [list \
        {nonempty "List of variable names" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_expr {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_expr"
    set SYNOPSIS "Calculate Boolean expression."
    set SYNTAX "\"expr%s\" fname%s"
    set EXAMPLE "bdd_expr \"(AND A B)\" F1"
    set EXPLANATION "Calculate and store F1 = (AND A B)"
    set BROWSE [list \
        {nonempty "Expression (prefix notation)" 30} \
        {nonempty "Result" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_NOT {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_NOT"
    set SYNOPSIS "Calculate negation."
    set SYNTAX "fname%s fname%s"
    set EXAMPLE "bdd_NOT F1 F2"
    set EXPLANATION "Calculate and store F2 = NOT F1"
    set BROWSE [list \
        {nonempty "Function" 30} \
        {nonempty "Result" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_ITE {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_ITE"
    set SYNOPSIS "Calculate ITE operation."
    set SYNTAX "fname%s fname%s fname%s fname%s"
    set EXAMPLE "bdd_ITE F G H R"
    set EXPLANATION "Calculate and store R = ITE(F,G,H)"
    set BROWSE [list \
        {nonempty "Function F" 30} \
        {nonempty "Function G" 30} \
        {nonempty "Function H" 30} \
        {nonempty "Result" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_E {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_E"
    set SYNOPSIS "Calculate existential quantification."
    set SYNTAX "vlist%s fname%s fname%s"
    set EXAMPLE "bdd_E \"P R\" F1 F2"
    set EXPLANATION "Calculate and store F2 = ExP ExR (F1)"
    set BROWSE [list \
        {nonempty "List of variable names" 30} \
        {nonempty "Function" 30} \
        {nonempty "Result" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_A {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_A"
    set SYNOPSIS "Calculate universal quantification."
    set SYNTAX "vlist%s fname%s fname%s"
    set EXAMPLE "bdd_A \"P R\" F1 F2"
    set EXPLANATION "Calculate and store F2 = AxP AxR (F1)"
    set BROWSE [list \
        {nonempty "List of variable names" 30} \
        {nonempty "Function" 30} \
        {nonempty "Result" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_restrict {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_restrict"
    set SYNOPSIS "Calculate restriction."
    set SYNTAX "vname%s term%d fname%s fname%s"
    set EXAMPLE "bdd_restrict F1 A 1 G"
    set EXPLANATION "Calculate and store G = F1_(A=1)"
    set BROWSE [list \
        {nonempty "Original function" 30} \
        {nonempty "Variable name" 30} \
        {term "Variable value" "0 1"} \
        {nonempty "Result" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_compose {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_compose"
    set SYNOPSIS "Calculate composition."
    set SYNTAX "fname%s vname%s fname%s fname%s"
    set EXAMPLE "bdd_compose F1 A F2 F3"
    set EXPLANATION "Calculate and store F3 = F1_(A=F2)"
    set BROWSE [list \
        {nonempty "Original function" 30} \
        {nonempty "Variable name" 30} \
        {nonempty "Function" 30} \
        {nonempty "Result" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_outFunction {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_out_function"
    set SYNOPSIS "Write Boolean function."
    set SYNTAX "fname%s"
    set EXAMPLE "bdd_out_function F1"
    set EXPLANATION "Write AND-OR form of Boolean function F1"
    set BROWSE [list \
        {nonempty "Function" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_outBDD {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_out_BDD"
    set SYNOPSIS "Write BDD."
    set SYNTAX "fname%s"
    set EXAMPLE "bdd_out_BDD F1"
    set EXPLANATION "Write BDD of Boolean function F1"
    set BROWSE [list \
        {nonempty "Function" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_drawBDD {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_draw_BDD"
    set SYNOPSIS "Draw BDD."
    set SYNTAX "fname%s"
    set EXAMPLE "bdd_draw_BDD F1"
    set EXPLANATION "Draw BDD of Boolean function F1"
    set BROWSE [list \
        {nonempty "Function" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}

proc menu_bdd_cmp {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cmp"
    set SYNOPSIS "Compare two BDDs."
    set SYNTAX "fname%s fname%s"
    set EXAMPLE "outline \[bdd_cmp F1 F2\]"
    set EXPLANATION "Return \"true\" if equal, otherwise \"false\""
    set BROWSE [list \
        {nonempty "Function 1" 30} \
        {nonempty "Function 2" 30} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_find {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_find"
    set SYNOPSIS "Check if there exists BDD with given name."
    set SYNTAX "fname%s"
    set EXAMPLE "outline \[bdd_find F1\]"
    set EXPLANATION "Return \"true\" or \"false\""
    set BROWSE [list \
        {nonempty "Function" 30} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_nodeNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_node_number"
    set SYNOPSIS "Count the number of nodes."
    set SYNTAX "fname%s"
    set EXAMPLE "outline \[bdd_node_number F1\]"
    set EXPLANATION "Return number of nodes of BDD representing function F1"
    set BROWSE [list \
        {nonempty "Function" 30} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_nodeMaxLevel {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_node_max_level"
    set SYNOPSIS "Find the maximal depth of BDD."
    set SYNTAX "fname%s"
    set EXAMPLE "outline \[bdd_node_max_level F1\]"
    set EXPLANATION "Return maximal depth of BDD representing function F1"
    set BROWSE [list \
        {nonempty "Function" 30} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_nodeAvgLevel {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_node_avg_level"
    set SYNOPSIS "Find the average depth of BDD."
    set SYNTAX "fname%s"
    set EXAMPLE "outline \[bdd_node_avg_level F1\]"
    set EXPLANATION "Return average depth of BDD representing function F1"
    set BROWSE [list \
        {nonempty "Function" 30} \
    ]

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableSize {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_size"
    set SYNOPSIS "Size of node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_size\]"
    set EXPLANATION "Return size of node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_number"
    set SYNOPSIS "Count all nodes in node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_number\]"
    set EXPLANATION "Return number of all nodes in node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableMax {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_max"
    set SYNOPSIS "Maximal number of nodes in node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_max\]"
    set EXPLANATION "Return maximal number of nodes in node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableFOA {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_foa"
    set SYNOPSIS "Number of FOA calls  in node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_foa\]"
    set EXPLANATION "Return number of FOA calls in node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableAdd {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_add"
    set SYNOPSIS "Number of nodes adding into node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_add\]"
    set EXPLANATION "Return number of nodes adding into node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableGenerated {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_generated"
    set SYNOPSIS "Number of generated nodes"
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_generated\]"
    set EXPLANATION "Return number of generated nodes."
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableFortified {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_fortified"
    set SYNOPSIS "Count fortified nodes in node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_fortified\]"
    set EXPLANATION "Return number of fortified nodes in node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableFresh {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_fresh"
    set SYNOPSIS "Count fresh nodes in node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_fresh\]"
    set EXPLANATION "Return number of fresh nodes in node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_tableBad {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_table_bad"
    set SYNOPSIS "Count bad nodes in node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_table_bad\]"
    set EXPLANATION "Return number of bad nodes in node table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_listUsed {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_list_used"
    set SYNOPSIS "Count nonempty lists in node table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_list_used\]"
    set EXPLANATION "Return number of nonempty lists"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_listMaxLength {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_list_max_length"
    set SYNOPSIS " Count nodes in the longest list."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_list_max_length\]"
    set EXPLANATION "Return number of nodes in the longest list"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_listAvgLength {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_list_avg_length"
    set SYNOPSIS "Calculate average length of lists."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_list_avg_length\]"
    set EXPLANATION "Return average number of nodes in lists"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheITEFind {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_ITE_find"
    set SYNOPSIS "Number of succesful lookups in ITE cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_ITE_find\]"
    set EXPLANATION "Return number of succesful lookups in ITE cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheITEOverwrite {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_ITE_overwrite"
    set SYNOPSIS "Number of overwritten items in ITE cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_ITE_overwrite\]"
    set EXPLANATION "Return number of overwritten items in ITE cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheRelOpFind {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_RelOp_find"
    set SYNOPSIS "Number of succesful lookups in RelOp cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_RelOp_find\]"
    set EXPLANATION "Return number of succesful lookups in RelOp cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheRelOpOverwrite {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_RelOp_overwrite"
    set SYNOPSIS "Number of overwritten items in RelOp cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_RelOp_overwrite\]"
    set EXPLANATION "Return number of overwritten items in RelOp cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheRelOpSimpleFind {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_RelOpSimple_find"
    set SYNOPSIS "Number of succesful lookups in RelOpSimple cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_RelOpSimple_find\]"
    set EXPLANATION "Return number of succesful lookups in RelOpSimple cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheRelOpSimpleOverwrite {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_RelOpSimple_overwrite"
    set SYNOPSIS "Number of overwritten items in RelOpSimple cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_RelOpSimple_overwrite\]"
    set EXPLANATION "Return number of overwritten items in RelOpSimple cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheRelOpComplexFind {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_RelOpComplex_find"
    set SYNOPSIS "Number of succesful lookups in RelOpComplex cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_RelOpComplex_find\]"
    set EXPLANATION "Return number of succesful lookups in RelOpComplex cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_cacheRelOpComplexOverwrite {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_cache_RelOpComplex_overwrite"
    set SYNOPSIS "Number of overwritten items in RelOpComplex cache table."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_cache_RelOpComplex_overwrite\]"
    set EXPLANATION "Return number of overwritten items in RelOpComplex cache table"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_blockNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_block_number"
    set SYNOPSIS "Number of allocated memory blocks."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_block_number\]"
    set EXPLANATION "Return number of allocated memory blocks"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}

proc menu_bdd_garbageNumber {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "bdd_garbage_number"
    set SYNOPSIS "Number of garbage collections."
    set SYNTAX ""
    set EXAMPLE "outline \[bdd_garbage_number\]"
    set EXPLANATION "Return number of garbage collections"
    set BROWSE ""

    set CMD "outline \[$NAME"
    set CMDEND "\]"

    commonDialog
}
