#!/bin/sh

# script to install openoffice, synaptic and gnome-cups-manager 
# on a freshly installed Dzongkha Debian Linux system

# copy sources.list file
cp /etc/apt/sources.list /etc/apt/sources.list.back
cp sources.list /etc/apt/

# copy files in lists
cp lists/* /var/lib/apt/lists/

# copy the deb files
cp debs/* /var/cache/apt/archives/

# install openoffice
apt-get --yes --force-yes install openoffice.org openoffice.org-l10n-dz openoffice.org-help-dz

# install synaptic
apt-get --yes --force-yes install synaptic

# install gnome-cups-manager
apt-get --yes --force-yes install gnome-cups-manager

#install others
apt-get --yes --force-yes install gnome-power-manager inkscape xmms gnomebaker brasero

# copy the .desktop files
cp applications/* /usr/share/applications/
chmod 644 /usr/share/applications/*.desktop

# copy the .desktop file for gnome-cups-manager
cp control-center/* /usr/share/control-center-2.0/capplets/
chmod 644 /usr/share/control-center-2.0/capplets/*.desktop

# cleanup
rm /etc/apt/sources.list
mv /etc/apt/sources.list.back /etc/apt/sources.list
rm /var/lib/apt/lists/_home_bhutan_packages_debian-local_dists_etch_local_binary-i386_Packages

# install Wangdi font
cp fonts/* /usr/share/fonts/truetype/
chmod 644 /usr/share/fonts/truetype/Wangdi.ttf
fc-cache -f -v

# configure usage of Jomolhari as the font to render UI
cp fonts-config/* /etc/fonts/conf.avail/
chmod 644 /etc/fonts/conf.avail/65-nonlatin.conf

# Update locale
cp locale/dz_BT /usr/share/i18n/locales/
chmod 644 /usr/share/i18n/locales/dz_BT
locale-gen

# success??
echo "========================================================================"
echo "Installation Done. Hit Enter to close the terminal and Reboot the system"
echo "========================================================================"
read toto

reboot
