/*
/#SYSTEM file en/decoder
*/

#include <stdio.h>
#include <limits.h>
#include <errno.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/param.h>

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned long long uint64_t;

typedef uint8_t BYTE; /* 1-byte integer */
typedef uint16_t WORD; /* 2-byte integer */
typedef uint32_t DWORD; /* 4-byte integer */
typedef uint64_t QWORD; /* 8-byte integer */

static WORD fread_WORD( FILE* f );
static DWORD fread_DWORD( FILE* f );
static QWORD fread_QWORD( FILE* f );

BYTE buf[1000];

int main( int argc, char* argv[] ){
	uint i;
	for( i = 1; i <= argc; i++ ){
		FILE* f;
		f = fopen( argv[i], "rb" );
		if( f ){
			DWORD version;
			version = fread_DWORD( f );
			printf( "Version = %u\n", version );
			while( !feof(f) ){
				WORD code, len;
				code = fread_WORD( f );
				len = fread_WORD( f );
				if(feof(f)) break;
				printf( "Code %u entry (%u bytes long)\n", code, len );
				switch(code){
					case 0:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Contents file=%s\n", buf );
					break;
					case 1:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Index file=%s\n", buf );
					break;
					case 2:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Default topic=%s\n", buf );
					break;
					case 3:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Title=%s\n", buf );
					break;
					case 4:
						printf( "Language=0x%x\n", fread_DWORD( f ) );
						fseek( f, 16, SEEK_CUR );
						{
							QWORD ft = fread_QWORD( f );
							printf( "Creation Time (system flag): %llu 100-nanosecond intervals since January 1, 1601\n", ft );
						}
						fseek( f, 8, SEEK_CUR );
					break;
					case 5:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Default Window=%s\n", buf );
					break;
					case 6:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Compiled file=%s\n", buf );
					break;
					case 7:
						printf( "0x%x\n", fread_DWORD( f ) );
					break;
					case 8:
						fseek( f, len, SEEK_CUR );
					break;
					case 9:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Compiled with %s\n", buf );
					break;
					case 10:
						printf( "Creation Time (time tag): %u seconds since midnight, January 1, 1970 UTC\n", fread_DWORD( f ) );
					break;
					case 11:
						printf( "0x%x\n", fread_DWORD( f ) );
					break;
					case 12:
						printf( "%u information type(s)\n", fread_DWORD( f ) );
					break;
					case 13:
						fseek( f, len, SEEK_CUR );
					break;
					case 14:
						{
							BYTE* s = buf;
							DWORD n = fread_DWORD( f );
							printf( "%u custom tab(s)\n", n );
							fread( buf, len-4, 1, f ); buf[len-4] = 0;
							while(n){
								printf( "Custom tab=\"%s\", ", s );
								s += strlen(s) + 1;
								printf( "%s\n", s );
								n --;
							}
						}
					break;
					case 15:
						printf( "Information type checksum is 0x%x\n", fread_DWORD( f ) );
					break;
					case 16:
						fread( buf, len, 1, f ); buf[len] = 0;
						printf( "Default Font=%s\n", buf );
					break;
					default:
						printf( "WARNING: Code %u is new!!\n", code );
						fseek( f, len, SEEK_CUR );
				}
				
				printf( "\n" );
	
			}
		}
	}
	return 0;
}

static WORD fread_WORD( FILE* f ){
	BYTE in[2];
	fread(in,2,1,f);
	return in[0] | (in[1] << 8);
}

static DWORD fread_DWORD( FILE* f ){
	BYTE in[4];
	fread(in,4,1,f);
	return in[0] | (in[1] << 8) | (in[2] << 16) | (in[3] << 24);
}

static QWORD fread_QWORD( FILE* f ){
	BYTE in[8];
	fread(in,8,1,f);
	return in[0] | (in[1] << 8) | (in[2] << 16) | (in[3] << 24)
		| ((QWORD)in[4] << 32) | ((QWORD)in[5] << 40) | ((QWORD)in[6] << 48) | ((QWORD)in[7] << 56);
}

/*
DWORD sv = 3; //* /#SYSTEM file version 

typedef _SYSTEM_entry_t{
	WORD code;
	WORD length;
	BYTE* data;
} SYSTEM_entry_t;

SYSTEM_entry_t SYSTEM_Default_Font = { 16, HHP_OPTIONS_Default_Font_len, HHP_OPTIONS_Default_Font_len };

int fwrite_SYSTEM(FILE* f){
	fwrite_DWORD( f, sv );

	fwrite_WORD( f, item.code );
	fwrite_WORD( f, item.length );
	switch( item.code ){
		case 0: break;
		case 0: break;
		default:
			printf( "BUG: Invalid /#SYSTEM file code (%u)", item.code );
			exit( -1 );
	}
}

*/