#########################################################################
#Look for Xplane.exe
#########################################################################
FIND_PROGRAM(XPLANE_EXECUTABLE
	NAMES X-Plane.exe
	PATHS "C:\\Program Files\\X-Plane"
	PATH_SUFFIXES 
	DOC "XPlane Software")
	
IF (XPLANE_EXECUTABLE)
  IF (NOT XPLANE_FIND_QUIETLY) 
      MESSAGE_QUIETLY(XPLANE_FIND_QUIETLY STATUS "Looking for XPlane... - XPlane is ${XPLANE_EXECUTABLE}")
  ENDIF(NOT XPLANE_FIND_QUIETLY) 
  SET(XPLANE_EXECUTABLE_FOUND "YES")
  GET_FILENAME_COMPONENT(XPLANE_EXECUTABLE_DIRECTORY ${XPLANE_EXECUTABLE} PATH)
  SET(XPLANE_PLUGINS_DIRECTORY ${XPLANE_EXECUTABLE_DIRECTORY}\\Resources\\plugins)
ELSE (XPLANE_EXECUTABLE) 
  SET(XPLANE_EXECUTABLE_FOUND "NO")
  IF (NOT XPLANE_FIND_QUIETLY) 
      MESSAGE_QUIETLY(XPLANE_FIND_QUIETLY STATUS "Looking for XPlane... - XPlane NOT FOUND")
  ENDIF(NOT XPLANE_FIND_QUIETLY)
ENDIF (XPLANE_EXECUTABLE) 

#########################################################################
# Go to subdirs XPLANE_LIBRARY
#########################################################################
FIND_LIBRARY(XPLANE_XPLM_LIBRARY
			NAMES 	XPLM
			PATHS "C:\\Program Files\\X-Plane\\X-Plane PlugIn\\XPSDK200b1\\Libraries"
			PATH_SUFFIXES lib
			DOC "The XPLANE Library")

FIND_LIBRARY(XPLANE_XPWidgets_LIBRARY
			NAMES 	XPWidgets
			PATHS "C:\\Program Files\\X-Plane\\X-Plane PlugIn\\XPSDK200b1\\Libraries"
			PATH_SUFFIXES lib
			DOC "The XPLANE Library")

IF (XPLANE_XPLM_LIBRARY) 
  IF (NOT XPLANE_FIND_QUIETLY)
     MESSAGE_QUIETLY(XPLANE_FIND_QUIETLY STATUS "Looking for XPlane library... - found ${XPLANE_LIBRARY}")
  ENDIF(NOT XPLANE_FIND_QUIETLY)
  SET(XPLANE_FOUND "YES")
  LIST(APPEND XPLANE_LIBRARIES ${XPLANE_XPLM_LIBRARY} ${XPLANE_XPWidgets_LIBRARY})
ELSE (XPLANE_XPLM_LIBRARY)
  SET(XPLANE_FOUND "NO")
  IF (NOT XPLANE_FIND_QUIETLY)
      MESSAGE_QUIETLY(XPLANE_FIND_QUIETLY STATUS "Looking for XPlane library... - NOT FOUND")
  ENDIF(NOT XPLANE_FIND_QUIETLY)
ENDIF (XPLANE_XPLM_LIBRARY)

IF (XPLANE_XPLM_LIBRARY) 
  GET_FILENAME_COMPONENT(XPLANE_LIBRARY_DIRS ${XPLANE_XPLM_LIBRARY} PATH)
ENDIF (XPLANE_XPLM_LIBRARY)

#########################################################################
# Go to subdirs XPLANE_XPLM_INCLUDE_DIRECTORY
#########################################################################
FIND_FILE(XPLANE_XPLM_INCLUDE_DIRECTORY
	NAMES XPLMPlugin.h
	PATHS "C:/Program Files/X-Plane PlugIn/XPSDK200b1/CHeaders/XPLM"		
	DOC "The XPLANE_XPLM Include Directory")

IF(IS_DIRECTORY XPLANE_XPLM_INCLUDE_DIRECTORY)
   LIST(APPEND XPLANE_XPLM_INCLUDE_DIRS ${XPLANE_XPLM_INCLUDE_DIRECTORY})
ELSE(IS_DIRECTORY XPLANE_XPLM_INCLUDE_DIRECTORY)
   IF (XPLANE_XPLM_INCLUDE_DIRECTORY) 
		GET_FILENAME_COMPONENT(XPLANE_XPLM_INCLUDE_DIRS ${XPLANE_XPLM_INCLUDE_DIRECTORY} PATH) 		
   ENDIF (XPLANE_XPLM_INCLUDE_DIRECTORY)
  INCLUDE_DIRECTORIES(${XPLANE_XPLM_INCLUDE_DIRS})
ENDIF(IS_DIRECTORY XPLANE_XPLM_INCLUDE_DIRECTORY)
	
#########################################################################
# Go to subdirs XPLANE_XPW_INCLUDE_DIRECTORY
#########################################################################
FIND_FILE(XPLANE_XPW_INCLUDE_DIRECTORY
	NAMES XPWidgets.h
	PATHS "C:/Program Files/X-Plane/X-Plane PlugIn/XPSDK200b1/CHeaders/Widgets"	
	DOC "The XPLANE_XPW Include Directory")

IF(IS_DIRECTORY XPLANE_XPW_INCLUDE_DIRECTORY)
   LIST(APPEND XPLANE_XPW_INCLUDE_DIRS ${XPLANE_XPW_INCLUDE_DIRECTORY})
ELSE(IS_DIRECTORY XPLANE_XPW_INCLUDE_DIRECTORY)
  IF (XPLANE_XPW_INCLUDE_DIRECTORY) 
    GET_FILENAME_COMPONENT(XPLANE_XPW_INCLUDE_DIRS ${XPLANE_XPW_INCLUDE} PATH)      
  ENDIF (XPLANE_XPW_INCLUDE_DIRECTORY)
INCLUDE_DIRECTORIES(${XPLANE_XPW_INCLUDE_DIRS})
ENDIF(IS_DIRECTORY XPLANE_XPW_INCLUDE_DIRECTORY)