/** @file Billard_cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef BILLARD_CMDLINE_H
#define BILLARD_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "billard"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "billard"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int auto_arg;	/**< @brief auto start.  */
  char * auto_orig;	/**< @brief auto start original value given at command line.  */
  const char *auto_help; /**< @brief auto start help description.  */
  int coordinated_flag;	/**< @brief coordinated time (default=on).  */
  const char *coordinated_help; /**< @brief coordinated time help description.  */
  int delay_arg;	/**< @brief delay before 1st step.  */
  char * delay_orig;	/**< @brief delay before 1st step original value given at command line.  */
  const char *delay_help; /**< @brief delay before 1st step help description.  */
  int notimestamp_flag;	/**< @brief no timestamp (default=off).  */
  const char *notimestamp_help; /**< @brief no timestamp help description.  */
  char * federation_arg;	/**< @brief federation name.  */
  char * federation_orig;	/**< @brief federation name original value given at command line.  */
  const char *federation_help; /**< @brief federation name help description.  */
  char * logfile_arg;	/**< @brief file to log events.  */
  char * logfile_orig;	/**< @brief file to log events original value given at command line.  */
  const char *logfile_help; /**< @brief file to log events help description.  */
  char * name_arg;	/**< @brief federate name.  */
  char * name_orig;	/**< @brief federate name original value given at command line.  */
  const char *name_help; /**< @brief federate name help description.  */
  char * demo_arg;	/**< @brief select demo (static-ddm, dynamic-ddm).  */
  char * demo_orig;	/**< @brief select demo (static-ddm, dynamic-ddm) original value given at command line.  */
  const char *demo_help; /**< @brief select demo (static-ddm, dynamic-ddm) help description.  */
  int timer_arg;	/**< @brief timer.  */
  char * timer_orig;	/**< @brief timer original value given at command line.  */
  const char *timer_help; /**< @brief timer help description.  */
  int verbose_flag;	/**< @brief verbose mode (default=off).  */
  const char *verbose_help; /**< @brief verbose mode help description.  */
  int xoffset_arg;	/**< @brief X offset (X11).  */
  char * xoffset_orig;	/**< @brief X offset (X11) original value given at command line.  */
  const char *xoffset_help; /**< @brief X offset (X11) help description.  */
  int yoffset_arg;	/**< @brief Y offset (X11).  */
  char * yoffset_orig;	/**< @brief Y offset (X11) original value given at command line.  */
  const char *yoffset_help; /**< @brief Y offset (X11) help description.  */
  int initx_arg;	/**< @brief ball initial X value.  */
  char * initx_orig;	/**< @brief ball initial X value original value given at command line.  */
  const char *initx_help; /**< @brief ball initial X value help description.  */
  int inity_arg;	/**< @brief ball initial Y value.  */
  char * inity_orig;	/**< @brief ball initial Y value original value given at command line.  */
  const char *inity_help; /**< @brief ball initial Y value help description.  */
  char * filename_arg;	/**< @brief FED filename.  */
  char * filename_orig;	/**< @brief FED filename original value given at command line.  */
  const char *filename_help; /**< @brief FED filename help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int auto_given ;	/**< @brief Whether auto was given.  */
  unsigned int coordinated_given ;	/**< @brief Whether coordinated was given.  */
  unsigned int delay_given ;	/**< @brief Whether delay was given.  */
  unsigned int notimestamp_given ;	/**< @brief Whether notimestamp was given.  */
  unsigned int federation_given ;	/**< @brief Whether federation was given.  */
  unsigned int logfile_given ;	/**< @brief Whether logfile was given.  */
  unsigned int name_given ;	/**< @brief Whether name was given.  */
  unsigned int demo_given ;	/**< @brief Whether demo was given.  */
  unsigned int timer_given ;	/**< @brief Whether timer was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int xoffset_given ;	/**< @brief Whether xoffset was given.  */
  unsigned int yoffset_given ;	/**< @brief Whether yoffset was given.  */
  unsigned int initx_given ;	/**< @brief Whether initx was given.  */
  unsigned int inity_given ;	/**< @brief Whether inity was given.  */
  unsigned int filename_given ;	/**< @brief Whether filename was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* BILLARD_CMDLINE_H */
