#ifndef MYOFFLINETIMER_H
#define MYOFFLINETIMER_H

#include <QtCore>
#include <QToolBox>
#include <QStatusBar>
#include <QDoubleSpinBox>
#include <QComboBox>

#include <opencv2/opencv.hpp>

class MyOfflineTimer : public QObject
{
    Q_OBJECT
public:
    MyOfflineTimer();
    QTimer *timer;
    cv::VideoCapture *CAP;
    int ID;
    int Nbloks;
    int Count;
    QToolBox *Toolbox;
    QString Directory;
    QStatusBar *StatusBar;
    QFile file_ms;

    QDoubleSpinBox *ROI_LIN0;
    QDoubleSpinBox *ROI_COL0;
    QDoubleSpinBox *ROI_HEIGHT;
    QDoubleSpinBox *ROI_WIDTH;

    QSpinBox *SPINFPS;
    QComboBox *COMBOBOXCAM;

    double old_time;
    double first_time;

    double current_time;


    void start_online(  QDoubleSpinBox *lin0,
                        QDoubleSpinBox *col0,
                        QDoubleSpinBox *height,
                        QDoubleSpinBox *width,
                        QStatusBar *statusBar,
                        QSpinBox *spinfps,
                        QComboBox *comboBoxCam,
                        QToolBox *toolbox,
                        QString directory,     // Diretorio onde se salvam as imagens
                        cv::VideoCapture *cap, // Controlador de video
                        int camid,             // O ID da camera que vou abrir
                        int ms,                // O tempo de amostragem =1/Fs
                        int nbloks);
                        
    void stop_online(void);

public slots:
    void MySlot();
};

#endif // MYOFFLINETIMER_H
