/*
 * BMovieReviewer Copyright (C) 2009 Michael J. Beer
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import data.Bogen;
import data.XML;


public class Main {

	public static String copyleft = 
		"BMovieReviewer Copyright (C) 2009, 2010  Michael J. Beer, Stefan Knipl\n" +
		"This program comes with ABSOLUTELY NO WARRANTY; \n" +
		"This is free software, and you are welcome to redistribute it\n" +
		"under certain conditions; \n" +
		"See file 'COPYING' for more details.";
	
	public static void main(String[] argv) {
		
		Bogen bogen;
		BMovieApplet myApp;
		
		System.out.println(copyleft);
		
		if(argv.length == 0) {
			bogen = new Bogen();
			myApp = new BMovieApplet(bogen);
			// Noch nicht besonders geistreich, da nach wie vor Alles im Konstruktor passiert...
			javax.swing.SwingUtilities.invokeLater(myApp);
		} else {
			FileOutputStream fileOut = null;
			PrintStream out = null;
			String fileName;
			File file;
			FileInputStream fileIn = null;
			InputStreamReader in = null;
			
			if(argv[0].length() == 0) {
				return;
			}
			
			fileName = argv[0].substring(0, argv[0].lastIndexOf('.'));
			System.out.println("Name " + fileName);
			file = new File(fileName + ".xml");
			
			try{
		    	fileIn = new FileInputStream(file);
		    }catch(FileNotFoundException ex){
		    	System.err.println("Laden: " + file.getName() + " nicht gefunden");
		    	return; // throw new RuntimeException();
		    }
		    in = new InputStreamReader(fileIn);
		    bogen = XML.readXML(in, null);
			
			try{
				fileOut = new FileOutputStream(fileName + ".tex", false);
				out = new PrintStream(fileOut);
			}catch(FileNotFoundException ex) {
				System.err.println("Konnte Datei nicht oeffnen");
			}
			if(out != null) {	
				bogen.printTex(out);
			}
			
		}
	}
}
