<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
?>
<h1><?php echo Locale_Translate::_("FTP server") ?></h1>
<p>
  <?php echo Locale_Translate::_("This page describes installation of two dfferent FTP servers.") ?>
  <?php echo Locale_Translate::_("Pick the one that suits you.") ?>
</p>

<h2>vsftpd</h2>
<p><?php echo Locale_Translate::_("Install the vsftpd FTP server:") ?></p>
<p><code>$ sudo apt-get install vsftpd</code></p>
<p><?php echo Locale_Translate::_("Create the ftp user:") ?></p>
<p><code>$ sudo useradd ftp</code></p>
<p><?php echo Locale_Translate::_("Edit file /etc/vsftpd.conf and make the settings below:") ?></p>
<p><code>anonymous_enable=YES</code></p>
<p><code>local_enable=NO</code></p>
<p><code>no_anon_password=YES</code></p>
<p><code>anon_root=/var/www/bibledit-web/exports</code></p>
<p><?php echo Locale_Translate::_("Restart the FTP server:") ?></p>
<p><code>$ sudo service vsftpd restart</code></p>

<h2>pure-ftpd</h2>
<p><?php echo Locale_Translate::_("Install the pure-ftpd FTP server:") ?></p>
<p><code>$ sudo apt-get install pure-ftpd</code></p>
<p><?php echo Locale_Translate::_("It will log to:") ?> /var/log/pure-ftpd/transfer.log</p>
<p><?php echo Locale_Translate::_("Enable anonymous access and secure the server:") ?></p>
<p><code>$ sudo su</code></p>
<p><code>$ cd /etc/pure-ftpd/conf</code></p>
<p><code>$ echo no > NoAnonymous</code></p>
<p><code>$ echo no > PAMAuthentication</code></p>
<p><code>$ echo no > PureDB</code></p>
<p><code>$ echo 0 > TrustedGID</code></p>
<p><code>$ exit</code></p>
<p>
  <?php echo Locale_Translate::_("Users with a local account normally can login through FTP.") ?>
  <?php echo Locale_Translate::_("Disable that for security reasons.") ?>
  <?php echo Locale_Translate::_("Edit file /etc/ftpusers, and add the local accounts to that file.") ?>
</p>
<p><code>$ sudo nano /etc/ftpusers</code></p>
<p><?php echo Locale_Translate::_("The anonymous users will read from:") ?> /srv/ftp</p>
<p><?php echo Locale_Translate::_("Update the root folder for anonymous access:") ?></p>
<p><code>$ sudo usermod -d /var/www/bibledit-web/exports/ ftp</code></p>
<p><?php echo Locale_Translate::_("Restart the FTP server:") ?></p>
<p><code>$ sudo service pure-ftpd restart</code></p>

<h2><?php echo Locale_Translate::_("Sword module repository") ?></h2>
<p>
  <?php echo Locale_Translate::_("The Sword module repository it now ready for use.") ?>
  <?php echo Locale_Translate::_("You can add a remote source to your Sword front-end.") ?>
  <?php echo Locale_Translate::_("Bibledit-Web creates four flavours of the Sword module, so there will be four remote sources.") ?>
  <?php echo Locale_Translate::_("If bibledit-web exports a Bible called 'ndebele', then the following four remote sources will work:") ?>
</p>
<table>
  <tr>
    <td><?php echo Locale_Translate::_("Host:") ?></td>
    <td>yourwebsite.org</td>
  </tr>
  <tr>
    <td><?php echo Locale_Translate::_("Directory 1:") ?></td>
    <td>/ndebele/sword/basic-1</td>
  </tr>
  <tr>
    <td><?php echo Locale_Translate::_("Directory 2:") ?></td>
    <td>/ndebele/sword/basic-2</td>
  </tr>
  <tr>
    <td><?php echo Locale_Translate::_("Directory 3:") ?></td>
    <td>/ndebele/sword/full-1</td>
  </tr>
  <tr>
    <td><?php echo Locale_Translate::_("Directory 4:") ?></td>
    <td>/ndebele/sword/full-2</td>
  </tr>
</table>
<br>
<p><a href="http://www.crosswire.org/wiki/Creating_and_Maintaining_a_Module_Repository"><?php echo Locale_Translate::_("More information") ?></a></p>
