<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


class Item {
	// CLASS FUNCTIONS
	// Item
	// selItem
	// insertItem
	// selItemsFromWiki
	// selItems
	// deleteItem
	// selPages
	// selCategories
	// selCategory
	// updateCategory
	// insertCategory
	// selWikiPageNames



	// Item -------------------------------------------------------------
	// the constuctor
	// tom calthrop - 6th December 2004
	//
	function Item($db, $date) {
		$this->db = $db;
		$this->date = $date;
	}//EO Item



	// selItem ----------------------------------------------------------
	//
	function selItem() {
		$query = "
			SELECT i.item_id, i.item_title, i.item_synopsis, 
			i.item_create_datetime, i.item_body, i.item_wiki_page, 
			i.language_id, i.category_id, i.allow_comment, 
			i.beacon_default_page 
			FROM " . $this->db->prefix . "_item i 
			where "
		;
		
		if (isset($this->item_id)) {
		    $query .= "i.item_id='" . $this->item_id . "' AND ";
		}
		elseif (isset($this->item_wiki_page)) {
		    $query .= "i.item_wiki_page='" . $this->item_wiki_page . "' AND ";
		}
		elseif (isset($this->category_id)) {
			$query .= "i.category_id=" . $this->category_id . " AND ";
		}
		else {
		    $query .= "i.beacon_default_page=1 AND ";
		}
		
		if (isset($this->language_id)) {
		    $query .= "i.language_id=" . $this->language_id . " AND ";
		}
		
		
		$query .= "1=1 order by i.item_create_datetime desc";
		
		$result = $this->db->SelectLimit($query, 1);
		
		if (isset($result->fields)) {

			$temp = $result->fields;
			$this->item_id = $temp['item_id'];

			if (!empty($temp['item_create_datetime'])) {
				$temp['item_create_datetime'] = $this->date->formatDate($temp['item_create_datetime'], 1);
			}
			
			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=selItem class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selItem



	// insertItem --------------------------------------------------------------------
	// inserts a single item in the DB
	// tom calthrop - 22nd May 2004
	//
	function insertItem($data) {

		if(empty($data['item_title'])) {
			$GLOBALS['beacon_error_log'][] = array(11, null);
		}

		if(empty($data['item_body'])) {
			$GLOBALS['beacon_error_log'][] = array(12, null);
		}

		if (empty($GLOBALS['beacon_error_log'])) {
			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);
			
			if(empty($data['category_id'])) {
				$data['category_id'] = "null";
			}
			
			if(!empty($data['beacon_default_page'])) {
				$data['beacon_default_page'] = 1;
			}
			else {
				$data['beacon_default_page'] = "null";
			}
			
			if(!empty($data['allow_comment'])) {
				$data['allow_comment'] = 1;
			}
			else {
				$data['allow_comment'] = "null";
			}
			
			$query = "
				INSERT INTO " . $this->db->prefix . "_item (
				item_title,
				item_synopsis,
				item_body,
				item_create_datetime,
				item_wiki_page,
				language_id, 
				category_id, 
				beacon_default_page, 
				allow_comment
				) values (
				'" . $data['item_title'] . "',
				'" . $data['item_synopsis'] . "',
				'" . $data['item_body'] . "',
				" . $datetime . ",
				'" . $data['item_wiki_page'] . "', 
				" . $data['language_id'] . ", 
				" . $data['category_id'] . ", 
				" . $data['beacon_default_page'] . ", 
				" . $data['allow_comment'] . "
				)"
			;
			
			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$query = "
					SELECT item_id
					FROM " . $this->db->prefix . "_item
					WHERE 
					item_create_datetime=" . $datetime
				;

				$result = $this->db->SelectLimit($query, 1);

				if (isset($result->fields['item_id'])) {
					$this->item_id = $result->fields['item_id'];
				}
				else {
					$error_info = "function=insertItem class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['beacon_error_log'][] = array(1, 1, $error_info);
				}
			}
			else {
				$error_info = "function=insertItem class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['beacon_error_log'][] = array(1, $error_info);
			}
		}
	} //EO insertItem
	
	
	// selItems --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// if full is set we select all wikipages else we select only the current
	// tom calthrop - 22nd May 2004
	//
	function selItems($full=null) {
		
		if (!isset($full)) {
			//we get an ID list of each newest item_id
			$query = "
				SELECT i.item_id, i.item_wiki_page 
				FROM " . $this->db->prefix . "_item i
				WHERE "
			;
			
			if (isset($this->language_id)) {
				$query .= "i.language_id=" . $this->language_id . " AND ";
			}
			
			if (isset($this->category_id)) {
				$query .= "i.category_id=" . $this->category_id . " AND ";
			}
			
			$query .="1=1 order by i.item_create_datetime desc";
			
			$result = $this->db->Execute($query);
			
			$this->item_ids = array();
			$old_page_name = "";
			
			if (isset($result->fields)) {
				$temp = array();
			
				while (!$result->EOF) {
					if ($old_page_name <> $result->fields['item_wiki_page']) {
						array_push($this->item_ids, $result->fields['item_id']);
						$old_page_name = $result->fields['item_wiki_page'];
					}
					
					$result->MoveNext();
				}
			}
		}
		
		
		
		$query = "
			SELECT i.item_id, i.item_title, i.item_synopsis, 
			i.item_create_datetime, 
			i.item_wiki_page 
			FROM " . $this->db->prefix . "_item i
			WHERE "
		;
		
		if (isset($this->item_wiki_page)) {
		    $query .= "i.item_wiki_page='" . $this->item_wiki_page . "' AND ";
		}
		
		if (isset($this->category_id)) {
			$query .= "i.category_id=" . $this->category_id . " AND ";
		}
			
		if (isset($this->language_id)) {
		    $query .= "i.language_id=" . $this->language_id . " AND ";
		}
		
		if (isset($this->item_ids)) { //used for bookmarks
			$item_ids = "";
			foreach($this->item_ids as $key => $i):
				$item_ids .= $i;
				if (count($this->item_ids) > $key+1) {
					$item_ids .=",";
				}
			endforeach;
			$query .= "i.item_id in (" . $item_ids . ") AND ";
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by i.item_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['item_create_datetime'] = $this->date->formatDate($temp1['item_create_datetime'], 1);
					
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=selItems class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selItems()



	// deleteItem --------------------------------------------------------------------
	// delete item from DB
	// tom calthrop - 22nd May 2004
	//
	function deleteItems($del_id) {
		$query = "
			DELETE from " . $this->db->prefix . "_item
			WHERE
			item_id = " . $del_id
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$GLOBALS['beacon_error_log'][] = array(1, $query . "-" . $this->db->ErrorMsg());
		}
	}//EO deleteItem



	// selPages --------------------------------------------------------------------
	// used to list the page_names held in this library
	// tom calthrop - 18th May 2004
	//
	function selPages () {

		$query = "
			SELECT DISTINCT item_wiki_page
			FROM " . $this->db->prefix . "_item 
			WHERE "
		;
		
		$query .="1=1 order by item_wiki_page";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
		$temp = array();
		
		while (!$result->EOF) {
			$temp1 = $result->fields['item_wiki_page'];
			array_push($temp, $temp1);
			$result->MoveNext();
		}
		
		$result->Close();
		return $temp;
		}
	}//EO selPages();
	
	
	
	// selCategories --------------------------------------------------------------------
	// returns the categories
	// tom calthrop - 29th May 2005
	//
	function selCategories() {

		$query = "
			SELECT c.category_id, c.category_name, parent_id 
			FROM " . $this->db->prefix . "_category c 
			WHERE "
		;
		
		if (isset($this->language_id)) {
		    $query .= "c.language_id=" . $this->language_id . " AND ";
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by c.parent_id";
		}
		
		//echo $query . "<br>";
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			return $temp;
			
		}
		else {
			$GLOBALS['beacon_error_log'][] = array(1, null);
		}
	} //EO selCategories
	
	
	
	// selCategory --------------------------------------------------------------------
	// returns the category
	// tom calthrop - 29th May 2005
	//
	function selCategory($category_id) {

		$query = "
			SELECT c.category_id, c.category_name, parent_id 
			FROM " . $this->db->prefix . "_category c 
			WHERE 
			category_id=" . $category_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = $result->fields;
			$result->Close();
			return $temp;
			
		}
		else {
			$GLOBALS['beacon_error_log'][] = array(1, null);
		}
	} //EO selCategory
	
	
	
	// updateCategory --------------------------------------------------------------------
	// updates a category
	// tom calthrop - 29th May 2005
	//
	function updateCategory($data) {
		
		$query = "
			UPDATE " . $this->db->prefix . "_category SET
			category_name='" . $data['category_name'] . "' 
			WHERE category_id=" . $data['category_id']
		;
		
		$result = $this->db->Execute($query);
	
		if (empty($result)) {
			$error_info = "function=updateCategory class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	
	} //EO updateCategory();
	
	
	
	// insertCategory --------------------------------------------------------------------
	// inserts a category
	// tom calthrop - 29th May 2005
	//
	function insertCategory($data) {
	
		if (empty($data['parent_id'])) {
		    $data['parent_id'] = 0;
		}
		
		$query = "
			INSERT INTO " . $this->db->prefix . "_category (
			category_name, 
			parent_id,
			language_id,
			user_id)
			values (
			'" . $data['category_name'] . "',
			" . $data['parent_id'] . ",
			" . $this->language_id . ",
			" . $this->user_id . ")"
		;
		
		$result = $this->db->Execute($query);
	
		if (empty($result)) {
			$error_info = "function=insertCategory class=Item.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, $error_info);
		}
	
	} //EO insertCategory();
	
	
	
	// selWikiPageNames --------------------------------------------------------------------
	// returns multiple rows of selWikiPageNames from DB
	// tom calthrop - 27th May 2004
	//
	function selWikiPageNames() {
			$query = "
				SELECT DISTINCT i.item_wiki_page 
				FROM " . $this->db->prefix . "_item i
				ORDER BY i.item_wiki_page "
			;
			
			$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			return $temp;
		}
		else {
			$GLOBALS['beacon_error_log'][] = array(1, null);
		}
	} // EO selWikiPageNames
}

?>
