# This file is part of AROUNDMe
#  
# Copyright (C) 2003, 2007 Barnraiser
# http://www.barnraiser.org/
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with program; see the file COPYING. If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.



# Table structure for table `am_comment`
CREATE TABLE `am_comment` (
  `comment_id` int(11) NOT NULL auto_increment,
  `webspace_id` int(11) NOT NULL,
  `webpage_id` int(11) default NULL,
  `plugin_name` varchar(50) default NULL,
  `plugin_item_id` int(11) default NULL,
  `connection_id` int(11) default NULL,
  `comment_body` text,
  `comment_create_datetime` datetime default NULL,
  PRIMARY KEY  (`comment_id`),
  FULLTEXT KEY `comment_body` (`comment_body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


# Table structure for table `am_connection`
CREATE TABLE `am_connection` (
  `connection_id` int(11) NOT NULL auto_increment,
  `webspace_id` int(11) NOT NULL,
  `connection_openid` varchar(200) NOT NULL,
  `connection_nickname` varchar(255) default NULL,
  `connection_email` varchar(255) default NULL,
  `connection_fullname` varchar(255) default NULL,
  `connection_country` varchar(3) default NULL,
  `connection_language` varchar(3) default NULL,
  `connection_create_datetime` datetime NOT NULL,
  `connection_last_datetime` datetime default NULL,
  `status_id` int(1) NOT NULL,
  `connection_permission` int(11) default NULL,
  `invitee_connection_id` int(11) default NULL,
  PRIMARY KEY  (`connection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_file`
CREATE TABLE `am_file` (
  `file_id` int(11) NOT NULL auto_increment,
  `file_type` varchar(20) default NULL,
  `file_size` int(11) default NULL,
  `file_md5_name` varchar(255) default NULL,
  `webspace_id` int(11) default NULL,
  `connection_id` int(11) default NULL,
  `file_create_datetime` datetime default NULL,
  `file_title` varchar(255) NOT NULL,
  PRIMARY KEY  (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_permission`
CREATE TABLE `am_permission` (
  `plugin_name` varchar(50) NOT NULL,
  `resource_name` varchar(50) NOT NULL,
  `bitwise_operator` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_rate`
CREATE TABLE `am_rate` (
  `webspace_id` int(11) NOT NULL,
  `plugin_name` varchar(50) default NULL,
  `plugin_item_id` int(11) default NULL,
  `connection_id` int(11) default NULL,
  `rate_value` int(1) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_tag`
CREATE TABLE `am_tag` (
  `webspace_id` int(11) default NULL,
  `webpage_id` int(11) default NULL,
  `connection_id` int(11) default NULL,
  `plugin_name` varchar(50) default NULL,
  `plugin_item_id` int(11) default NULL,
  `tag_name` varchar(50) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_webblock`
CREATE TABLE `am_webblock` (
  `webblock_id` int(11) NOT NULL auto_increment,
  `webspace_id` int(11) NOT NULL,
  `webblock_tag` varchar(20) NOT NULL,
  `webblock_body` text,
  PRIMARY KEY  (`webblock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_webpage`
CREATE TABLE `am_webpage` (
  `webpage_id` int(11) NOT NULL auto_increment,
  `webspace_id` int(11) NOT NULL,
  `webpage_body` text,
  `webpage_name` varchar(50) NOT NULL,
  `webpage_title` varchar(200) default NULL,
  `webpage_create_datetime` datetime NOT NULL,
  PRIMARY KEY  (`webpage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


# Table structure for table `am_webspace`
CREATE TABLE `am_webspace` (
  `webspace_id` int(11) NOT NULL auto_increment,
  `owner_connection_id` int(11) NOT NULL,
  `webspace_unix_name` varchar(50) NOT NULL,
  `language_code` varchar(3) default NULL,
  `webspace_description` varchar(255) default NULL,
  `webspace_keywords` varchar(255) default NULL,
  `webspace_title` varchar(200) default NULL,
  `default_webpage_id` int(11) NOT NULL,
  `default_permission` int(11) NOT NULL default 0,
  `webspace_css` text NOT NULL,
  `webspace_create_datetime` datetime NOT NULL,
  `webspace_allocation` int(11) default NULL,
  `webspace_locked` int(1) default NULL,
  `status_id` int(1) default NULL,
  `webspace_maintainer_log` text,
  PRIMARY KEY  (`webspace_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO `am_permission` (`plugin_name`, `resource_name`, `bitwise_operator`) VALUES 
('forum', 'forum_maintain', 2),
('forum', 'add_forum_subject', 8),
('core', 'add_tags', 16),
('blog', 'add_blog', 32),
('event', 'add_event', 64),
('core', 'invite_connections', 128),
('core', 'edit_stylesheet', 256),
('core', 'edit_webpages', 512),
('guestbook', 'add_guestbook', 4),
('wiki', 'edit_wikipage', 1024),
('poll', 'add_poll', 2048),
('guestbook', 'maintain_guestbook', 4096),
('core', 'maintain_connections', 1),
('core', 'view_files', 8192),
('core', 'upload_files', 16384),
('blog', 'blog_maintain', 32768),
('event', 'event_maintain', 65536)
;

