<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>


<div class="plugin_event_item">
	<?php
	if(isset($_SESSION['connection_permission']) && checkPermission('event', 'add_event', $_SESSION['connection_permission']) || isset($_SESSION['connection_permission']) && checkPermission('event', 'event_maintain', $_SESSION['connection_permission'])) {
	?>
	<div class="plugin_event_metadata_top">
		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('event', 'add_event', $_SESSION['connection_permission'])) {
		?>
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=edit_event&amp;c=event"><?php echo $lang['href_add_event'];?></a>
		
		<?php }?>

		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('event', 'event_maintain', $_SESSION['connection_permission'])) {
		?>
		&nbsp;&#124;&nbsp;
		
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=maintain_event&amp;c=event"><?php echo $lang['href_maintain_event'];?></a>
		<?php }?>
	</div>
	<?php }?>
	
	<?php
	if (isset($event)) {
	?>
	<h1><?php echo ucfirst($event['event_title']);?></h1>
	
	<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<td valign="top">
				<b>start time</b><br />
			</td>
			<td valign="top">
				<?php echo am_strftime($event['event_start_datetime'],1);?><br />
			</td>
		</tr>
		<tr>
			<td valign="top">
				<b>end time</b><br />
			</td>
			<td valign="top">
				<?php echo am_strftime($event['event_end_datetime'],1);?><br />
			</td>
		</tr>
		<tr>
			<td valign="top">
				<b>venue</b><br />
			</td>
			<td valign="top">
				<?php echo $event['event_venue'];?><br />
			</td>
		</tr>
		<tr>
			<td valign="top">
				<b>places</b><br />
			</td>
			<td valign="top">
				<?php echo $event['event_allocation'];?><br />
			</td>
		</tr>
	</table>
			
		
	<p>
		<b>details</b><br />
		<?php echo $event['event_body'];?><br />
	</p>
	
	<div class="plugin_event_metadata">
		<?php
		if (isset($_SESSION['connection_id']) && $_SESSION['connection_id'] == $event['connection_id']) {
		?>
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=edit_event&amp;c=event&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;event_id=<?php echo $event['event_id'];?>">edit</a>

		&nbsp;&#124;&nbsp;
		<?php }?>

		<a href="#tag_box_content" onclick="javascript:getTags('event', <?php echo $event['event_id'];?>, <?php echo $webspace['webpage_id'];?>);">tags</a>

		&nbsp;&#124;&nbsp;

		<a href="<?php echo $event['connection_openid'];?>"><?php echo $event['connection_nickname']?></a><br />
	</div>
	<!--
	<div class="plugin_event_attendance">
		<h1>Attendance</h1>
	
		<p>
			<a href="#">Bob</a>, <a href="#">Sarah</a>, <a href="#">James</a>, <a href="#">Brain</a>, <a href="#">Sally</a><br />
		</p>
	
		<input type="submit" value="attend" class="input_submit" />
	</div>-->
	<?php
	}
	else {
	?>
	<p>
		<?php echo $lang['err_no_event'];?>
		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('event', 'add_event', $_SESSION['connection_permission'])) {
		?>
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=edit_event&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;c=event"><?php echo $lang['href_add_event'];?></a>
	<?php }?>
	</p>
	<?php }?>
</div>

<?php
if (isset($event['event_id'])) {
	$plugin_name = "event";
	$tag_item_id = $event['event_id'];
	include($template_path_core . "inc/tags.inc.php");
}
?>