<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2008 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>
<script type="text/javascript">
	var path = '../installation/webspace/img/';
	var layout = 'smorgasbord';
	var css = 'light';
		
	function setWebspaceLayout(id) {
		layout = id;
		
		if (layout == 'expert') {
			var img = layout+'.png';
		}
		else {
			var img = css+'_'+layout+'.png';
		}
		document.getElementById('id_layout').value = layout;
		swapImg(img);
		swapText(id);
	}
			
	function setWebspaceCss(id) {
		css = id;

		if (layout == 'expert') {
			var img = layout+'.png';
		}
		else {
			img = css+'_'+layout+'.png';
		}
		document.getElementById('id_css').value = css;
		swapImg(img);
	}
			
	function swapImg(img) {
		document.getElementById('webspace_preview').src = 'webspace/img/'+img;
	}
			
	var inner_html_blog = "<h3>Blog</h3><p>A blog is a 2 column grid with the right column containing selected (or latest) blog entry. On the left is your identity card, a list of your latest blog entries and a tagcloud.</p>";
	var inner_html_smorgasbord = "<h3>Smorgasbord</h3><p>A smorgasbord is a variety of things spread over a 3 column grid. In the left colum is your identity card and your activity log. In the middle column is guestbook. In the right hand column is your network.</p>";
	var inner_html_basic = "<h3>Minimalist</h3><p>A simple profile page containing only your identity card and a connect box.</p>";
	var inner_html_expert = "<h3>Expert mode</h3><p>A blank home page is set and no CSS added. You should be competent with both HTML and CSS to choose this option!</p>";
			
	function swapText(id) {
		text = 'inner_html_'+id;
		document.getElementById('layout_intro').innerHTML = eval(text);
	}
</script>

	<div id="body_container">
		
		<form method="post"/>
			<div class="box">
				<div class="box_header">
					<h1>Create webspace</h1>
				</div>

				<div class="box_body">
				
					<label for="id_title">title</label>
					<input type="text" id="id_title" name="webspace_title" value="<?php if (isset($_POST['webspace_title'])) echo $_POST['webspace_title']; ?>" />
					
					<h3>Choose look and feel</h3>

					<p>
						Your webspace is your profile page, or presentation. You can customise it to include all sorts of stuff including a blog and a wall. To start with pick the webspace that most closely matches what you want.
					</p>
			
					<p>
						layout 
						<a href="javascript:setWebspaceLayout('blog');">blog</a>, 
						<a href="javascript:setWebspaceLayout('smorgasbord');">smorgasbord</a>, 
						<a href="javascript:setWebspaceLayout('basic');">minimalist</a>, 
						<a href="javascript:setWebspaceLayout('expert');">expert</a>.
						<input type="hidden" value="smorgasbord" id="id_layout" name="layout"/>
						<input type="hidden" value="light" id="id_css" name="css"/>
					</p>
			
					<p>
						style: 
						<a href="javascript:setWebspaceCss('light');">light</a>, 
						<a href="javascript:setWebspaceCss('dark');">dark</a>.
					</p>
					<img id="webspace_preview" src="webspace/img/light_smorgasbord.png" style="border: 1px solid black;" />
					<p id="layout_intro">choose</p>
					
					<p align="right">
						<input type="submit" name="create_webspace" value="create" />
					</p>
				</div>
				<script type="text/javascript">
					swapText('smorgasbord');
				</script>
			</div>
		
		</form>
	</div>