<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>

<?php
if (isset($_SESSION['connection_id'])) {
?>
<form action="index.php?t=network" method="post">

<table cellspacing="0" cellpadding="0" border="0" width="100%">
	<tr>
	<?php
	if (isset($display) && $display == 'applicants') {
	?>
	<td valign="top" width="50%">
		<div class="box">
			<div class="box_header">
				<h1><?php echo $lang['hdr_applicants'];?></h1>
			</div>

			<div class="box_body">
				<?php
				if (isset($webspace_applicants)) {
				?>
				<table cellspacing="0" cellpadding="4" border="0" width="100%">
					<tr>
						<td valign="top">
							<b><?php echo $lang['txt_label_name'];?></b>
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_openid'];?></b>
						</td>
					</tr>
					<?php
					foreach ($webspace_applicants as $key => $i):
					?>
					<tr>
						<td valign="top">
							<a href="index.php?t=network&amp;applicant_id=<?php echo $i['applicant_id'];?>"><?php echo $i['applicant_nickname'];?></a>
						</td>
						<td valign="top">
							<a href="<?php echo $i['applicant_openid'];?>" target="_new"><?php echo $i['applicant_openid'];?></a>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				}
				else {
				?>
				<p>
					<?php echo $lang['error']['no_applications'];?>
				</p>
				<?php }?>
			</div>
		</div>
	</td>

	<td valign="top" width="50%">
		<div class="box">
			<div class="box_header">
				<h1><?php echo $lang['hdr_applicant_details'];?></h1>
			</div>

			<div class="box_body">
				<?php
				if (isset($webspace_applicant)) {
				?>
				<input type="hidden" name="applicant_id" value="<?php echo $webspace_applicant['applicant_id'];?>" />

				<table cellspacing="0" cellpadding="6">
					<tr>
						<td valign="top">
							<b><?php echo $lang['txt_label_nickname'];?></b>
						</td>
						<td valign="top">
							<?php echo $webspace_applicant['applicant_nickname'];?>
						</td>
					</tr>
					<tr>
						<td valign="top">
							<b><?php echo $lang['txt_label_openid'];?></b>
						</td>
						<td valign="top">
							<a href="<?php echo $webspace_applicant['applicant_openid'];?>" target="_new"><?php echo $webspace_applicant['applicant_openid'];?></a>
						</td>
					</tr>
					<tr>
						<td valign="top">
							<b><?php echo $lang['txt_label_email'];?></b>
						</td>
						<td valign="top">
							<a href="mailto:<?php echo $webspace_applicant['applicant_email'];?>"><?php echo $webspace_applicant['applicant_email'];?></a>
						</td>
					</tr>
					<tr>
						<td valign="top">
							<b><?php echo $lang['txt_label_note'];?></b>
						</td>
						<td valign="top">
							<?php echo $webspace_applicant['applicant_note'];?>
						</td>
					</tr>
				</table>

				<p>
					<label for="id_response"><?php echo $lang['txt_label_response'];?></label><br />
					<?php
					$lang['txt_response_message'] = str_replace('SYS_KEYWORD_NICKNAME', $webspace_applicant['applicant_nickname'], $lang['txt_response_message']);
					$url = str_replace('REPLACE', AM_WEBSPACE_NAME, $core_config['am']['domain_replace_pattern']);
					$lang['txt_response_message'] = str_replace('SYS_KEYWORD_URL', $url, $lang['txt_response_message']);
					$lang['txt_response_message'] = str_replace('SYS_KEYWORD_OPENID_NICKNAME', $_SESSION['openid_nickname'], $lang['txt_response_message']);
					$lang['txt_response_message'] = str_replace('SYS_KEYWORD_OPENID', $webspace_applicant['applicant_openid'], $lang['txt_response_message']);
					?>

					<textarea id="id_response" cols="50" rows="6" name="response_email"><?php echo $lang['txt_response_message'];?></textarea>
				</p>

				<p align="right">
					<input type="submit" name="deny_applicant" value="<?php echo $lang['sub_deny_access'];?>" />&nbsp;
					<input type="submit" name="accept_applicant" value="<?php echo $lang['sub_allow_access'];?>" />
				</p>
				<?php
				}
				else {
				?>
				<p>
					<?php echo $lang['txt_applications_intro'];?>
				</p>
				<?php }?>
			</div>
		</div>
	</td>

	<?php
	}
	elseif (isset($display) && $display == 'permissions') {
	?>

	<td valign="top" width="33%">
		<div class="box">
			<div class="box_header">
				<h1><?php echo $lang['hdr_default_permissions'];?></h1>
			</div>

			<div class="box_body">

				<table cellspacing="0" cellpadding="4" border="0" width="100%">
					<?php
					foreach ($core_config['group'] as $key => $i):
					?>
					<tr>
						<td valign="top">
							<?php echo $key;?>
						</td>
						<td valign="top" align="right">
							<?php
							$checked = "";

							if (intval($webspace['default_permission']) & intval($i)) {
								$checked = " checked=\"checked\"";
							}
							?>
							<input type="checkbox" name="bitwise_operators[]" value="<?php echo $i;?>" <?php echo $checked;?> style="margin:2px;" />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>

				<p align="right">
					<input type="submit" name="update_default_permission" value="<?php echo $lang['sub_save'];?>" />
				</p>

				<ul>
					<li><a href="index.php?t=network"><?php echo $lang['href_list'];?></a></li>
				</ul>
			</div>
		</div>
	</td>

	<td valign="top" width="67%">
		<?php
		if (isset($plugin_permissions) && isset($core_config['group'])) {
		?>
		<div class="box">
			<div class="box_header">
				<h1><?php echo $lang['hdr_plugin_permissions'];?></h1>
			</div>

			<div class="box_body">

				<table cellspacing="0" cellpadding="6" border="0" width="100%">
					<?php
					foreach ($plugin_permissions as $key => $i):
					?>
					<tr>
						<td colspan="<?php echo count($core_config['group'])+1;?>">
							<b>
							<?php
							if (isset($lang['plugin_'.$key]['txt_plugin_title'])) {
								echo  $lang['plugin_'.$key]['txt_plugin_title'];
							}
							else {
								echo $key;
							}
							?></b>
						</td>
					</tr>
					<tr>
						<td><br /></td>
						<?php
						foreach ($core_config['group'] as $keyg => $g):
						?>
						<td align="center">
							<?php
							if (isset($lang['arr_group_name'][$keyg])) {
								echo  $lang['arr_group_name'][$keyg];
							}
							else {
								echo $keyg;
							}
							?>
						</td>
						<?php
						endforeach;
						?>
					</tr>
					<?php
					foreach ($i as $keyr => $r): // resources
					?>
					<tr>
						<td>
							<?php
							if (isset($lang['plugin_'.$key]['resource'][$keyr])) {
								echo  $lang['plugin_'.$key]['resource'][$keyr];
							}
							else {
								echo $keyr;
							}
							?>
						</td>
						<?php
						foreach ($core_config['group'] as $keyg => $g):
						?>
						<td align="center">
							<?php
							$checked = "";

							if ($r & $g) {
								$checked = " checked=\"checked\"";
							}
							?>

							<input type="checkbox" name="plugin_permissions[<?php echo $key;?>][<?php echo $keyr;?>][<?php echo $keyg;?>]" value="<?php echo $g;?>"<?php echo $checked;?> />
						</td>
						<?php
						endforeach;
						?>
					</tr>
					<?php
					endforeach;
					endforeach;
					?>
				</table>

				<p align="right">
					<input type="submit" name="update_plugin_permissions" value="<?php echo $lang['sub_save'];?>" />
				</p>
			</div>
		</div>
		<?php }?>
	</td>

	<?php
	}
	elseif (isset($connection)) {
	?>

		<script type="text/javascript">

		function fetchPopLog(identity) {
			str = 'core/get_xml.php';
			p = 'file=' + identity+'/aroundme.xml';

			makeRequest(str, p, displayPopLog);
		}


		function makeRequest(url, parameters, destination) {

			http_request = false;

			if (window.XMLHttpRequest) { // Mozilla, Safari,...
				http_request = new XMLHttpRequest();
				if (http_request.overrideMimeType) {
					// set type accordingly to anticipated content type
					http_request.overrideMimeType('text/xml');
					//http_request.overrideMimeType('text/html');
				}
			}
			else if (window.ActiveXObject) { // IE
				try {
					http_request = new ActiveXObject("Msxml2.XMLHTTP");
				}
				catch (e) {
					try {
						http_request = new ActiveXObject("Microsoft.XMLHTTP");
					}
					catch (e) {
					}
				}
			}

			if (!http_request) {
				alert('Cannot create XMLHTTP instance');
				return false;
			}
			http_request.onreadystatechange = destination;
			http_request.open('POST', url, true);
			http_request.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			http_request.send(parameters);
		}


		function displayPopLog() {
			if (http_request.readyState == 4) {
				if (http_request.status == 200) {
					xmlDoc = http_request.responseXML;

					failure = xmlDoc.getElementsByTagName('failure');

					if (failure.length == 0) {
						friends = xmlDoc.getElementsByTagName('inbound');
						number_of_friends = friends.length;

						//we can also get each friend (your friends friends) and perhaps display their name/id in a list
						//alert(friends[0].getElementsByTagName('identity')[0].firstChild.nodeValue);

						log_entries = xmlDoc.getElementsByTagName('logentry');
						number_of_log_entries = log_entries.length;

						nr_of_connectons_outbound = 0;
						is_vouched_outbound = false;
						reference_outbound = false;

						for(k=0; k < number_of_friends; k++) {
							if (friends[k].getElementsByTagName('identity')[0].firstChild.nodeValue == "<?php echo $_SESSION['openid_identity']; ?>") {
								
								if (friends[k].getElementsByTagName('connections')[0].firstChild.nodeValue != "undefined") {
									nr_of_connectons_outbound = friends[k].getElementsByTagName('connections')[0].firstChild.nodeValue;
								}
								
								if (friends[k].getElementsByTagName('is_vouched')[0].firstChild.nodeValue != "undefined") {
									is_vouched_outbound = friends[k].getElementsByTagName('is_vouched')[0].firstChild.nodeValue;
								}
								
								if (is_vouched_outbound != 0) {
									if (friends[k].getElementsByTagName('reference')[0].firstChild.nodeValue != "undefined") {
										reference_outbound = friends[k].getElementsByTagName('reference')[0].firstChild.nodeValue;
									}
								}
							}
						}

						nickname = xmlDoc.getElementsByTagName('me_nickname')[0].firstChild.nodeValue;

						output = "";

						if (number_of_log_entries > 0) {
							output += "<ul>";
							for(i = number_of_log_entries-1; i >= Math.max(0, number_of_log_entries-11); i--) {
								datetime = log_entries[i].getElementsByTagName('datetime')[0].firstChild.nodeValue;

								/*dateObj = new Date(datetime * 1000);
								dateformat = dateObj.getDate() + '/' + dateObj.getMonth() + ' ' + dateObj.getHours() + ':' + dateObj.getMinutes();*/

								entry = log_entries[i].getElementsByTagName('entry')[0].firstChild.nodeValue;
								output += "<li>" + datetime + ": " + entry + "</li>";
							}
							output += "</ul>";
						}
						else {
							output += "<p>no entries</p>";
						}

					}
					else { // there was a failure
						output = "<p>this person has no network</p>"
					}
					document.getElementById('connection_poplog').innerHTML = output;
				}
				else {
					alert('There was a problem with the request.');
				}
			}
		}
		</script>

		<td valign="top" width="50%">
			<div class="box">
				<div class="box_header">
					<h1><?php echo $lang['hdr_identity'];?></h1>
				</div>

				<div class="box_body">
					<table cellspacing="0" cellpadding="4" border="0" width="100%">
						<tr>
							<?php
							if (isset($connection['connection_avatar'])) {
							?>
							<td width="100" valign="top">
								<img src="<?php echo $connection['connection_openid'] . "/" . $connection['connection_avatar'];?>" width="100" height="100" alt="avatar" />
							</td>
							<?php }?>
							<td valign="top">

								<table cellspacing="0" cellpadding="4" border="0">
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_openid'];?></b>
										</td>
										<td valign="top">
											<a href="<?php echo $connection['connection_openid'];?>"><?php echo $connection['connection_openid'];?></a>
										</td>
									</tr>
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_nickname'];?></b>
										</td>
										<td valign="top">
											<?php echo $connection['connection_nickname'];?>
										</td>
									</tr>
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_email'];?></b>
										</td>
										<td valign="top">
											<?php echo $connection['connection_email'];?>
										</td>
									</tr>
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_fullname'];?></b>
										</td>
										<td valign="top">
											<?php echo $connection['connection_fullname'];?>
										</td>
									</tr>
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_country'];?></b>
										</td>
										<td valign="top">
											<?php
											if (isset($connection['connection_country'])) {
												$connection['connection_country'] = strtoupper($connection['connection_country']);

												if (isset($lang['arr_identity_field']['country'][$connection['connection_country']])) {
													echo $lang['arr_identity_field']['country'][$connection['connection_country']];
												}
												else {
													echo $connection['connection_country'];
												}
											}
											?>
										</td>
									</tr>
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_language'];?></b>
										</td>
										<td valign="top">
											<?php
											if (isset($connection['connection_language'])) {
												$connection['connection_language'] = strtoupper($connection['connection_language']);

												if (isset($lang['arr_identity_field']['language'][$connection['connection_language']])) {
													echo $lang['arr_identity_field']['language'][$connection['connection_language']];
												}
												else {
													echo $connection['connection_language'];
												}
											}
											?>
										</td>
									</tr>
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_create_datetime'];?></b>
										</td>
										<td valign="top">
											<?php echo strftime("%d %b %G %H:%M", $connection['connection_create_datetime']);?>
										</td>
									</tr>
									<tr>
										<td valign="top">
											<b><?php echo $lang['txt_label_last_datetime'];?></b>
										</td>
										<td valign="top">
											<?php echo strftime("%d %b %G %H:%M", $connection['connection_last_datetime']);?>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>

					<ul>
						<li><a href="index.php?t=network"><?php echo $lang['href_list'];?></a></li>
					</ul>
				</div>
			</div>


			<div class="box">
				<div class="box_header">
					<h1><?php echo $lang['hdr_account'];?></h1>
				</div>

				<div class="box_body">
					<p>
						<?php echo $lang['txt_group_membership_intro'];?>
					</p>

					<ul>
						<?php
						foreach ($core_config['group'] as $keyg => $g):
						if ($connection['connection_permission'] & $g) {
						?>
							<li>
							<?php
							if (isset($lang['arr_group_name'][$keyg])) {
								echo  $lang['arr_group_name'][$keyg];
							}
							else {
								echo $keyg;
							}
							?>
							</li>
						<?php
						}
						endforeach;
						?>
					</ul>

					<p>
						<?php echo $lang['txt_permissions_allow_levels'];?>
					</p>

					<table cellspacing="0" cellpadding="4" border="0" width="100%">
						<tr>
							<td valign="top">
								<h2><?php echo $lang['txt_permissions_allowed'];?></h2>

								<ul>
									<?php
									foreach ($plugin_permissions as $key => $i):
									foreach ($i as $keyr => $r): // resources
									if ($r & $connection['connection_permission']) {
									?>

									<li>
										<?php
										if (isset($lang['plugin_'.$key]['resource'][$keyr])) {
											echo  $lang['plugin_'.$key]['resource'][$keyr];
										}
										else {
											echo $keyr;
										}
										?>
									</li>

									<?php
									unset($plugin_permissions[$key][$keyr]);
									}
									endforeach;
									endforeach;
									?>
								</ul>
							</td>
							<td valign="top">
								<h2><?php echo $lang['txt_permissions_denied'];?></h2>

								<ul>
									<?php
									foreach ($plugin_permissions as $key => $i):
									foreach ($i as $keyr => $r): // resources
									?>

									<li>
										<?php
										if (isset($lang['plugin_'.$key]['resource'][$keyr])) {
											echo  $lang['plugin_'.$key]['resource'][$keyr];
										}
										else {
											echo $keyr;
										}
										?>
									</li>

									<?php
									endforeach;
									endforeach;
									?>
								</ul>
							</td>
						</tr>
					</table>

					<p>
						<?php echo $lang['txt_permissions_notes'];?>
					</p>
				</div>
			</div>

			<?php
			if (isset($core_config['group']) && isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $core_config['group']['maintainer']) {
			?>

			<input type="hidden" name="connection_id" value="<?php echo $connection['connection_id'];?>" />

			<div class="box">
				<div class="box_header">
					<h1><?php echo $lang['hdr_group_allocation'];?></h1>
				</div>

				<div class="box_body">
					<table cellspacing="0" cellpadding="4" border="0" width="100%">
						<?php
						foreach ($core_config['group'] as $key => $i):
						$checked = "";
						if (intval($connection['connection_permission']) & intval($i)) {
							$checked = " checked=\"checked\"";
						}
						?>
						<tr>
							<td valign="top">
								<?php
								if (isset($lang['arr_group_name'][$key])) {
									echo  $lang['arr_group_name'][$key];
								}
								else {
									echo $key;
								}
								?>
							</td>
							<td valign="top" width="1">
								<input type="checkbox" name="bitwise_operators[]" value="<?php echo $i;?>" <?php echo $checked;?> style="margin:2px;" />
							</td>
						</tr>
						<?php
						endforeach;
						?>
					</table>

					<p align="right">
						<input type="submit" name="update_connection" value="<?php echo $lang['sub_save'];?>" />
					</p>
				</div>
			</div>

			<div class="box">
				<div class="box_header">
					<h1><?php echo $lang['hdr_set_as_banned'];?></h1>
				</div>

				<div class="box_body">
					<?php
					$checked = "";

					if (isset($connection['status_id']) && $connection['status_id'] == 1) { // connection status - 1 = barred, 2 = active
						$checked = " checked=\"checked\"";
					}
					?>

					<p>
						<label for="id_status_id"><?php echo $lang['txt_label_barred'];?></label>
						<input id="id_status_id" type="checkbox" name="status_id" value="1"<?php echo $checked;?> />
						<br />
					</p>

					<p align="right">
						<input type="submit" name="update_connection" value="<?php echo $lang['sub_save'];?>" />
					</p>
				</div>
			</div>
			<?php }?>
		</td>

		<td valign="top" width="50%">
			<div class="box">
				<div class="box_header">
					<h1><?php echo $lang['hdr_contributions'];?></h1>
				</div>

				<div class="box_body">
					<?php
					if (isset($contribution_includes)) {
						foreach ($contribution_includes as $key => $i):
							if (is_file('plugins/' . $i . '/template/account_contributions.tpl.php')) {
								include_once('plugins/' . $i . '/template/account_contributions.tpl.php');
							}
						endforeach;
					}
					?>
				</div>
			</div>


			<div class="box">
				<div class="box_header">
					<h1><?php echo $lang['hdr_poplog'];?></h1>
				</div>

				<div class="box_body" id="connection_poplog">
					<?php echo $lang['txt_loading'];?>
				</div>
			</div>
		</div>
	</td>

	<script type="text/javascript">
		fetchPopLog('<?php echo $connection['connection_openid']; ?>');
	</script>

	<?php
	}
	else {
	?>
	<td valign="top" width="67%">
		<div class="box">
			<div class="box_header">
				<h1><?php echo $lang['hdr_connections'];?></h1>
			</div>

			<div class="box_body">
				<?php
				if (isset($connections)) {
				?>
				<table cellspacing="2" cellpadding="4" border="0" width="100%">
					<tr>
						<td valign="top">
							<br />
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_nickname'];?></b>
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_country'];?></b>
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_language'];?></b>
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_create_datetime'];?></b>
						</td>
						<td valign="top">
							<b><?php echo $lang['txt_label_last_datetime'];?></b>
						</td>
					</tr>
					<?php
					foreach ($connections as $key => $i):
					?>
					<tr>
						<td valign="top">
							<?php
							if (!empty($i['connection_avatar'])) {
							?>
								<a href="index.php?t=network&amp;connection_id=<?php echo $i['connection_id'];?>" class="avatar"><img src="<?php echo $i['connection_openid'] . "/" . $i['connection_avatar'];?>" width="40" height="40" alt="" border="" /></a>
							<?php
							}
							elseif (isset($i['connection_openid'])) {
							?>
								<a href="index.php?t=network&amp;connection_id=<?php echo $i['connection_id'];?>" class="no_avatar"><div style="width:40px; height:40px;" title="<?php echo $i['connection_nickname']; ?>"></div></a>
							<?php
							}
							else {
							?>
								<div class="avatar_placeholder" style="width:40px; height:40px;"></div>
							<?php }?>
						</td>
						<td valign="top">
							<a href="index.php?t=network&amp;connection_id=<?php echo $i['connection_id'];?>"><?php echo $i['connection_nickname'];?></a>
						</td>
						<td valign="top">
							<?php
							if (isset($i['connection_country'])) {
								$i['connection_country'] = strtoupper($i['connection_country']);

								if (isset($lang['arr_identity_field']['country'][$i['connection_country']])) {
									echo $lang['arr_identity_field']['country'][$i['connection_country']];
								}
								else {
									echo $i['connection_country'];
								}
							}
							?>
						</td>
						<td valign="top">
							<?php
							if (isset($i['connection_language'])) {
								$i['connection_language'] = strtoupper($i['connection_language']);

								if (isset($lang['arr_identity_field']['language'][$i['connection_language']])) {
									echo $lang['arr_identity_field']['language'][$i['connection_language']];
								}
								else {
									echo $i['connection_language'];
								}
							}
							?>
						</td>
						<td valign="top">
							<?php echo strftime("%d %b %G %H:%M", $i['connection_create_datetime']);?>
						</td>
						<td valign="top">
							<?php
							if (isset($i['connection_last_datetime'])) {
							?>
							<?php echo strftime("%d %b %G %H:%M", $i['connection_last_datetime']);?>
							<?php }?>
							<br />
						</td>
						<td valign="top" align="right">
							<?php
							if (isset($i['invitee_connection_id'])) {
							?>
							<?php echo $i['invitee_connection_id'];?>
							<?php }?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				}
				else {
				?>
				<p>
					<?php echo $lang['error']['no_connections'];?>
				</p>
				<?php }?>

				<?php
    			$url = 'index.php?' . http_build_query($_GET);
    			echo $this->paging($total_nr_of_rows, $core_config['display']['max_list_rows'], $url, 'connections');
    			?>
			</div>
		</div>
	</td>

	<td valign="top" width="33%">
		<div class="box">
			<div class="box_header">
				<h1><?php echo $lang['hdr_options'];?></h1>
			</div>

			<div class="box_body">
				<p>
					<label for="id_search"><?php echo $lang['txt_label_search'];?></label><br />
					<input type="text" name="search_text" id="id_search" value="<?php if (isset($_POST['search_text'])) { echo $_POST['search_text'];}?>" />
				</p>

				<p>
					<label for="id_filter"><?php echo $lang['txt_label_filter'];?></label><br />
					<input type="radio" name="filter" value="0" checked="checked" /> All<br />
					<?php
					foreach ($core_config['group'] as $keyg => $g):
					$checked = "";

					if (isset($_POST['filter']) && $_POST['filter'] == $g) {
						$checked = " checked=\"checked\"";
					}
					?>
					<input type="radio" name="filter" value="<?php echo $g;?>"<?php echo $checked;?> />
					<?php
					if (isset($lang['arr_group_name'][$keyg])) {
						echo  $lang['arr_group_name'][$keyg];
					}
					else {
						echo $keyg;
					}
					?><br />
					<?php
					endforeach;
					?>
				</p>

				<p align="right">
					<input type="submit" name="search" value="<?php echo $lang['sub_search'];?>" />
				</p>

				<ul>
					<?php
					if (isset($core_config['group']) && isset($_SESSION['connection_permission']) && $_SESSION['connection_permission'] & $core_config['group']['maintainer']) {
					?>
					<li><a href="index.php?t=network&amp;v=permissions"><?php echo $lang['href_manage_permissions'];?></a></li>
					<?php }?>
				</ul>
			</div>
		</div>
	</td>
	<?php }?>
</tr>
</table>
</form>
<?php
}
else {
?>

<div class="box">
	<div class="box_header">
		<h1><?php echo $lang['hdr_connect_to_view'];?></h1>
	</div>

	<div class="box_body">
		<p>
			<?php echo $lang['txt_connect_to_view'];?>
		</p>

		<ul>
			<li><a href="index.php?t=login"><?php echo $lang['href_connect'];?></a></li>
		</ul>
	</div>
</div>
<?php }?>