<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>

<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

	<title>AROUNDMe c Installer</title>
	
	<style type="text/css">
	<?php include AM_TEMPLATE_PATH . 'css/installer.css'; ?>
	</style>
	
	<!--[if IE]>
	<style type="text/css">
	<?php @include AM_TEMPLATE_PATH . 'css/installer-IE.css'; ?>
	</style>
	<![endif]-->
</head>

<body>

	<?php
	if (!empty($GLOBALS['am_error_log'])) {
	?>
	<div id="error_container">
		<?php
		foreach($GLOBALS['am_error_log'] as $key => $i):
		?>
			<?php
			if (isset($lang['error'][$i[0]])) {
				echo $lang['error'][$i[0]];
			}
			else {
				echo $i[0];
			}
	
			if (!empty($i[1])) {
				echo ": " . $i[1];
			}?>
			<br />
		<?php
		endforeach;
		?>
	</div>
	<?php }?>
	
	<div id="body_container">
		<form method="POST">

		<?php
		if (!isset($display)) {
		?>
		
			<div class="box">
				<h1>AROUNDMe Collaboration server installer</h1>

				<p>
					This installer will install version '<?php echo $core_config['release']['version'];?>' of Barnraisers AROUNDMe Collaboration server.
				</p>
				
				<p>
					The installation is in 3 simple steps; configure your MySQL database, maintainer account and setup. After setup you will be taken to the maintainers area where you can proceed to create your first webspace.
				</p>

				<p>
					Before you begin <b>plan your domain name naming convention</b>. For assistance please read documents/install.txt
				</p>

				<?php
				if (empty($GLOBALS['am_error_log'])) {
				?>
				<p>
					<input type="submit" name="start_install" value="start installation" />
				</p>
				<?php }?>
			</div>

		<?php
		}
		elseif (isset($display) && $display == "setup_database") {
		?>
			<div class="box">
				<h1>Configure database</h1>

				<p>
					<label for="id_database_host">Host</label>
					<input type="text" name="database_host" id="id_database_host" value="<?php if (isset($core_config['db']['host'])) { echo $core_config['db']['host'];}?>" />
					<i>Example: localhost</i>
				</p>

				<p>
					<label for="id_database_user">Username</label>
					<input type="text" name="database_user" id="id_database_user" value="<?php if (isset($core_config['db']['user'])) { echo $core_config['db']['user'];}?>" />
				</p>

				<p>
					<label for="id_database_password">Password</label>
					<input type="text" name="database_password" id="id_database_password" value="<?php if (isset($core_config['db']['password'])) { echo $core_config['db']['password'];}?>" />
				</p>

				<p>
					<label for="id_database_db">Database name</label>
					<input type="text" name="database_db" id="id_database_db" value="<?php if (isset($core_config['db']['db'])) { echo $core_config['db']['db'];} else { echo "aroundme_collaboration";}?>" />
					<i>Example: aroundme_collaboration</i>
				</p>

				<p>
					<input type="submit" name="create_database" value="create database" />
				</p>
			</div>
		
		<?php
		}
		elseif (isset($display) && $display == "setup_maintainer") {
		?>

			<div class="box">
				<h1>Maintainer</h1>
				
				<p>
					<label for="id_openid">OpenID</label><br />
					<input type="text" id="openid_login" name="openid_login" value="http://example.domain.org" onFocus="this.value=''; return false;" />
				</p>
	
				<p align="right">
					<input type="submit" name="connect" value="connect" />
				</p>
	
				<h3>Need an OpenID account?</h3>
	
				<p>
					OpenID is like a digital identity card with which you can show to enter a web site. You get to keep your information in one place and you get to choose which information you wish to present to each web site.
				</p>
	
				<p>
					If you have your own domain name you can host your own OpenID account using <a href="http://www.barnraiser.org/">AROUNDMe Personal identity</a> which is free. Alternatively you can obtain an OPenID account from a service provider such as <a href="http://www.barnraiser.info/">Barnraiser</a>.
				</p>
			</div>
		
		<?php
		}
		elseif (isset($display) && $display == "setup_am") {
		?>

			<div class="box">
				<h1>Setup</h1>

				<p>
					<label for="id_openid">Create</label><br />
					Who can create a webspace?<br />
					<input type="radio" name="webspace_creation_type" value="0" checked="checked" />Only maintainers<br />
					<input type="radio" name="webspace_creation_type" value="1" />Anyone, but they need maintainer approval<br />
					<input type="radio" name="webspace_creation_type" value="2" />Anyone, automatic creation
				</p>
	
				<p align="right">
					<input type="submit" name="setup_webspace" value="save" />
				</p>
			</div>
		<?php }?>
		
		</form>
	</div>
</body>
</html>