<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>

<form action="index.php?t=overview" method="POST">

<table cellspacing="0" cellpadding="0" border="0" width="100%">
	<tr>
		<td valign="top">
			<div class="box">
				<?php
				if(isset($webspaces)) {
				?>
				<div class="box_header">
					<h1><?php echo $lang['hdr_latest_webspaces'];?></h1>
				</div>
			
				<div class="box_body">
					<ul>
						<?php
						foreach($webspaces as $g):
						?>
						<li><a href="<?php echo $g['webspace_url']; ?>"><?php echo $g['webspace_title']; ?></a>, <?php echo $g['webspace_create_datetime']; ?></li>
						<?php
						endforeach;
						?>
					</ul>
				</div>

				<?php
				}
				elseif (isset($search_webspaces)) {
				?>
				<div class="box_header">
					<h1><?php echo $lang['hdr_search_results'];?></h1>
				</div>
			
				<div class="box_body">
					<ul>
						<?php
						foreach($search_groups as $g):
						?>
						<li><b><?php echo $lang['txt_relevance']; ?>: </b> <?php echo $g['percentage'];?>%<br />
							<a href="<?php echo $g['webspace_url']; ?>"><?php echo $g['webspace_title']; ?></a>, <?php echo $g['webspace_create_datetime']; ?></li>
						<?php
						endforeach;
						?>
					</ul>
				</div>
			
				<?php
				}
				else {
				?>
				<div class="box_header">
					<h1><?php echo $lang['hdr_search_results'];?></h1>
				</div>
			
				<div class="box_body">
					<p>
						<?php echo $lang['error']['no_webspaces'];?>
					</p>
				</div>
				<?php } ?>
			</div>
		</td>
		<td valign="top" width="240">
			<div class="box">
				
				<div class="box_header">
					<h1><?php echo $lang['hdr_search'];?></h1>
				</div>
			
				<div class="box_body">
					<p>
						<input type="text" name="search" />
						&nbsp;
						<input type="submit" value="<?php echo $lang['sub_search'];?>" /><br>
					</p>

					<ul>
						<li><a href="index.php?t=overview"><?php echo $lang['href_webspaces'];?></a></li>
					</ul>
				</div>
			</div>

			<?php
			if ($core_config['am']['webspace_creation_type'] == 1 || $core_config['am']['webspace_creation_type'] == 2) {
			?>
			<div class="box">
				<div class="box_header">
					<h1><?php echo $lang['hdr_create_webspace'];?></h1>
				</div>
			
				<div class="box_body">
					<p>
						<?php echo $lang['txt_create_webspace'];?>
					</p>
	
					<ul>
						<li><a href="create/create.php"><?php echo $lang['href_create_webspace'];?></a></li>
					</ul>
				</div>
			</div>
			<?php }?>
		</td>
	</tr>
</table>
</form>