<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// MAIN INCLUDES ---------------------------------------------------------
include ("components/core/config/core.config.php");
include ("components/core/inc/functions.inc.php");


// SESSION HANDLER -------------------------------------------------------
// sets up all session and global vars 
session_name($core_config['node']['php_session_name']);
session_start();


if (isset($_REQUEST['logoff'])) {
	session_unset();
	session_destroy();
	session_write_close();
	header("Location: overview.php");
	exit;
}


// ERROR HANDLING
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['am_error_log'] = array();


// SETUP DATABASE ------------------------------------------------------
require_once('components/core/class/Db.class.php');
$db = new Database($core_config['db']);


// SETUP LANGUAGE
$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];

$locale_code = $installed_server_language_packs[strtoupper($_SESSION['language_code'])];

setlocale(LC_ALL, $locale_code);

$lang = array();
$language_path = "components/core/language/" . $_SESSION['language_code'] . "/";
include_once($language_path . 'common.lang.php');
require_once($language_path . 'maintain.lang.php');

// SETUP TEMPLATE -------------------------------------------
$template_path = "template/";
$component_path = "components/core/";
$template_path_core = $component_path . $template_path;

require_once('components/core/class/Template.class.php');
$tpl = new Template();
$body = new Template();

$script_name = "maintain";


//create trusted root
$trusted_root = "http://" . $_SERVER['HTTP_HOST'] . dirname ($_SERVER['PHP_SELF']);

if (substr($trusted_root, -1, 1) != "/") {
	$trusted_root .= "/";
}


//create return_to path
$return_to = "http://" . $_SERVER['HTTP_HOST'] . dirname ($_SERVER['PHP_SELF']);

if (substr($return_to, -1, 1) != "/") {
	$return_to .= "/";
}
$return_to .= 'maintain.php';

if (isset($_POST['commit'])) {
	if (!empty($_POST['openid_login'])) {

		include_once ('components/core/class/Openid.class.php');

		$openid = new SimpleOpenID($db, $core_config);
		$openid->SetIdentity($_POST['openid_login']);
		$openid->SetTrustRoot($trusted_root);
		$openid->SetApprovedURL($return_to);
		$openid->SetRequiredFields(array('nickname'));
		$openid->SetOptionalFields(array('fullname', 'email', 'country', 'language'));
		if ($openid->GetOpenIDServer()) {
			$openid->SetApprovedURL($trusted_root);
			$openid->SetApprovedURL($return_to);
			$openid->Redirect();
			exit;
		}
		else {
			$error = $openid->GetError();
			$GLOBALS['am_error_log'][] = array('login_failed');
		}
	}
}
elseif (isset($_GET['openid_mode'])) {

	if ($_GET['openid_mode'] == 'id_res') {

		include_once ('components/core/class/Openid.class.php');

		$openid = new SimpleOpenID($db, $core_config);
		$openid->SetIdentity($_GET['openid_identity']);
		if ($openid->ValidateWithServer()) {
			
			$openid = $_GET['openid_identity'];
	
			if(substr($openid,-1,1) == '/') {
				$openid = substr($openid, 0, strlen($openid)-1);
			}
	
			if(strpos($openid, 'http://') === false) {
				$openid = 'http://'.$openid;
			}
		
			if (in_array($openid, $core_config['resource']['maintainer_openid'])) {
			
				$_SESSION['openid_identity'] = $openid;
				
				$_SESSION['maintainer'] =  1;
				
				$_SESSION['level_id'] =  64;
				
				$_SESSION['openid_nickname'] = $_GET['openid_sreg_nickname'];

				header("Location: maintain.php");
				exit;
			}
			else {
				$GLOBALS['am_error_log'][] = array ($lang['error']['not_maintainer']);
			}
		}
	}
}


if (isset($_SESSION['maintainer']) && $_SESSION['maintainer'] == 1) {

	if (isset($_POST['update_webspace'])) {

		if (!is_numeric($_POST['webspace_allocation'])) {
			$GLOBALS['am_error_log'][] = array('webspace_allocation_error');
		}
		
		$_POST['webspace_maintainer_log'] = strip_tags($_POST['webspace_maintainer_log']);

		$query = "
			UPDATE " . $db->prefix . "_webspace
			SET
			webspace_allocation=" . $_POST['webspace_allocation'] . ",
			status_id=" . $_POST['status_id']
		;

		if (!empty($_POST['webspace_maintainer_log'])) {
			$query .= ", webspace_maintainer_log=" . $db->qstr($_POST['webspace_maintainer_log']) . " ";
		}

		$query .= " WHERE webspace_id=" . $_POST['webspace_id'];
		
		
		$result = $db->Execute($query);

		$_REQUEST['webspace_id'] = $_POST['webspace_id'];
	}
	elseif (isset($_POST['insert_webspace'])) {

		if (empty($_POST['openid_login'])) {
			$GLOBALS['am_error_log'][] = array('openid_empty');
		}
		
		if (empty($_POST['unix_name'])) {
			$GLOBALS['am_error_log'][] = array('unix_name_empty');
		}
		elseif (!preg_match('/^[A-Za-z0-9.~]+$/', $_POST['unix_name'])) {
			$GLOBALS['am_error_log'][] = array('unix_name_incorrect');
		}
		elseif (strlen($_POST['unix_name']) < 3) {
			$GLOBALS['am_error_log'][] = array('unix_name_short');
		}

		if (empty($_POST['webspace_title'])) {
			$GLOBALS['am_error_log'][] = array('title_empty');
		}

		if (empty($_POST['webspace_description'])) {
			$GLOBALS['am_error_log'][] = array('description_empty');
		}
			
		if (empty($GLOBALS['am_error_log'])) {
			if ($core_config['am']['webspace_creation_type'] === 2) {
				$status_id = $core_config['webspace']['status']['active'];
			}
			else {
				$status_id = $core_config['webspace']['status']['pending'];
			}

			if (empty($_POST['language_code'])) {
				$_POST['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
			}

			
			// get layout
			$component_path = "components/core/";
			$webspace_css = @file_get_contents(dirname(__FILE__) . "/" . $component_path . "template/layouts/" . $_POST['layout'] . '/css/style.css');

			$page_set = @scandir(dirname(__FILE__) . "/" . $component_path . "template/layouts/" . $_POST['layout'] . "/pages");

			
			// insert the webspace
			$data = array();
			$data['webspace_unix_name'] = $_POST['unix_name'];
			$data['webspace_create_datetime'] = time();
			$data['language_code'] = $_POST['language_code'];
			$data['webspace_allocation'] = $core_config['file']['default_allocation'];
			$data['status_id'] = $status_id;
			$data['webspace_title'] = $_POST['webspace_title'];
			$data['webspace_description'] = $_POST['webspace_description'];

			if (!empty($webspace_css)) {
				$data['webspace_css'] = $webspace_css;
			}
			
			if (!empty($_POST['webspace_locked'])) {
				$data['webspace_locked'] = 1;
			}

			$table = $db->prefix . "_webspace";
			
			$db->insertDB($data, $table);
	
			$webspace_id = $db->insertID();
	
			if (isset($webspace_id)) {
				// insert layout pages
				$data = array();
				$data['webspace_id'] = $webspace_id;

				foreach($page_set as $p) {

					$webpage_body = file_get_contents(dirname(__FILE__) . "/" . $component_path . "template/layouts/" . $_POST['layout'] . "/pages/" . $p);
					$webpage_name = explode('.', $p);
					$webpage_name = ucfirst(strtolower($webpage_name[0]));

					$data['webpage_body'] = $webpage_body;
					$data['webpage_name'] = $webpage_name;
					$data['webpage_title'] = $webpage_name;
					$data['webpage_create_datetime'] = time();
	
					$table = $db->prefix . '_webpage';
	
					$db->insertDB($data, $table);
	
					if ($webpage_name == "Home") {
						$default_webpage_id = $db->insertID();
					}
				}
	
				unset($data);
	
				if (!isset($default_webpage_id)) {
					$default_webpage_id = $db->insertID();
				}
	
	
				// get permissions
				$maintainer_permissions=0;
	
				// get permissions
				$query = "
					SELECT *
					FROM " . $db->prefix . "_permission
					ORDER BY plugin_name"
				;
	
				$result = $db->Execute($query);
	
				if (isset($result)) {
					foreach($result as  $key => $i) :
						$maintainer_permissions = $maintainer_permissions+$i['bitwise_operator'];
					endforeach;
				}
				
				// insert the connection
				$openid = $_POST['openid_login'];

				if(substr($openid,-1,1) == '/') {
					$openid = substr($openid, 0, strlen($openid)-1);
				}
		
				if(strpos($openid, 'http://') === false) {
					$openid = 'http://'.$openid;
				}

			
				$rec = array();
				$rec['webspace_id'] = $webspace_id;
				$rec['connection_create_datetime'] = time();
				$rec['status_id'] = $core_config['connection']['status']['active'];
				$rec['connection_openid'] = $openid;
				$rec['connection_nickname'] = $lang['txt_owner_nickname'];
				$rec['connection_permission'] = $maintainer_permissions;

				$table = $db->prefix . "_connection";
			
				$db->insertDB($rec, $table);
	
				$connection_id = $db->insertID();

				// we update the webspace with the owner connection and default page_id
				$query = "
					UPDATE " . $db->prefix . "_webspace
					SET
					owner_connection_id=" . $connection_id . ",
					default_webpage_id=" . $default_webpage_id . " 
					WHERE webspace_id=" . $webspace_id
				;

				$db->Execute($query);
				
				$_REQUEST['webspace_id'] = $webspace_id;
			}
		}
		else {
			$_REQUEST['add'] = 1;
		}
	}

	
	if (!empty($_REQUEST['webspace_id'])) {

		$query = "
			SELECT ws.webspace_id, c.connection_openid, c.connection_email, ws.webspace_unix_name,
			ws.language_code, UNIX_TIMESTAMP(ws.webspace_create_datetime) as webspace_create_datetime,
			ws.webspace_allocation, ws.status_id, ws.webspace_maintainer_log,
			c.connection_fullname, c.connection_nickname, ws.webspace_locked, ws.webspace_description 
			FROM " . $db->prefix . "_webspace ws, " . $db->prefix . "_connection c
			WHERE
			ws.owner_connection_id=c.connection_id AND 
			ws.webspace_id=" . $_REQUEST['webspace_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			$body->set('webspace', $result[0]);
		}

		$body->set('display', 'maintain');
	}
	elseif (!empty($_REQUEST['add'])) {
		require_once($language_path . 'admin_webspace.lang.php');

		$output_layouts = array();
		
		// obtain the layouts
		foreach (glob(dirname(__FILE__) . '/' . $component_path . 'template/layouts/*/language/' . $_SESSION['language_code'] . '/layout.lang.php') as $f):
			
			unset ($lang['layout_title'], $lang['layout_description'], $layout_temp);
			
			// GET NAME
			$pattern = "/template\/layouts\/(.*?)\/language/";
		
			if (preg_match ($pattern, $f, $dname)) {
				if (!empty($dname[1])) {
					
					include_once($f);
					
					$layout_temp['name'] = $dname[1];
					
					if (isset($lang['layout_title'])) {
						$layout_temp['title'] = $lang['layout_title'];
					}
					else {
						$layout_temp['title'] = "";
					}

					if (isset($lang['layout_description'])) {
						$layout_temp['description'] = $lang['layout_description'];
					}
					else {
						$layout_temp['description'] = "";
					}
					
					array_push ($output_layouts, $layout_temp);
				}
			}
		endforeach;

		if (!empty($output_layouts)) {
			$body->set('layouts', $output_layouts);
		}
		
		$body->set('allow_add', 1);

		$body->set('display', 'maintain');
	}
	else {
	
		$query = "
			SELECT ws.webspace_id, c.connection_openid, c.connection_email, ws.webspace_unix_name,
			ws.language_code, UNIX_TIMESTAMP(ws.webspace_create_datetime) as webspace_create_datetime,
			ws.webspace_allocation, ws.status_id 
			FROM " . $db->prefix . "_webspace ws, " . $db->prefix . "_connection c
			WHERE
			ws.owner_connection_id=c.connection_id AND "
		;

		if (isset($_REQUEST['status']) && $_REQUEST['status'] == 2) { // barred
			$query .= "ws.status_id=2 AND ";
		}
		elseif (isset($_REQUEST['status']) && $_REQUEST['status'] == 3) { // live
			$query .= "ws.status_id=3 AND ";
		}
		elseif (!empty($_REQUEST['claimed'])) { // live
			$query .= "ws.status_id is NULL AND ";
		}
		else { // pending
			$query .= "ws.status_id=1 AND ";
		}
		
		$query .= "1=1 ORDER BY ws.webspace_unix_name";
		
		$result = $db->Execute($query);
		
		if (!empty($result)) {
			$body->set('webspaces', $result);
		}

		$body->set('display', 'maintain');
	}
}
else {
	unset($_SESSION);
}

$tpl->set('lang', $lang);
$body->set('lang', $lang);
$tpl->set('template_path_core', $template_path_core);
$body->set('template_path_core', $template_path_core);
$body->set('core_config', $core_config);
$tpl->set('core_config', $core_config);

//unset($tpl->vars['webspace']['webspace_css']);
$template_file = $script_name . ".tpl.php";
$tpl->set('content', $body->fetch($component_path . $template_path . $template_file));

echo $tpl->fetch($template_path_core . 'wrapper.tpl.php');
?>